# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    """


class AttestationStatus(ProxyResource):
    """The attestation status of the virtual machine.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.AttestationStatusProperties
    """

    properties: Optional["_models.AttestationStatusProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AttestationStatusProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AttestationStatusProperties(_Model):
    """Defines the attestation status properties.

    :ivar attest_secure_boot_enabled: The status of whether secure boot is enabled. Known values
     are: "Enabled", "Disabled", and "Unknown".
    :vartype attest_secure_boot_enabled: str or
     ~azure.mgmt.azurestackhcivm.models.AttestSecureBootPropertyEnum
    :ivar attestation_cert_validated: The status of whether attestation certificate is validated.
     Known values are: "Valid", "Invalid", and "Unknown".
    :vartype attestation_cert_validated: str or
     ~azure.mgmt.azurestackhcivm.models.AttestCertPropertyEnum
    :ivar boot_integrity_validated: The status of whether the list of boot integrity properties is
     validated. Known values are: "Valid", "Invalid", and "Unknown".
    :vartype boot_integrity_validated: str or
     ~azure.mgmt.azurestackhcivm.models.AttestBootIntegrityPropertyEnum
    :ivar linux_kernel_version: kernel version string for Linux VM.
    :vartype linux_kernel_version: str
    :ivar health_status: The health status of attestation validation and parsing. Known values are:
     "Pending", "Healthy", "Unhealthy", and "Unknown".
    :vartype health_status: str or ~azure.mgmt.azurestackhcivm.models.AttestHealthStatusEnum
    :ivar timestamp: The time stamp of the last time attestation token is validated by relying
     party service.
    :vartype timestamp: str
    :ivar error_message: The error message of attestation validation and parsing.
    :vartype error_message: str
    :ivar provisioning_state: Provisioning state of the virtual machine instance. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar attest_hardware_platform: The hardware platform information from attestation token. This
     only applies to Confidential VM. Known values are: "SEVSNP" and "Unknown".
    :vartype attest_hardware_platform: str or
     ~azure.mgmt.azurestackhcivm.models.AttestHWPlatformEnum
    :ivar attest_disk_security_encryption_type: The managed disk security encryption type from
     attestation token. This only applies to Confidential VM. Known values are: "NonPersistedTPM"
     and "Unknown".
    :vartype attest_disk_security_encryption_type: str or
     ~azure.mgmt.azurestackhcivm.models.AttestDiskSecurityEncryptionTypeEnum
    """

    attest_secure_boot_enabled: Optional[Union[str, "_models.AttestSecureBootPropertyEnum"]] = rest_field(
        name="attestSecureBootEnabled", visibility=["read"]
    )
    """The status of whether secure boot is enabled. Known values are: \"Enabled\", \"Disabled\", and
     \"Unknown\"."""
    attestation_cert_validated: Optional[Union[str, "_models.AttestCertPropertyEnum"]] = rest_field(
        name="attestationCertValidated", visibility=["read"]
    )
    """The status of whether attestation certificate is validated. Known values are: \"Valid\",
     \"Invalid\", and \"Unknown\"."""
    boot_integrity_validated: Optional[Union[str, "_models.AttestBootIntegrityPropertyEnum"]] = rest_field(
        name="bootIntegrityValidated", visibility=["read"]
    )
    """The status of whether the list of boot integrity properties is validated. Known values are:
     \"Valid\", \"Invalid\", and \"Unknown\"."""
    linux_kernel_version: Optional[str] = rest_field(name="linuxKernelVersion", visibility=["read"])
    """kernel version string for Linux VM."""
    health_status: Optional[Union[str, "_models.AttestHealthStatusEnum"]] = rest_field(
        name="healthStatus", visibility=["read"]
    )
    """The health status of attestation validation and parsing. Known values are: \"Pending\",
     \"Healthy\", \"Unhealthy\", and \"Unknown\"."""
    timestamp: Optional[str] = rest_field(visibility=["read"])
    """The time stamp of the last time attestation token is validated by relying party service."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """The error message of attestation validation and parsing."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the virtual machine instance. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    attest_hardware_platform: Optional[Union[str, "_models.AttestHWPlatformEnum"]] = rest_field(
        name="attestHardwarePlatform", visibility=["read"]
    )
    """The hardware platform information from attestation token. This only applies to Confidential VM.
     Known values are: \"SEVSNP\" and \"Unknown\"."""
    attest_disk_security_encryption_type: Optional[Union[str, "_models.AttestDiskSecurityEncryptionTypeEnum"]] = (
        rest_field(name="attestDiskSecurityEncryptionType", visibility=["read"])
    )
    """The managed disk security encryption type from attestation token. This only applies to
     Confidential VM. Known values are: \"NonPersistedTPM\" and \"Unknown\"."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.azurestackhcivm.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.azurestackhcivm.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.azurestackhcivm.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtendedLocation(_Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "CustomLocation"
    :vartype type: str or ~azure.mgmt.azurestackhcivm.models.ExtendedLocationTypes
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extended location."""
    type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the extended location. \"CustomLocation\""""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtensionResource(Resource):
    """The base extension resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    """


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImage(TrackedResource):
    """The gallery images resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.GalleryImageProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.GalleryImageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.GalleryImageProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageIdentifier(_Model):
    """This is the gallery image definition identifier.

    :ivar publisher: The name of the gallery image definition publisher. Required.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer. Required.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU. Required.
    :vartype sku: str
    """

    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the gallery image definition publisher. Required."""
    offer: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the gallery image definition offer. Required."""
    sku: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the gallery image definition SKU. Required."""

    @overload
    def __init__(
        self,
        *,
        publisher: str,
        offer: str,
        sku: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageProperties(_Model):
    """Properties under the gallery image resource.

    :ivar container_id: Storage ContainerID of the storage container to be used for gallery image.
    :vartype container_id: str
    :ivar image_path: location of the image the gallery image should be created from.
    :vartype image_path: str
    :ivar os_type: Operating system type that the gallery image uses [Windows, Linux]. Required.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhcivm.models.OperatingSystemTypes
    :ivar cloud_init_data_source: Datasource for the gallery image when provisioning with
     cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
    :vartype cloud_init_data_source: str or ~azure.mgmt.azurestackhcivm.models.CloudInitDataSource
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhcivm.models.HyperVGeneration
    :ivar vm_image_repository_credentials: The credentials used to login to the image repository
     that has access to the specified image.
    :vartype vm_image_repository_credentials:
     ~azure.mgmt.azurestackhcivm.models.VmImageRepositoryCredentials
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.azurestackhcivm.models.GalleryImageIdentifier
    :ivar version: Specifies information about the gallery image version that you want to create or
     update.
    :vartype version: ~azure.mgmt.azurestackhcivm.models.GalleryImageVersion
    :ivar provisioning_state: Provisioning state of the gallery image. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar status: The observed state of gallery images.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.GalleryImageStatus
    :ivar source_virtual_machine_id: Resource ID of the source virtual machine from whose OS disk
     the gallery image is created.
    :vartype source_virtual_machine_id: str
    """

    container_id: Optional[str] = rest_field(
        name="containerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage ContainerID of the storage container to be used for gallery image."""
    image_path: Optional[str] = rest_field(name="imagePath", visibility=["read", "create", "update", "delete", "query"])
    """location of the image the gallery image should be created from."""
    os_type: Union[str, "_models.OperatingSystemTypes"] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operating system type that the gallery image uses [Windows, Linux]. Required. Known values are:
     \"Windows\" and \"Linux\"."""
    cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = rest_field(
        name="cloudInitDataSource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]. Known
     values are: \"NoCloud\" and \"Azure\"."""
    hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = rest_field(
        name="hyperVGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hypervisor generation of the Virtual Machine [V1, V2]. Known values are: \"V1\" and \"V2\"."""
    vm_image_repository_credentials: Optional["_models.VmImageRepositoryCredentials"] = rest_field(
        name="vmImageRepositoryCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """The credentials used to login to the image repository that has access to the specified image."""
    identifier: Optional["_models.GalleryImageIdentifier"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the gallery image definition identifier."""
    version: Optional["_models.GalleryImageVersion"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the gallery image version that you want to create or update."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the gallery image. Known values are: \"Succeeded\", \"Failed\",
     \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    status: Optional["_models.GalleryImageStatus"] = rest_field(visibility=["read"])
    """The observed state of gallery images."""
    source_virtual_machine_id: Optional[str] = rest_field(
        name="sourceVirtualMachineId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of the source virtual machine from whose OS disk the gallery image is created."""

    @overload
    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        container_id: Optional[str] = None,
        image_path: Optional[str] = None,
        cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        vm_image_repository_credentials: Optional["_models.VmImageRepositoryCredentials"] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        version: Optional["_models.GalleryImageVersion"] = None,
        source_virtual_machine_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageStatus(_Model):
    """The observed state of gallery images.

    :ivar error_code: GalleryImage provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: provisioning status of the gallery image.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.GalleryImageStatusProvisioningStatus
    :ivar download_status: The download status of the gallery image.
    :vartype download_status: ~azure.mgmt.azurestackhcivm.models.GalleryImageStatusDownloadStatus
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """GalleryImage provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.GalleryImageStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """provisioning status of the gallery image."""
    download_status: Optional["_models.GalleryImageStatusDownloadStatus"] = rest_field(
        name="downloadStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The download status of the gallery image."""
    progress_percentage: Optional[int] = rest_field(
        name="progressPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The progress of the operation in percentage."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.GalleryImageStatusProvisioningStatus"] = None,
        download_status: Optional["_models.GalleryImageStatusDownloadStatus"] = None,
        progress_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageStatusDownloadStatus(_Model):
    """The download status of the gallery image.

    :ivar download_size_in_mb: The downloaded sized of the image in MB.
    :vartype download_size_in_mb: int
    """

    download_size_in_mb: Optional[int] = rest_field(
        name="downloadSizeInMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The downloaded sized of the image in MB."""

    @overload
    def __init__(
        self,
        *,
        download_size_in_mb: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageStatusProvisioningStatus(_Model):
    """The status of the operation performed on the gallery image.

    :ivar operation_id: The ID of the operation performed on the gallery image.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the gallery image [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the gallery image."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the gallery image [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageTagsUpdate(_Model):
    """The type used for updating tags in GalleryImage resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageVersion(_Model):
    """Specifies information about the gallery image version that you want to create or update.

    :ivar name: This is the version of the gallery image.
    :vartype name: str
    :ivar properties: Describes the properties of a gallery image version.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.GalleryImageVersionProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This is the version of the gallery image."""
    properties: Optional["_models.GalleryImageVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the properties of a gallery image version."""

    __flattened_items = ["storage_profile"]

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.GalleryImageVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GalleryImageVersionProperties(_Model):
    """Describes the properties of a gallery image version.

    :ivar storage_profile: This is the storage profile of a Gallery Image Version. Required.
    :vartype storage_profile: ~azure.mgmt.azurestackhcivm.models.GalleryImageVersionStorageProfile
    """

    storage_profile: "_models.GalleryImageVersionStorageProfile" = rest_field(
        name="storageProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the storage profile of a Gallery Image Version. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_profile: "_models.GalleryImageVersionStorageProfile",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryImageVersionStorageProfile(_Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.azurestackhcivm.models.GalleryOSDiskImage
    """

    os_disk_image: Optional["_models.GalleryOSDiskImage"] = rest_field(
        name="osDiskImage", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the OS disk image."""

    @overload
    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.GalleryOSDiskImage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GalleryOSDiskImage(_Model):
    """This is the OS disk image.

    :ivar size_in_mb: This property indicates the size of the VHD to be created.
    :vartype size_in_mb: int
    """

    size_in_mb: Optional[int] = rest_field(name="sizeInMB", visibility=["read"])
    """This property indicates the size of the VHD to be created."""


class GuestAgent(ProxyResource):
    """Defines the GuestAgent.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.GuestAgentProperties
    """

    properties: Optional["_models.GuestAgentProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GuestAgentProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GuestAgentInstallStatus(_Model):
    """Defines the status of a guest agent installation.

    :ivar vm_uuid: Specifies the VM's unique SMBIOS ID.
    :vartype vm_uuid: str
    :ivar status: The installation status of the hybrid machine agent installation. Known values
     are: "Succeeded", "InProgress", and "Failed".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: ~datetime.datetime
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.azurestackhcivm.models.ErrorDetail]
    """

    vm_uuid: Optional[str] = rest_field(name="vmUuid", visibility=["read"])
    """Specifies the VM's unique SMBIOS ID."""
    status: Optional[Union[str, "_models.StatusTypes"]] = rest_field(visibility=["read"])
    """The installation status of the hybrid machine agent installation. Known values are:
     \"Succeeded\", \"InProgress\", and \"Failed\"."""
    last_status_change: Optional[datetime.datetime] = rest_field(
        name="lastStatusChange", visibility=["read"], format="rfc3339"
    )
    """The time of the last status change."""
    agent_version: Optional[str] = rest_field(name="agentVersion", visibility=["read"])
    """The hybrid machine agent full version."""
    error_details: Optional[List["_models.ErrorDetail"]] = rest_field(name="errorDetails", visibility=["read"])
    """Details about the error state."""


class GuestAgentProperties(_Model):
    """Defines the resource properties.

    :ivar credentials: Username / Password Credentials to provision guest agent.
    :vartype credentials: ~azure.mgmt.azurestackhcivm.models.GuestCredential
    :ivar provisioning_action: The guest agent provisioning action. Known values are: "install",
     "uninstall", and "repair".
    :vartype provisioning_action: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningAction
    :ivar status: The guest agent status.
    :vartype status: str
    :ivar provisioning_state: Provisioning state of the virtual machine instance. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    """

    credentials: Optional["_models.GuestCredential"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Username / Password Credentials to provision guest agent."""
    provisioning_action: Optional[Union[str, "_models.ProvisioningAction"]] = rest_field(
        name="provisioningAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The guest agent provisioning action. Known values are: \"install\", \"uninstall\", and
     \"repair\"."""
    status: Optional[str] = rest_field(visibility=["read"])
    """The guest agent status."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the virtual machine instance. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        credentials: Optional["_models.GuestCredential"] = None,
        provisioning_action: Optional[Union[str, "_models.ProvisioningAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GuestCredential(_Model):
    """Username / Password Credentials to connect to guest.

    :ivar username: The username to connect with the guest.
    :vartype username: str
    :ivar password: The password to connect with the guest.
    :vartype password: str
    """

    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The username to connect with the guest."""
    password: Optional[str] = rest_field(visibility=["create", "update"])
    """The password to connect with the guest."""

    @overload
    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HardwareProfileUpdate(_Model):
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance.

    :ivar vm_size: VM Size Enum. Known values are: "Default", "Standard_A2_v2", "Standard_A4_v2",
     "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
     "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
     "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
     "Standard_K8S5_v1", and "Custom".
    :vartype vm_size: str or ~azure.mgmt.azurestackhcivm.models.VmSizeEnum
    :ivar processors: number of processors for the virtual machine instance.
    :vartype processors: int
    :ivar memory_mb: RAM in MB for the virtual machine instance.
    :vartype memory_mb: int
    :ivar virtual_machine_gp_us: virtualMachineGPUs - updated list of GPUs on the virtual machine
     instance.
    :vartype virtual_machine_gp_us:
     list[~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU]
    """

    vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = rest_field(
        name="vmSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """VM Size Enum. Known values are: \"Default\", \"Standard_A2_v2\", \"Standard_A4_v2\",
     \"Standard_D2s_v3\", \"Standard_D4s_v3\", \"Standard_D8s_v3\", \"Standard_D16s_v3\",
     \"Standard_D32s_v3\", \"Standard_DS2_v2\", \"Standard_DS3_v2\", \"Standard_DS4_v2\",
     \"Standard_DS5_v2\", \"Standard_DS13_v2\", \"Standard_K8S_v1\", \"Standard_K8S2_v1\",
     \"Standard_K8S3_v1\", \"Standard_K8S4_v1\", \"Standard_NK6\", \"Standard_NK12\",
     \"Standard_NV6\", \"Standard_NV12\", \"Standard_K8S5_v1\", and \"Custom\"."""
    processors: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """number of processors for the virtual machine instance."""
    memory_mb: Optional[int] = rest_field(name="memoryMB", visibility=["read", "create", "update", "delete", "query"])
    """RAM in MB for the virtual machine instance."""
    virtual_machine_gp_us: Optional[
        List["_models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU"]
    ] = rest_field(name="virtualMachineGPUs", visibility=["read", "create", "update", "delete", "query"])
    """virtualMachineGPUs - updated list of GPUs on the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = None,
        processors: Optional[int] = None,
        memory_mb: Optional[int] = None,
        virtual_machine_gp_us: Optional[
            List["_models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU"]
        ] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HttpProxyConfiguration(_Model):
    """HTTP Proxy configuration for the VM.

    :ivar http_proxy: The HTTP proxy server endpoint to use.
    :vartype http_proxy: str
    :ivar https_proxy: The HTTPS proxy server endpoint to use.
    :vartype https_proxy: str
    :ivar no_proxy: The endpoints that should not go through proxy.
    :vartype no_proxy: list[str]
    :ivar trusted_ca: Alternative CA cert to use for connecting to proxy servers.
    :vartype trusted_ca: str
    """

    http_proxy: Optional[str] = rest_field(name="httpProxy", visibility=["read", "create", "update", "delete", "query"])
    """The HTTP proxy server endpoint to use."""
    https_proxy: Optional[str] = rest_field(
        name="httpsProxy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The HTTPS proxy server endpoint to use."""
    no_proxy: Optional[List[str]] = rest_field(
        name="noProxy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The endpoints that should not go through proxy."""
    trusted_ca: Optional[str] = rest_field(name="trustedCa", visibility=["read", "create", "update", "delete", "query"])
    """Alternative CA cert to use for connecting to proxy servers."""

    @overload
    def __init__(
        self,
        *,
        http_proxy: Optional[str] = None,
        https_proxy: Optional[str] = None,
        no_proxy: Optional[List[str]] = None,
        trusted_ca: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HybridIdentityMetadata(ProxyResource):
    """Defines the HybridIdentityMetadata.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.HybridIdentityMetadataProperties
    """

    properties: Optional["_models.HybridIdentityMetadataProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.HybridIdentityMetadataProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HybridIdentityMetadataProperties(_Model):
    """Defines the resource properties.

    :ivar resource_uid: The unique identifier for the resource.
    :vartype resource_uid: str
    :ivar public_key: The Public Key.
    :vartype public_key: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.azurestackhcivm.models.Identity
    :ivar provisioning_state: Provisioning state of the virtual machine instance. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    """

    resource_uid: Optional[str] = rest_field(
        name="resourceUid", visibility=["read", "create", "update", "delete", "query"]
    )
    """The unique identifier for the resource."""
    public_key: Optional[str] = rest_field(name="publicKey", visibility=["read", "create", "update", "delete", "query"])
    """The Public Key."""
    identity: Optional["_models.Identity"] = rest_field(visibility=["read"])
    """Identity for the resource."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the virtual machine instance. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        resource_uid: Optional[str] = None,
        public_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Identity(_Model):
    """Identity for the resource.

    :ivar principal_id: The principal ID of resource identity. The value must be an UUID.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource. The value must be an UUID.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity. The value must be an UUID."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource. The value must be an UUID."""
    type: Optional[Literal["SystemAssigned"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity type. Default value is \"SystemAssigned\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Literal["SystemAssigned"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageArmReference(_Model):
    """The ARM ID for a Gallery Image.

    :ivar id: The ARM ID for an image resource used by the virtual machine instance.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create"])
    """The ARM ID for an image resource used by the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceViewStatus(_Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.azurestackhcivm.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The status code."""
    level: Optional[Union[str, "_models.StatusLevelTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The level code. Known values are: \"Info\", \"Warning\", and \"Error\"."""
    display_status: Optional[str] = rest_field(
        name="displayStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The short localizable label for the status."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The detailed status message, including for alerts and error messages."""
    time: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time of the status."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InterfaceDNSSettings(_Model):
    """DNS Settings of the interface.

    :ivar dns_servers: List of DNS server IP Addresses for the interface.
    :vartype dns_servers: list[str]
    """

    dns_servers: Optional[List[str]] = rest_field(
        name="dnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of DNS server IP Addresses for the interface."""

    @overload
    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPConfiguration(_Model):
    """InterfaceIPConfiguration IPConfiguration in a network interface.

    :ivar name: Name - The name of the resource that is unique within a resource group. This name
     can be used to access the resource.
    :vartype name: str
    :ivar properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.IPConfigurationProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create"])
    """Name - The name of the resource that is unique within a resource group. This name can be used
     to access the resource."""
    properties: Optional["_models.IPConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """InterfaceIPConfigurationPropertiesFormat properties of IP configuration."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.IPConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPConfigurationProperties(_Model):
    """InterfaceIPConfigurationPropertiesFormat properties of IP configuration.

    :ivar gateway: Gateway for network interface.
    :vartype gateway: str
    :ivar prefix_length: prefixLength for network interface.
    :vartype prefix_length: str
    :ivar private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar subnet: Subnet - Name of Subnet bound to the IP configuration.
    :vartype subnet: ~azure.mgmt.azurestackhcivm.models.LogicalNetworkArmReference
    """

    gateway: Optional[str] = rest_field(visibility=["read"])
    """Gateway for network interface."""
    prefix_length: Optional[str] = rest_field(name="prefixLength", visibility=["read"])
    """prefixLength for network interface."""
    private_ip_address: Optional[str] = rest_field(
        name="privateIPAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """PrivateIPAddress - Private IP address of the IP configuration."""
    subnet: Optional["_models.LogicalNetworkArmReference"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subnet - Name of Subnet bound to the IP configuration."""

    @overload
    def __init__(
        self,
        *,
        private_ip_address: Optional[str] = None,
        subnet: Optional["_models.LogicalNetworkArmReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPPool(_Model):
    """Describes IPPool.

    :ivar name: Name of the IP-Pool.
    :vartype name: str
    :ivar ip_pool_type: Type of the IP Pool [vm, vippool]. Known values are: "vm" and "vippool".
    :vartype ip_pool_type: str or ~azure.mgmt.azurestackhcivm.models.IPPoolTypeEnum
    :ivar start: Start of the IP address pool.
    :vartype start: str
    :ivar end: End of the IP address pool.
    :vartype end: str
    :ivar info: IPPool info.
    :vartype info: ~azure.mgmt.azurestackhcivm.models.IPPoolInfo
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the IP-Pool."""
    ip_pool_type: Optional[Union[str, "_models.IPPoolTypeEnum"]] = rest_field(
        name="ipPoolType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the IP Pool [vm, vippool]. Known values are: \"vm\" and \"vippool\"."""
    start: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start of the IP address pool."""
    end: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """End of the IP address pool."""
    info: Optional["_models.IPPoolInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """IPPool info."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ip_pool_type: Optional[Union[str, "_models.IPPoolTypeEnum"]] = None,
        start: Optional[str] = None,
        end: Optional[str] = None,
        info: Optional["_models.IPPoolInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPPoolInfo(_Model):
    """IP Pool info.

    :ivar used: Number of IP addresses allocated from the IP Pool.
    :vartype used: str
    :ivar available: Number of IP addresses available in the IP Pool.
    :vartype available: str
    """

    used: Optional[str] = rest_field(visibility=["read"])
    """Number of IP addresses allocated from the IP Pool."""
    available: Optional[str] = rest_field(visibility=["read"])
    """Number of IP addresses available in the IP Pool."""


class LogicalNetwork(TrackedResource):
    """The logical network resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.LogicalNetworkProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.LogicalNetworkProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.LogicalNetworkProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworkArmReference(_Model):
    """The ARM ID for a Logical Network.

    :ivar id: The ARM ID for a Logical Network.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Logical Network."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworkProperties(_Model):
    """Properties under the logical network resource.

    :ivar dhcp_options: DhcpOptions contains an array of DNS servers available to VMs deployed in
     the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
    :vartype dhcp_options: ~azure.mgmt.azurestackhcivm.models.LogicalNetworkPropertiesDhcpOptions
    :ivar subnets: Subnet - list of subnets under the logical network.
    :vartype subnets: list[~azure.mgmt.azurestackhcivm.models.Subnet]
    :ivar provisioning_state: Provisioning state of the logical network. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar vm_switch_name: name of the network switch to be used for VMs.
    :vartype vm_switch_name: str
    :ivar status: The observed state of logical networks.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.LogicalNetworkStatus
    :ivar network_type: Type of the Logical Network. Known values are: "Workload" and
     "Infrastructure".
    :vartype network_type: str or ~azure.mgmt.azurestackhcivm.models.LogicalNetworkTypeEnum
    """

    dhcp_options: Optional["_models.LogicalNetworkPropertiesDhcpOptions"] = rest_field(
        name="dhcpOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network.
     Standard DHCP option for a subnet overrides logical network DHCP options."""
    subnets: Optional[List["_models.Subnet"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Subnet - list of subnets under the logical network."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the logical network. Known values are: \"Succeeded\", \"Failed\",
     \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    vm_switch_name: Optional[str] = rest_field(
        name="vmSwitchName", visibility=["read", "create", "update", "delete", "query"]
    )
    """name of the network switch to be used for VMs."""
    status: Optional["_models.LogicalNetworkStatus"] = rest_field(visibility=["read"])
    """The observed state of logical networks."""
    network_type: Optional[Union[str, "_models.LogicalNetworkTypeEnum"]] = rest_field(
        name="networkType", visibility=["read"]
    )
    """Type of the Logical Network. Known values are: \"Workload\" and \"Infrastructure\"."""

    @overload
    def __init__(
        self,
        *,
        dhcp_options: Optional["_models.LogicalNetworkPropertiesDhcpOptions"] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        vm_switch_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworkPropertiesDhcpOptions(_Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network.
    Standard DHCP option for a subnet overrides logical network DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    dns_servers: Optional[List[str]] = rest_field(
        name="dnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of DNS servers IP addresses."""

    @overload
    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworkStatus(_Model):
    """The observed state of logical networks.

    :ivar error_code: LogicalNetwork provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: Logical network provisioning status.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.LogicalNetworkStatusProvisioningStatus
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """LogicalNetwork provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.LogicalNetworkStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical network provisioning status."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.LogicalNetworkStatusProvisioningStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworkStatusProvisioningStatus(_Model):
    """Describes the status of the provisioning.

    :ivar operation_id: The ID of the operation performed on the logical network.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the logical network [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the logical network."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the logical network [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogicalNetworksUpdateRequest(_Model):
    """The logical network resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.azurestackhcivm.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.azurestackhcivm.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImage(TrackedResource):
    """The marketplace gallery image resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.MarketplaceGalleryImageProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.MarketplaceGalleryImageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.MarketplaceGalleryImageProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImageProperties(_Model):
    """Properties under the marketplace gallery image resource.

    :ivar container_id: Storage ContainerID of the storage container to be used for marketplace
     gallery image.
    :vartype container_id: str
    :ivar os_type: Operating system type that the gallery image uses [Windows, Linux]. Required.
     Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhcivm.models.OperatingSystemTypes
    :ivar cloud_init_data_source: Datasource for the gallery image when provisioning with
     cloud-init [NoCloud, Azure]. Known values are: "NoCloud" and "Azure".
    :vartype cloud_init_data_source: str or ~azure.mgmt.azurestackhcivm.models.CloudInitDataSource
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhcivm.models.HyperVGeneration
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.azurestackhcivm.models.GalleryImageIdentifier
    :ivar version: Specifies information about the gallery image version that you want to create or
     update.
    :vartype version: ~azure.mgmt.azurestackhcivm.models.GalleryImageVersion
    :ivar provisioning_state: Provisioning state of the marketplace gallery image. Known values
     are: "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar status: The observed state of marketplace gallery images.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.MarketplaceGalleryImageStatus
    """

    container_id: Optional[str] = rest_field(
        name="containerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage ContainerID of the storage container to be used for marketplace gallery image."""
    os_type: Union[str, "_models.OperatingSystemTypes"] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operating system type that the gallery image uses [Windows, Linux]. Required. Known values are:
     \"Windows\" and \"Linux\"."""
    cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = rest_field(
        name="cloudInitDataSource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]. Known
     values are: \"NoCloud\" and \"Azure\"."""
    hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = rest_field(
        name="hyperVGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hypervisor generation of the Virtual Machine [V1, V2]. Known values are: \"V1\" and \"V2\"."""
    identifier: Optional["_models.GalleryImageIdentifier"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the gallery image definition identifier."""
    version: Optional["_models.GalleryImageVersion"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the gallery image version that you want to create or update."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the marketplace gallery image. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    status: Optional["_models.MarketplaceGalleryImageStatus"] = rest_field(visibility=["read"])
    """The observed state of marketplace gallery images."""

    @overload
    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        container_id: Optional[str] = None,
        cloud_init_data_source: Optional[Union[str, "_models.CloudInitDataSource"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        version: Optional["_models.GalleryImageVersion"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImageStatus(_Model):
    """The observed state of marketplace gallery images.

    :ivar error_code: MarketplaceGalleryImage provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: Provisioning status of marketplace gallery image.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.MarketplaceGalleryImageStatusProvisioningStatus
    :ivar download_status: The download status of the gallery image.
    :vartype download_status:
     ~azure.mgmt.azurestackhcivm.models.MarketplaceGalleryImageStatusDownloadStatus
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """MarketplaceGalleryImage provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.MarketplaceGalleryImageStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provisioning status of marketplace gallery image."""
    download_status: Optional["_models.MarketplaceGalleryImageStatusDownloadStatus"] = rest_field(
        name="downloadStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The download status of the gallery image."""
    progress_percentage: Optional[int] = rest_field(
        name="progressPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The progress of the operation in percentage."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.MarketplaceGalleryImageStatusProvisioningStatus"] = None,
        download_status: Optional["_models.MarketplaceGalleryImageStatusDownloadStatus"] = None,
        progress_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImageStatusDownloadStatus(_Model):  # pylint: disable=name-too-long
    """The download status of the gallery image.

    :ivar download_size_in_mb: The downloaded sized of the image in MB.
    :vartype download_size_in_mb: int
    """

    download_size_in_mb: Optional[int] = rest_field(
        name="downloadSizeInMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The downloaded sized of the image in MB."""

    @overload
    def __init__(
        self,
        *,
        download_size_in_mb: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImageStatusProvisioningStatus(_Model):  # pylint: disable=name-too-long
    """Marketplace GalleryImage provisioning status.

    :ivar operation_id: The ID of the operation performed on the gallery image.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the gallery image [Succeeded, Failed,
     InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the gallery image."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the gallery image [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceGalleryImageTagsUpdate(_Model):
    """The type used for updating tags in MarketplaceGalleryImage resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterface(TrackedResource):
    """The network interface resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.NetworkInterfaceProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.NetworkInterfaceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.NetworkInterfaceProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceArmReference(_Model):
    """The ARM ID for a Network Interface.

    :ivar id: The ARM ID for a Network Interface.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Network Interface."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceProperties(_Model):
    """Properties under the network interface resource.

    :ivar ip_configurations: IPConfigurations - A list of IPConfigurations of the network
     interface.
    :vartype ip_configurations: list[~azure.mgmt.azurestackhcivm.models.IPConfiguration]
    :ivar mac_address: MacAddress - The MAC address of the network interface.
    :vartype mac_address: str
    :ivar dns_settings: DNS Settings for the interface.
    :vartype dns_settings: ~azure.mgmt.azurestackhcivm.models.InterfaceDNSSettings
    :ivar create_from_local: Boolean indicating whether this is a existing local network interface
     or if one should be created.
    :vartype create_from_local: bool
    :ivar provisioning_state: Provisioning state of the network interface. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar status: The observed state of network interfaces.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.NetworkInterfaceStatus
    :ivar network_security_group: NetworkSecurityGroup - Network Security Group attached to the
     network interface.
    :vartype network_security_group:
     ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupArmReference
    """

    ip_configurations: Optional[List["_models.IPConfiguration"]] = rest_field(
        name="ipConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """IPConfigurations - A list of IPConfigurations of the network interface."""
    mac_address: Optional[str] = rest_field(
        name="macAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """MacAddress - The MAC address of the network interface."""
    dns_settings: Optional["_models.InterfaceDNSSettings"] = rest_field(
        name="dnsSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Settings for the interface."""
    create_from_local: Optional[bool] = rest_field(
        name="createFromLocal", visibility=["read", "create", "update", "delete", "query"]
    )
    """Boolean indicating whether this is a existing local network interface or if one should be
     created."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the network interface. Known values are: \"Succeeded\", \"Failed\",
     \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    status: Optional["_models.NetworkInterfaceStatus"] = rest_field(visibility=["read"])
    """The observed state of network interfaces."""
    network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = rest_field(
        name="networkSecurityGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkSecurityGroup - Network Security Group attached to the network interface."""

    @overload
    def __init__(
        self,
        *,
        ip_configurations: Optional[List["_models.IPConfiguration"]] = None,
        mac_address: Optional[str] = None,
        dns_settings: Optional["_models.InterfaceDNSSettings"] = None,
        create_from_local: Optional[bool] = None,
        network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceStatus(_Model):
    """The observed state of network interfaces.

    :ivar error_code: NetworkInterface provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: Network interface provisioning status.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.NetworkInterfaceStatusProvisioningStatus
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """NetworkInterface provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.NetworkInterfaceStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network interface provisioning status."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.NetworkInterfaceStatusProvisioningStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfaceStatusProvisioningStatus(_Model):
    """Network interface provisioning status.

    :ivar operation_id: The ID of the operation performed on the network interface.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the network interface [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the network interface."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the network interface [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfacesUpdateProperties(_Model):
    """Defines the resource properties for the update.

    :ivar network_security_group: NetworkSecurityGroup - Network Security Group attached to the
     network interface.
    :vartype network_security_group:
     ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupArmReference
    :ivar dns_settings: DNS Settings for the interface.
    :vartype dns_settings: ~azure.mgmt.azurestackhcivm.models.InterfaceDNSSettings
    """

    network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = rest_field(
        name="networkSecurityGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkSecurityGroup - Network Security Group attached to the network interface."""
    dns_settings: Optional["_models.InterfaceDNSSettings"] = rest_field(
        name="dnsSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Settings for the interface."""

    @overload
    def __init__(
        self,
        *,
        network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = None,
        dns_settings: Optional["_models.InterfaceDNSSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterfacesUpdateRequest(_Model):
    """The network interface resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Defines the resource properties for the update.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.NetworkInterfacesUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.NetworkInterfacesUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the resource properties for the update."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.NetworkInterfacesUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkProfileUpdate(_Model):
    """NetworkProfile - describes the network update configuration the virtual machine instance.

    :ivar network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the
     virtual machine instance.
    :vartype network_interfaces:
     list[~azure.mgmt.azurestackhcivm.models.NetworkInterfaceArmReference]
    """

    network_interfaces: Optional[List["_models.NetworkInterfaceArmReference"]] = rest_field(
        name="networkInterfaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        network_interfaces: Optional[List["_models.NetworkInterfaceArmReference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroup(TrackedResource):
    """NetworkSecurityGroup resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.NetworkSecurityGroupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.NetworkSecurityGroupProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupArmReference(_Model):
    """The ARM ID for a Network Security Group.

    :ivar id: The ARM ID for a Network Security Group.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Network Security Group."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupProperties(_Model):
    """Network Security Group resource.

    :ivar network_interfaces: A collection of references to network interfaces that are currently
     using this NSG.
    :vartype network_interfaces:
     list[~azure.mgmt.azurestackhcivm.models.NetworkInterfaceArmReference]
    :ivar subnets: A collection of references to logical networks that are currently using this
     NSG.
    :vartype subnets: list[~azure.mgmt.azurestackhcivm.models.LogicalNetworkArmReference]
    :ivar provisioning_state: The provisioning state of the network security group resource. Known
     values are: "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar status: The observed state of Network Security Group.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupStatus
    """

    network_interfaces: Optional[List["_models.NetworkInterfaceArmReference"]] = rest_field(
        name="networkInterfaces", visibility=["read"]
    )
    """A collection of references to network interfaces that are currently using this NSG."""
    subnets: Optional[List["_models.LogicalNetworkArmReference"]] = rest_field(visibility=["read"])
    """A collection of references to logical networks that are currently using this NSG."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the network security group resource. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    status: Optional["_models.NetworkSecurityGroupStatus"] = rest_field(visibility=["read"])
    """The observed state of Network Security Group."""


class NetworkSecurityGroupStatus(_Model):
    """The observed state of network security group.

    :ivar error_code: NetworkSecurityGroup provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: network security group provisioning status.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupStatusProvisioningStatus
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """NetworkSecurityGroup provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.NetworkSecurityGroupStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """network security group provisioning status."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.NetworkSecurityGroupStatusProvisioningStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupStatusProvisioningStatus(_Model):  # pylint: disable=name-too-long
    """network security group provisioning status.

    :ivar operation_id: The ID of the operation performed on the network security group.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the network security group [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the network security group."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the network security group [Succeeded, Failed,
     InProgress]. Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupTagsUpdate(_Model):
    """The type used for updating tags in NetworkSecurityGroup resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OsProfileUpdate(_Model):
    """OsProfile - describes the update configuration of the operating system.

    :ivar computer_name: ComputerName - name of the computer.
    :vartype computer_name: str
    :ivar linux_configuration: Linux configuration properties.
    :vartype linux_configuration:
     ~azure.mgmt.azurestackhcivm.models.OsProfileUpdateLinuxConfiguration
    :ivar windows_configuration: Windows configuration properties.
    :vartype windows_configuration:
     ~azure.mgmt.azurestackhcivm.models.OsProfileUpdateWindowsConfiguration
    """

    computer_name: Optional[str] = rest_field(
        name="computerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """ComputerName - name of the computer."""
    linux_configuration: Optional["_models.OsProfileUpdateLinuxConfiguration"] = rest_field(
        name="linuxConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Linux configuration properties."""
    windows_configuration: Optional["_models.OsProfileUpdateWindowsConfiguration"] = rest_field(
        name="windowsConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Windows configuration properties."""

    @overload
    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        linux_configuration: Optional["_models.OsProfileUpdateLinuxConfiguration"] = None,
        windows_configuration: Optional["_models.OsProfileUpdateWindowsConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OsProfileUpdateLinuxConfiguration(_Model):
    """OSProfile update linux configuration.

    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether Arc for Servers agent onboarding should be triggered during the
     virtual machine instance creation process."""
    provision_vm_config_agent: Optional[bool] = rest_field(
        name="provisionVMConfigAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether the VM Config Agent should be installed during the virtual machine
     creation process."""

    @overload
    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OsProfileUpdateWindowsConfiguration(_Model):
    """OSProfile update windows configuration.

    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether Arc for Servers agent onboarding should be triggered during the
     virtual machine instance creation process."""
    provision_vm_config_agent: Optional[bool] = rest_field(
        name="provisionVMConfigAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether the VM Config Agent should be installed during the virtual machine
     creation process."""

    @overload
    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Route(_Model):
    """Route - Route resource.

    :ivar properties: Properties of the route.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.RouteProperties
    :ivar name: Name - name of the subnet.
    :vartype name: str
    """

    properties: Optional["_models.RouteProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the route."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name - name of the subnet."""

    __flattened_items = ["address_prefix", "next_hop_ip_address"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RouteProperties"] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class RouteProperties(_Model):
    """RoutePropertiesFormat - Route resource.

    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    """

    address_prefix: Optional[str] = rest_field(
        name="addressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination CIDR to which the route applies."""
    next_hop_ip_address: Optional[str] = rest_field(
        name="nextHopIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP address packets should be forwarded to. Next hop values are only allowed in routes where
     the next hop type is VirtualAppliance."""

    @overload
    def __init__(
        self,
        *,
        address_prefix: Optional[str] = None,
        next_hop_ip_address: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RouteTable(_Model):
    """Route table resource.

    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Properties of the route table.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.RouteTableProperties
    """

    etag: Optional[str] = rest_field(visibility=["read"])
    """A unique read-only string that changes whenever the resource is updated."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Resource name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Resource type."""
    properties: Optional["_models.RouteTableProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the route table."""

    __flattened_items = ["routes"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RouteTableProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class RouteTableProperties(_Model):
    """RouteTablePropertiesFormat - Route Table resource.

    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.azurestackhcivm.models.Route]
    """

    routes: Optional[List["_models.Route"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Collection of routes contained within a route table."""

    @overload
    def __init__(
        self,
        *,
        routes: Optional[List["_models.Route"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityRule(ProxyResource):
    """Security Rule resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.SecurityRuleProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.SecurityRuleProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SecurityRuleProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityRuleProperties(_Model):
    """Security rule resource.

    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Required. Known values are: "Tcp",
     "Udp", "Icmp", and "*".
    :vartype protocol: str or ~azure.mgmt.azurestackhcivm.models.SecurityRuleProtocol
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar source_port_ranges: The source port ranges. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_ranges: list[str]
    :ivar access: The network traffic is allowed or denied. Required. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.azurestackhcivm.models.SecurityRuleAccess
    :ivar priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule. Required.
    :vartype priority: int
    :ivar direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Required. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.azurestackhcivm.models.SecurityRuleDirection
    :ivar provisioning_state: Provisioning state of the SR. Known values are: "Succeeded",
     "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for this rule. Restricted to 140 chars."""
    protocol: Union[str, "_models.SecurityRuleProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Network protocol this rule applies to. Required. Known values are: \"Tcp\", \"Udp\", \"Icmp\",
     and \"*\"."""
    source_address_prefixes: Optional[List[str]] = rest_field(
        name="sourceAddressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The CIDR or source IP ranges."""
    destination_address_prefixes: Optional[List[str]] = rest_field(
        name="destinationAddressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination address prefixes. CIDR or destination IP ranges."""
    source_port_ranges: Optional[List[str]] = rest_field(
        name="sourcePortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source port ranges. Integer or range between 0 and 65535. Asterisk '*' can also be used to
     match all ports."""
    destination_port_ranges: Optional[List[str]] = rest_field(
        name="destinationPortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination port ranges. Integer or range between 0 and 65535. Asterisk '*' can also be
     used to match all ports."""
    access: Union[str, "_models.SecurityRuleAccess"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The network traffic is allowed or denied. Required. Known values are: \"Allow\" and \"Deny\"."""
    priority: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the rule. The value can be between 100 and 4096. The priority number must be
     unique for each rule in the collection. The lower the priority number, the higher the priority
     of the rule. Required."""
    direction: Union[str, "_models.SecurityRuleDirection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The direction of the rule. The direction specifies if rule will be evaluated on incoming or
     outgoing traffic. Required. Known values are: \"Inbound\" and \"Outbound\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the SR. Known values are: \"Succeeded\", \"Failed\", \"InProgress\",
     \"Accepted\", \"Deleting\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        protocol: Union[str, "_models.SecurityRuleProtocol"],
        access: Union[str, "_models.SecurityRuleAccess"],
        priority: int,
        direction: Union[str, "_models.SecurityRuleDirection"],
        description: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshConfiguration(_Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.azurestackhcivm.models.SshPublicKey]
    """

    public_keys: Optional[List["_models.SshPublicKey"]] = rest_field(
        name="publicKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of SSH public keys used to authenticate with linux based VMs."""

    @overload
    def __init__(
        self,
        *,
        public_keys: Optional[List["_models.SshPublicKey"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SshPublicKey(_Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see
     [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]`https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed
     <https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_).
    :vartype key_data: str
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the full path on the created VM where ssh public key is stored. If the file already
     exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys."""
    key_data: Optional[str] = rest_field(name="keyData", visibility=["read", "create", "update", "delete", "query"])
    """SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at
     least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on
     Linux and Mac for Linux VMs in
     Azure]`https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed
     <https://learn.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed>`_)."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        key_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainer(TrackedResource):
    """The storage container resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.StorageContainerProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.StorageContainerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StorageContainerProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainerProperties(_Model):
    """Properties under the storage container resource.

    :ivar path: Path of the storage container on the disk. Required.
    :vartype path: str
    :ivar provisioning_state: Provisioning state of the storage container. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar status: The observed state of storage containers.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.StorageContainerStatus
    """

    path: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Path of the storage container on the disk. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the storage container. Known values are: \"Succeeded\", \"Failed\",
     \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    status: Optional["_models.StorageContainerStatus"] = rest_field(visibility=["read"])
    """The observed state of storage containers."""

    @overload
    def __init__(
        self,
        *,
        path: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainerStatus(_Model):
    """The observed state of storage containers.

    :ivar error_code: StorageContainer provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar available_size_mb: Amount of space available on the disk in MB.
    :vartype available_size_mb: int
    :ivar container_size_mb: Total size of the disk in MB.
    :vartype container_size_mb: int
    :ivar provisioning_status: Storage container's provisioning status.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.StorageContainerStatusProvisioningStatus
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """StorageContainer provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    available_size_mb: Optional[int] = rest_field(
        name="availableSizeMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Amount of space available on the disk in MB."""
    container_size_mb: Optional[int] = rest_field(
        name="containerSizeMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total size of the disk in MB."""
    provisioning_status: Optional["_models.StorageContainerStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage container's provisioning status."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        available_size_mb: Optional[int] = None,
        container_size_mb: Optional[int] = None,
        provisioning_status: Optional["_models.StorageContainerStatusProvisioningStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainerStatusProvisioningStatus(_Model):
    """Storage container provisioning status.

    :ivar operation_id: The ID of the operation performed on the storage container.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the storage container [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the storage container."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the storage container [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageContainerTagsUpdate(_Model):
    """The type used for updating tags in StorageContainer resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageProfileUpdate(_Model):
    """Storage profile update.

    :ivar data_disks: adds data disks to the virtual machine instance for the update call.
    :vartype data_disks: list[~azure.mgmt.azurestackhcivm.models.VirtualHardDiskArmReference]
    """

    data_disks: Optional[List["_models.VirtualHardDiskArmReference"]] = rest_field(
        name="dataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """adds data disks to the virtual machine instance for the update call."""

    @overload
    def __init__(
        self,
        *,
        data_disks: Optional[List["_models.VirtualHardDiskArmReference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Subnet(_Model):
    """Properties of the subnet.

    :ivar properties: Properties of the subnet.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.SubnetProperties
    :ivar name: Name - The name of the resource that is unique within a resource group. This name
     can be used to access the resource.
    :vartype name: str
    """

    properties: Optional["_models.SubnetProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the subnet."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name - The name of the resource that is unique within a resource group. This name can be used
     to access the resource."""

    __flattened_items = [
        "address_prefix",
        "address_prefixes",
        "ip_allocation_method",
        "ip_configuration_references",
        "network_security_group",
        "route_table",
        "ip_pools",
        "vlan",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SubnetProperties"] = None,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SubnetIpConfigurationReference(_Model):
    """The ARM ID for a Network Interface.

    :ivar id: The ARM ID for a Network Interface.
    :vartype id: str
    """

    id: Optional[str] = rest_field(name="ID", visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Network Interface."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubnetProperties(_Model):
    """Properties of the subnet.

    :ivar address_prefix: The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6.
    :vartype address_prefix: str
    :ivar address_prefixes: List of address prefixes for the subnet.
    :vartype address_prefixes: list[str]
    :ivar ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible
     values include: 'Static', 'Dynamic'. Known values are: "Dynamic" and "Static".
    :vartype ip_allocation_method: str or ~azure.mgmt.azurestackhcivm.models.IpAllocationMethodEnum
    :ivar ip_configuration_references: IPConfigurationReferences - list of
     IPConfigurationReferences.
    :vartype ip_configuration_references:
     list[~azure.mgmt.azurestackhcivm.models.SubnetIpConfigurationReference]
    :ivar network_security_group: NetworkSecurityGroup - Network Security Group attached to the
     logical network.
    :vartype network_security_group:
     ~azure.mgmt.azurestackhcivm.models.NetworkSecurityGroupArmReference
    :ivar route_table: Route table resource.
    :vartype route_table: ~azure.mgmt.azurestackhcivm.models.RouteTable
    :ivar ip_pools: network associated pool of IP Addresses.
    :vartype ip_pools: list[~azure.mgmt.azurestackhcivm.models.IPPool]
    :ivar vlan: Vlan to use for the subnet.
    :vartype vlan: int
    """

    address_prefix: Optional[str] = rest_field(
        name="addressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The address prefix for the subnet: Cidr for this subnet - IPv4, IPv6."""
    address_prefixes: Optional[List[str]] = rest_field(
        name="addressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of address prefixes for the subnet."""
    ip_allocation_method: Optional[Union[str, "_models.IpAllocationMethodEnum"]] = rest_field(
        name="ipAllocationMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """IPAllocationMethod - The IP address allocation method. Possible values include: 'Static',
     'Dynamic'. Known values are: \"Dynamic\" and \"Static\"."""
    ip_configuration_references: Optional[List["_models.SubnetIpConfigurationReference"]] = rest_field(
        name="ipConfigurationReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """IPConfigurationReferences - list of IPConfigurationReferences."""
    network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = rest_field(
        name="networkSecurityGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkSecurityGroup - Network Security Group attached to the logical network."""
    route_table: Optional["_models.RouteTable"] = rest_field(
        name="routeTable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Route table resource."""
    ip_pools: Optional[List["_models.IPPool"]] = rest_field(
        name="ipPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """network associated pool of IP Addresses."""
    vlan: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Vlan to use for the subnet."""

    @overload
    def __init__(
        self,
        *,
        address_prefix: Optional[str] = None,
        address_prefixes: Optional[List[str]] = None,
        ip_allocation_method: Optional[Union[str, "_models.IpAllocationMethodEnum"]] = None,
        ip_configuration_references: Optional[List["_models.SubnetIpConfigurationReference"]] = None,
        network_security_group: Optional["_models.NetworkSecurityGroupArmReference"] = None,
        route_table: Optional["_models.RouteTable"] = None,
        ip_pools: Optional[List["_models.IPPool"]] = None,
        vlan: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.azurestackhcivm.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.azurestackhcivm.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VirtualHardDisk(TrackedResource):
    """The virtual hard disk resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    """

    properties: Optional["_models.VirtualHardDiskProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VirtualHardDiskProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskArmReference(_Model):
    """The ARM ID for a Virtual Hard Disk.

    :ivar id: The ARM ID for a Virtual Hard Disk.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Virtual Hard Disk."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskDownloadStatus(_Model):
    """The download status of the virtual hard disk.

    :ivar downloaded_size_in_mb: The downloaded sized of the virtual hard disk in MB.
    :vartype downloaded_size_in_mb: int
    :ivar status: The status of Uploading virtual hard disk [Succeeded, Failed, InProgress]. Known
     values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    """

    downloaded_size_in_mb: Optional[int] = rest_field(
        name="downloadedSizeInMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The downloaded sized of the virtual hard disk in MB."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of Uploading virtual hard disk [Succeeded, Failed, InProgress]. Known values are:
     \"Succeeded\", \"Failed\", and \"InProgress\"."""
    progress_percentage: Optional[int] = rest_field(
        name="progressPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The progress of the operation in percentage."""

    @overload
    def __init__(
        self,
        *,
        downloaded_size_in_mb: Optional[int] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        progress_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskProperties(_Model):
    """Properties under the virtual hard disk resource.

    :ivar block_size_bytes: Block size in bytes.
    :vartype block_size_bytes: int
    :ivar disk_size_gb: Size of the disk in GB.
    :vartype disk_size_gb: int
    :ivar dynamic: Boolean for enabling dynamic sizing on the virtual hard disk.
    :vartype dynamic: bool
    :ivar logical_sector_bytes: Logical sector in bytes.
    :vartype logical_sector_bytes: int
    :ivar physical_sector_bytes: Physical sector in bytes.
    :vartype physical_sector_bytes: int
    :ivar download_url: URL for downloading or accessing the virtual hard disk. This URL points to
     a secure link from where the VHD can be downloaded or accessed directly.
    :vartype download_url: str
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.azurestackhcivm.models.HyperVGeneration
    :ivar disk_file_format: The format of the actual VHD file [vhd, vhdx]. Known values are: "vhdx"
     and "vhd".
    :vartype disk_file_format: str or ~azure.mgmt.azurestackhcivm.models.DiskFileFormat
    :ivar create_from_local: Boolean indicating whether it is an existing local hard disk or if one
     should be created.
    :vartype create_from_local: bool
    :ivar provisioning_state: Provisioning state of the virtual hard disk. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar container_id: Storage ContainerID of the storage container to be used for VHD.
    :vartype container_id: str
    :ivar status: The observed state of virtual hard disks.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskStatus
    :ivar max_shares: The maximum number of VMs that can attach to the disk at the same time. Value
     greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :vartype max_shares: int
    """

    block_size_bytes: Optional[int] = rest_field(
        name="blockSizeBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Block size in bytes."""
    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of the disk in GB."""
    dynamic: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Boolean for enabling dynamic sizing on the virtual hard disk."""
    logical_sector_bytes: Optional[int] = rest_field(
        name="logicalSectorBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical sector in bytes."""
    physical_sector_bytes: Optional[int] = rest_field(
        name="physicalSectorBytes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Physical sector in bytes."""
    download_url: Optional[str] = rest_field(
        name="downloadUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """URL for downloading or accessing the virtual hard disk. This URL points to a secure link from
     where the VHD can be downloaded or accessed directly."""
    hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = rest_field(
        name="hyperVGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The hypervisor generation of the Virtual Machine [V1, V2]. Known values are: \"V1\" and \"V2\"."""
    disk_file_format: Optional[Union[str, "_models.DiskFileFormat"]] = rest_field(
        name="diskFileFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """The format of the actual VHD file [vhd, vhdx]. Known values are: \"vhdx\" and \"vhd\"."""
    create_from_local: Optional[bool] = rest_field(
        name="createFromLocal", visibility=["read", "create", "update", "delete", "query"]
    )
    """Boolean indicating whether it is an existing local hard disk or if one should be created."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the virtual hard disk. Known values are: \"Succeeded\", \"Failed\",
     \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    container_id: Optional[str] = rest_field(
        name="containerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage ContainerID of the storage container to be used for VHD."""
    status: Optional["_models.VirtualHardDiskStatus"] = rest_field(visibility=["read"])
    """The observed state of virtual hard disks."""
    max_shares: Optional[int] = rest_field(name="maxShares", visibility=["read", "create", "update", "delete", "query"])
    """The maximum number of VMs that can attach to the disk at the same time. Value greater than one
     indicates a disk that can be mounted on multiple VMs at the same time."""

    @overload
    def __init__(
        self,
        *,
        block_size_bytes: Optional[int] = None,
        disk_size_gb: Optional[int] = None,
        dynamic: Optional[bool] = None,
        logical_sector_bytes: Optional[int] = None,
        physical_sector_bytes: Optional[int] = None,
        download_url: Optional[str] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        disk_file_format: Optional[Union[str, "_models.DiskFileFormat"]] = None,
        create_from_local: Optional[bool] = None,
        container_id: Optional[str] = None,
        max_shares: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskStatus(_Model):
    """The observed state of virtual hard disks.

    :ivar error_code: VirtualHardDisk provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar provisioning_status: Provisioning status of the vhd.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskStatusProvisioningStatus
    :ivar download_status: The download status of the virtual hard disk.
    :vartype download_status: ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskDownloadStatus
    :ivar upload_status: The upload status of the virtual hard disk.
    :vartype upload_status: ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskUploadStatus
    :ivar managed_by: ARM IDs of the VMs that are consuming the VHD.
    :vartype managed_by: list[str]
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """VirtualHardDisk provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    provisioning_status: Optional["_models.VirtualHardDiskStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provisioning status of the vhd."""
    download_status: Optional["_models.VirtualHardDiskDownloadStatus"] = rest_field(
        name="downloadStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The download status of the virtual hard disk."""
    upload_status: Optional["_models.VirtualHardDiskUploadStatus"] = rest_field(
        name="uploadStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upload status of the virtual hard disk."""
    managed_by: Optional[List[str]] = rest_field(
        name="managedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM IDs of the VMs that are consuming the VHD."""
    unique_id: Optional[str] = rest_field(name="uniqueId", visibility=["read", "create", "update", "delete", "query"])
    """Unique Guid identifying the resource."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        provisioning_status: Optional["_models.VirtualHardDiskStatusProvisioningStatus"] = None,
        download_status: Optional["_models.VirtualHardDiskDownloadStatus"] = None,
        upload_status: Optional["_models.VirtualHardDiskUploadStatus"] = None,
        managed_by: Optional[List[str]] = None,
        unique_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskStatusProvisioningStatus(_Model):
    """VHD Status provisioning status.

    :ivar operation_id: The ID of the operation performed on the virtual hard disk.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the virtual hard disk [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the virtual hard disk."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the virtual hard disk [Succeeded, Failed, InProgress].
     Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDisksUpdateProperties(_Model):
    """Defines the resource properties for the update.

    :ivar disk_size_gb: Size of the disk in GB.
    :vartype disk_size_gb: int
    """

    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of the disk in GB."""

    @overload
    def __init__(
        self,
        *,
        disk_size_gb: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDisksUpdateRequest(_Model):
    """The virtual hard disk resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Defines the resource properties for the update.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.VirtualHardDisksUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.VirtualHardDisksUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the resource properties for the update."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VirtualHardDisksUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskUploadRequest(_Model):
    """Request for uploading virtual hard disk.

    :ivar azure_managed_disk_upload_url: The Azure managed disk SAS URL to upload the virtual hard
     disk to. Required.
    :vartype azure_managed_disk_upload_url: str
    """

    azure_managed_disk_upload_url: str = rest_field(
        name="azureManagedDiskUploadUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure managed disk SAS URL to upload the virtual hard disk to. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_managed_disk_upload_url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskUploadResponse(_Model):
    """Response for uploading virtual hard disk.

    :ivar virtual_hard_disk_id: The ARM ID for a Virtual Hard Disk.
    :vartype virtual_hard_disk_id: str
    :ivar upload_status: The upload status of the virtual hard disk.
    :vartype upload_status: ~azure.mgmt.azurestackhcivm.models.VirtualHardDiskUploadStatus
    """

    virtual_hard_disk_id: Optional[str] = rest_field(
        name="virtualHardDiskId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM ID for a Virtual Hard Disk."""
    upload_status: Optional["_models.VirtualHardDiskUploadStatus"] = rest_field(
        name="uploadStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upload status of the virtual hard disk."""

    @overload
    def __init__(
        self,
        *,
        virtual_hard_disk_id: Optional[str] = None,
        upload_status: Optional["_models.VirtualHardDiskUploadStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualHardDiskUploadStatus(_Model):
    """The upload status of the virtual hard disk.

    :ivar uploaded_size_in_mb: The uploaded sized of the virtual hard disk in MB.
    :vartype uploaded_size_in_mb: int
    :ivar status: The status of Uploading virtual hard disk [Succeeded, Failed, InProgress]. Known
     values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    :ivar progress_percentage: The progress of the operation in percentage.
    :vartype progress_percentage: int
    :ivar error_code: VirtualHardDisk upload error code.
    :vartype error_code: str
    :ivar error_message: Descriptive upload error message.
    :vartype error_message: str
    """

    uploaded_size_in_mb: Optional[int] = rest_field(
        name="uploadedSizeInMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The uploaded sized of the virtual hard disk in MB."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of Uploading virtual hard disk [Succeeded, Failed, InProgress]. Known values are:
     \"Succeeded\", \"Failed\", and \"InProgress\"."""
    progress_percentage: Optional[int] = rest_field(
        name="progressPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The progress of the operation in percentage."""
    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """VirtualHardDisk upload error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive upload error message."""

    @overload
    def __init__(
        self,
        *,
        uploaded_size_in_mb: Optional[int] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        progress_percentage: Optional[int] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineConfigAgentInstanceView(_Model):
    """The instance view of the VM Config Agent running on the virtual machine.

    :ivar vm_config_agent_version: The VM Config Agent full version.
    :vartype vm_config_agent_version: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.azurestackhcivm.models.InstanceViewStatus]
    """

    vm_config_agent_version: Optional[str] = rest_field(
        name="vmConfigAgentVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The VM Config Agent full version."""
    statuses: Optional[List["_models.InstanceViewStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource status information."""

    @overload
    def __init__(
        self,
        *,
        vm_config_agent_version: Optional[str] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstance(ExtensionResource):
    """The virtual machine instance resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.azurestackhcivm.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceProperties
    :ivar extended_location: The extendedLocation of the resource.
    :vartype extended_location: ~azure.mgmt.azurestackhcivm.models.ExtendedLocation
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.azurestackhcivm.models.ManagedServiceIdentity
    """

    properties: Optional["_models.VirtualMachineInstanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extendedLocation of the resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualMachineInstanceProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceManagedDiskParameters(_Model):  # pylint: disable=name-too-long
    """The parameters of a managed disk.

    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.azurestackhcivm.models.VMDiskSecurityProfile
    """

    security_profile: Optional["_models.VMDiskSecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile for the managed disk."""

    @overload
    def __init__(
        self,
        *,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceProperties(_Model):
    """Properties under the virtual machine instance resource.

    :ivar hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
     machine instance.
    :vartype hardware_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesHardwareProfile
    :ivar placement_profile: PlacementProfile - Specifies the placement related settings for the
     virtual machine.
    :vartype placement_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesPlacementProfile
    :ivar network_profile: NetworkProfile - describes the network configuration the virtual machine
     instance.
    :vartype network_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesNetworkProfile
    :ivar os_profile: OsProfile - describes the configuration of the operating system and sets
     login data.
    :vartype os_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesOsProfile
    :ivar security_profile: SecurityProfile - Specifies the security settings for the virtual
     machine instance.
    :vartype security_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesSecurityProfile
    :ivar storage_profile: StorageProfile - contains information about the disks and storage
     information for the virtual machine instance.
    :vartype storage_profile:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesStorageProfile
    :ivar http_proxy_config: HTTP Proxy configuration for the VM.
    :vartype http_proxy_config: ~azure.mgmt.azurestackhcivm.models.HttpProxyConfiguration
    :ivar create_from_local: Boolean indicating whether this is an existing local virtual machine
     or if one should be created.
    :vartype create_from_local: bool
    :ivar provisioning_state: Provisioning state of the virtual machine instance. Known values are:
     "Succeeded", "Failed", "InProgress", "Accepted", "Deleting", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.azurestackhcivm.models.ProvisioningStateEnum
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceView
    :ivar status: The observed state of virtual machine instances.
    :vartype status: ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceStatus
    :ivar guest_agent_install_status: Guest agent install status.
    :vartype guest_agent_install_status: ~azure.mgmt.azurestackhcivm.models.GuestAgentInstallStatus
    :ivar vm_id: Unique identifier for the vm resource.
    :vartype vm_id: str
    :ivar resource_uid: Unique identifier defined by ARC to identify the guest of the VM.
    :vartype resource_uid: str
    :ivar hyper_v_vm_id: Unique identifier for the Hyper-V VM resource.
    :vartype hyper_v_vm_id: str
    :ivar host_node_name: Name of the host node that the VM is on.
    :vartype host_node_name: str
    :ivar host_node_ip_address: Name of the host node that the VM is on.
    :vartype host_node_ip_address: str
    """

    hardware_profile: Optional["_models.VirtualMachineInstancePropertiesHardwareProfile"] = rest_field(
        name="hardwareProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance."""
    placement_profile: Optional["_models.VirtualMachineInstancePropertiesPlacementProfile"] = rest_field(
        name="placementProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """PlacementProfile - Specifies the placement related settings for the virtual machine."""
    network_profile: Optional["_models.VirtualMachineInstancePropertiesNetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkProfile - describes the network configuration the virtual machine instance."""
    os_profile: Optional["_models.VirtualMachineInstancePropertiesOsProfile"] = rest_field(
        name="osProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """OsProfile - describes the configuration of the operating system and sets login data."""
    security_profile: Optional["_models.VirtualMachineInstancePropertiesSecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """SecurityProfile - Specifies the security settings for the virtual machine instance."""
    storage_profile: Optional["_models.VirtualMachineInstancePropertiesStorageProfile"] = rest_field(
        name="storageProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """StorageProfile - contains information about the disks and storage information for the virtual
     machine instance."""
    http_proxy_config: Optional["_models.HttpProxyConfiguration"] = rest_field(
        name="httpProxyConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """HTTP Proxy configuration for the VM."""
    create_from_local: Optional[bool] = rest_field(
        name="createFromLocal", visibility=["read", "create", "update", "delete", "query"]
    )
    """Boolean indicating whether this is an existing local virtual machine or if one should be
     created."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningStateEnum"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the virtual machine instance. Known values are: \"Succeeded\",
     \"Failed\", \"InProgress\", \"Accepted\", \"Deleting\", and \"Canceled\"."""
    instance_view: Optional["_models.VirtualMachineInstanceView"] = rest_field(name="instanceView", visibility=["read"])
    """The virtual machine instance view."""
    status: Optional["_models.VirtualMachineInstanceStatus"] = rest_field(visibility=["read"])
    """The observed state of virtual machine instances."""
    guest_agent_install_status: Optional["_models.GuestAgentInstallStatus"] = rest_field(
        name="guestAgentInstallStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Guest agent install status."""
    vm_id: Optional[str] = rest_field(name="vmId", visibility=["read"])
    """Unique identifier for the vm resource."""
    resource_uid: Optional[str] = rest_field(
        name="resourceUid", visibility=["read", "create", "update", "delete", "query"]
    )
    """Unique identifier defined by ARC to identify the guest of the VM."""
    hyper_v_vm_id: Optional[str] = rest_field(name="hyperVVmId", visibility=["read"])
    """Unique identifier for the Hyper-V VM resource."""
    host_node_name: Optional[str] = rest_field(name="hostNodeName", visibility=["read"])
    """Name of the host node that the VM is on."""
    host_node_ip_address: Optional[str] = rest_field(name="hostNodeIpAddress", visibility=["read"])
    """Name of the host node that the VM is on."""

    @overload
    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.VirtualMachineInstancePropertiesHardwareProfile"] = None,
        placement_profile: Optional["_models.VirtualMachineInstancePropertiesPlacementProfile"] = None,
        network_profile: Optional["_models.VirtualMachineInstancePropertiesNetworkProfile"] = None,
        os_profile: Optional["_models.VirtualMachineInstancePropertiesOsProfile"] = None,
        security_profile: Optional["_models.VirtualMachineInstancePropertiesSecurityProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineInstancePropertiesStorageProfile"] = None,
        http_proxy_config: Optional["_models.HttpProxyConfiguration"] = None,
        create_from_local: Optional[bool] = None,
        guest_agent_install_status: Optional["_models.GuestAgentInstallStatus"] = None,
        resource_uid: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesHardwareProfile(_Model):  # pylint: disable=name-too-long
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance.

    :ivar vm_size: Enum of VM Sizes. Known values are: "Default", "Standard_A2_v2",
     "Standard_A4_v2", "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2",
     "Standard_DS13_v2", "Standard_K8S_v1", "Standard_K8S2_v1", "Standard_K8S3_v1",
     "Standard_K8S4_v1", "Standard_NK6", "Standard_NK12", "Standard_NV6", "Standard_NV12",
     "Standard_K8S5_v1", and "Custom".
    :vartype vm_size: str or ~azure.mgmt.azurestackhcivm.models.VmSizeEnum
    :ivar processors: number of processors for the virtual machine instance.
    :vartype processors: int
    :ivar memory_mb: RAM in MB for the virtual machine instance.
    :vartype memory_mb: int
    :ivar dynamic_memory_config: Dynamic memory config.
    :vartype dynamic_memory_config:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig
    :ivar virtual_machine_gp_us: virtualMachineGPUs - list of gpus to be attached to the virtual
     machine instance.
    :vartype virtual_machine_gp_us:
     list[~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU]
    """

    vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = rest_field(
        name="vmSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enum of VM Sizes. Known values are: \"Default\", \"Standard_A2_v2\", \"Standard_A4_v2\",
     \"Standard_D2s_v3\", \"Standard_D4s_v3\", \"Standard_D8s_v3\", \"Standard_D16s_v3\",
     \"Standard_D32s_v3\", \"Standard_DS2_v2\", \"Standard_DS3_v2\", \"Standard_DS4_v2\",
     \"Standard_DS5_v2\", \"Standard_DS13_v2\", \"Standard_K8S_v1\", \"Standard_K8S2_v1\",
     \"Standard_K8S3_v1\", \"Standard_K8S4_v1\", \"Standard_NK6\", \"Standard_NK12\",
     \"Standard_NV6\", \"Standard_NV12\", \"Standard_K8S5_v1\", and \"Custom\"."""
    processors: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """number of processors for the virtual machine instance."""
    memory_mb: Optional[int] = rest_field(name="memoryMB", visibility=["read", "create", "update", "delete", "query"])
    """RAM in MB for the virtual machine instance."""
    dynamic_memory_config: Optional["_models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig"] = (
        rest_field(name="dynamicMemoryConfig", visibility=["read", "create", "update", "delete", "query"])
    )
    """Dynamic memory config."""
    virtual_machine_gp_us: Optional[
        List["_models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU"]
    ] = rest_field(name="virtualMachineGPUs", visibility=["read", "create", "update", "delete", "query"])
    """virtualMachineGPUs - list of gpus to be attached to the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VmSizeEnum"]] = None,
        processors: Optional[int] = None,
        memory_mb: Optional[int] = None,
        dynamic_memory_config: Optional[
            "_models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig"
        ] = None,
        virtual_machine_gp_us: Optional[
            List["_models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU"]
        ] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig(_Model):  # pylint: disable=name-too-long
    """Dynamic memory config.

    :ivar maximum_memory_mb: Maximum memory in MB.
    :vartype maximum_memory_mb: int
    :ivar minimum_memory_mb: Minimum memory in MB.
    :vartype minimum_memory_mb: int
    :ivar target_memory_buffer: Defines the amount of extra memory that should be reserved for a
     virtual machine instance at runtime, as a percentage of the total memory that the virtual
     machine instance is thought to need. This only applies to virtual systems with dynamic memory
     enabled. This property can be in the range of 5 to 2000.
    :vartype target_memory_buffer: int
    """

    maximum_memory_mb: Optional[int] = rest_field(
        name="maximumMemoryMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum memory in MB."""
    minimum_memory_mb: Optional[int] = rest_field(
        name="minimumMemoryMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum memory in MB."""
    target_memory_buffer: Optional[int] = rest_field(
        name="targetMemoryBuffer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the amount of extra memory that should be reserved for a virtual machine instance at
     runtime, as a percentage of the total memory that the virtual machine instance is thought to
     need. This only applies to virtual systems with dynamic memory enabled. This property can be in
     the range of 5 to 2000."""

    @overload
    def __init__(
        self,
        *,
        maximum_memory_mb: Optional[int] = None,
        minimum_memory_mb: Optional[int] = None,
        target_memory_buffer: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU(_Model):  # pylint: disable=name-too-long
    """GPU properties - describes the GPU configuration.

    :ivar assignment_type: GPU assignment type. Required. Known values are: "GpuDDA" and "GpuP".
    :vartype assignment_type: str or ~azure.mgmt.azurestackhcivm.models.GpuAssignmentTypeEnum
    :ivar partition_size_mb: Size of gpu partition in MB for GPU-P.
    :vartype partition_size_mb: int
    :ivar gpu_name: Name of the GPU.
    :vartype gpu_name: str
    """

    assignment_type: Union[str, "_models.GpuAssignmentTypeEnum"] = rest_field(
        name="assignmentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """GPU assignment type. Required. Known values are: \"GpuDDA\" and \"GpuP\"."""
    partition_size_mb: Optional[int] = rest_field(
        name="partitionSizeMB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of gpu partition in MB for GPU-P."""
    gpu_name: Optional[str] = rest_field(name="gpuName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the GPU."""

    @overload
    def __init__(
        self,
        *,
        assignment_type: Union[str, "_models.GpuAssignmentTypeEnum"],
        partition_size_mb: Optional[int] = None,
        gpu_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesNetworkProfile(_Model):  # pylint: disable=name-too-long
    """NetworkProfile - describes the network configuration the virtual machine instance.

    :ivar network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the
     virtual machine instance.
    :vartype network_interfaces:
     list[~azure.mgmt.azurestackhcivm.models.NetworkInterfaceArmReference]
    """

    network_interfaces: Optional[List["_models.NetworkInterfaceArmReference"]] = rest_field(
        name="networkInterfaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        network_interfaces: Optional[List["_models.NetworkInterfaceArmReference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesOsProfile(_Model):  # pylint: disable=name-too-long
    """OsProfile - describes the configuration of the operating system and sets login data.

    :ivar admin_password: AdminPassword - admin password.
    :vartype admin_password: str
    :ivar admin_username: AdminUsername - admin username.
    :vartype admin_username: str
    :ivar computer_name: ComputerName - name of the compute.
    :vartype computer_name: str
    :ivar linux_configuration: LinuxConfiguration - linux specific configuration values for the
     virtual machine instance.
    :vartype linux_configuration:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration
    :ivar windows_configuration: Windows Configuration for the virtual machine instance.
    :vartype windows_configuration:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration
    """

    admin_password: Optional[str] = rest_field(name="adminPassword", visibility=["create"])
    """AdminPassword - admin password."""
    admin_username: Optional[str] = rest_field(
        name="adminUsername", visibility=["read", "create", "update", "delete", "query"]
    )
    """AdminUsername - admin username."""
    computer_name: Optional[str] = rest_field(
        name="computerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """ComputerName - name of the compute."""
    linux_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration"] = rest_field(
        name="linuxConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """LinuxConfiguration - linux specific configuration values for the virtual machine instance."""
    windows_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration"] = (
        rest_field(name="windowsConfiguration", visibility=["read", "create", "update", "delete", "query"])
    )
    """Windows Configuration for the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        admin_password: Optional[str] = None,
        admin_username: Optional[str] = None,
        computer_name: Optional[str] = None,
        linux_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileLinuxConfiguration"] = None,
        windows_configuration: Optional["_models.VirtualMachineInstancePropertiesOsProfileWindowsConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesOsProfileLinuxConfiguration(_Model):  # pylint: disable=name-too-long
    """LinuxConfiguration - linux specific configuration values for the virtual machine instance.

    :ivar disable_password_authentication: DisablePasswordAuthentication - whether password
     authentication should be disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.azurestackhcivm.models.SshConfiguration
    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    disable_password_authentication: Optional[bool] = rest_field(
        name="disablePasswordAuthentication", visibility=["read", "create", "update", "delete", "query"]
    )
    """DisablePasswordAuthentication - whether password authentication should be disabled."""
    ssh: Optional["_models.SshConfiguration"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the ssh key configuration for a Linux OS."""
    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether Arc for Servers agent onboarding should be triggered during the
     virtual machine instance creation process."""
    provision_vm_config_agent: Optional[bool] = rest_field(
        name="provisionVMConfigAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether the VM Config Agent should be installed during the virtual machine
     creation process."""

    @overload
    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesOsProfileWindowsConfiguration(_Model):  # pylint: disable=name-too-long
    """Windows Configuration for the virtual machine instance.

    :ivar enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine.
    :vartype enable_automatic_updates: bool
    :ivar ssh: Specifies the ssh key configuration for Windows OS.
    :vartype ssh: ~azure.mgmt.azurestackhcivm.models.SshConfiguration
    :ivar time_zone: TimeZone for the virtual machine instance.
    :vartype time_zone: str
    :ivar provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be
     triggered during the virtual machine instance creation process.
    :vartype provision_vm_agent: bool
    :ivar provision_vm_config_agent: Used to indicate whether the VM Config Agent should be
     installed during the virtual machine creation process.
    :vartype provision_vm_config_agent: bool
    """

    enable_automatic_updates: Optional[bool] = rest_field(
        name="enableAutomaticUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to EnableAutomaticUpdates on the machine."""
    ssh: Optional["_models.SshConfiguration"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the ssh key configuration for Windows OS."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """TimeZone for the virtual machine instance."""
    provision_vm_agent: Optional[bool] = rest_field(
        name="provisionVMAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether Arc for Servers agent onboarding should be triggered during the
     virtual machine instance creation process."""
    provision_vm_config_agent: Optional[bool] = rest_field(
        name="provisionVMConfigAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to indicate whether the VM Config Agent should be installed during the virtual machine
     creation process."""

    @overload
    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        time_zone: Optional[str] = None,
        provision_vm_agent: Optional[bool] = None,
        provision_vm_config_agent: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesPlacementProfile(_Model):  # pylint: disable=name-too-long
    """PlacementProfile - Specifies the placement related settings for the virtual machine.

    :ivar zone: The zone in which the VM should be placed in.
    :vartype zone: str
    :ivar strict_placement_policy: Specifies whether VM can only failover strictly within the zone
     it was placed in.
    :vartype strict_placement_policy: bool
    """

    zone: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The zone in which the VM should be placed in."""
    strict_placement_policy: Optional[bool] = rest_field(
        name="strictPlacementPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether VM can only failover strictly within the zone it was placed in."""

    @overload
    def __init__(
        self,
        *,
        zone: Optional[str] = None,
        strict_placement_policy: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesSecurityProfile(_Model):  # pylint: disable=name-too-long
    """SecurityProfile - Specifies the security settings for the virtual machine instance.

    :ivar enable_tpm: Enable TPM flag.
    :vartype enable_tpm: bool
    :ivar uefi_settings: Uefi settings of the virtual machine instance.
    :vartype uefi_settings:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings
    :ivar security_type: Specifies the SecurityType of the virtual machine. EnableTPM and
     SecureBootEnabled must be set to true for SecurityType to function. Known values are:
     "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.azurestackhcivm.models.SecurityTypes
    """

    enable_tpm: Optional[bool] = rest_field(
        name="enableTPM", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable TPM flag."""
    uefi_settings: Optional["_models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings"] = rest_field(
        name="uefiSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Uefi settings of the virtual machine instance."""
    security_type: Optional[Union[str, "_models.SecurityTypes"]] = rest_field(
        name="securityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set
     to true for SecurityType to function. Known values are: \"TrustedLaunch\" and
     \"ConfidentialVM\"."""

    @overload
    def __init__(
        self,
        *,
        enable_tpm: Optional[bool] = None,
        uefi_settings: Optional["_models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings"] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesSecurityProfileUefiSettings(_Model):  # pylint: disable=name-too-long
    """Uefi settings - Specifies whether secure boot should be enabled on the virtual machine
    instance.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine instance.
    :vartype secure_boot_enabled: bool
    """

    secure_boot_enabled: Optional[bool] = rest_field(
        name="secureBootEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether secure boot should be enabled on the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesStorageProfile(_Model):  # pylint: disable=name-too-long
    """StorageProfile - contains information about the disks and storage information for the virtual
    machine instance.

    :ivar data_disks: adds data disks to the virtual machine instance.
    :vartype data_disks: list[~azure.mgmt.azurestackhcivm.models.VirtualHardDiskArmReference]
    :ivar image_reference: Which Image to use for the virtual machine instance.
    :vartype image_reference: ~azure.mgmt.azurestackhcivm.models.ImageArmReference
    :ivar os_disk: VHD to attach as OS disk.
    :vartype os_disk:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstancePropertiesStorageProfileOsDisk
    :ivar vm_config_storage_path_id: Id of the storage container that hosts the VM configuration
     file.
    :vartype vm_config_storage_path_id: str
    """

    data_disks: Optional[List["_models.VirtualHardDiskArmReference"]] = rest_field(
        name="dataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """adds data disks to the virtual machine instance."""
    image_reference: Optional["_models.ImageArmReference"] = rest_field(
        name="imageReference", visibility=["read", "create"]
    )
    """Which Image to use for the virtual machine instance."""
    os_disk: Optional["_models.VirtualMachineInstancePropertiesStorageProfileOsDisk"] = rest_field(
        name="osDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """VHD to attach as OS disk."""
    vm_config_storage_path_id: Optional[str] = rest_field(
        name="vmConfigStoragePathId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Id of the storage container that hosts the VM configuration file."""

    @overload
    def __init__(
        self,
        *,
        data_disks: Optional[List["_models.VirtualHardDiskArmReference"]] = None,
        image_reference: Optional["_models.ImageArmReference"] = None,
        os_disk: Optional["_models.VirtualMachineInstancePropertiesStorageProfileOsDisk"] = None,
        vm_config_storage_path_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstancePropertiesStorageProfileOsDisk(_Model):  # pylint: disable=name-too-long
    """VHD to attach as OS disk.

    :ivar id: The ARM ID for a Virtual Hard Disk.
    :vartype id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. Possible values are: Windows,
     Linux. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.azurestackhcivm.models.OperatingSystemTypes
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceManagedDiskParameters
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM ID for a Virtual Hard Disk."""
    os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property allows you to specify the type of the OS that is included in the disk if creating
     a VM from user-image or a specialized VHD. Possible values are: Windows, Linux. Known values
     are: \"Windows\" and \"Linux\"."""
    managed_disk: Optional["_models.VirtualMachineInstanceManagedDiskParameters"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        managed_disk: Optional["_models.VirtualMachineInstanceManagedDiskParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceStatus(_Model):
    """The observed state of virtual machine instances.

    :ivar error_code: VirtualMachine provisioning error code.
    :vartype error_code: str
    :ivar error_message: Descriptive error message.
    :vartype error_message: str
    :ivar power_state: The power state of the virtual machine instance. Known values are:
     "Deallocated", "Deallocating", "Running", "Starting", "Stopped", "Stopping", "Paused", "Saved",
     and "Unknown".
    :vartype power_state: str or ~azure.mgmt.azurestackhcivm.models.PowerStateEnum
    :ivar provisioning_status: Provisioning status of the virtual machine instance.
    :vartype provisioning_status:
     ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceStatusProvisioningStatus
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """VirtualMachine provisioning error code."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Descriptive error message."""
    power_state: Optional[Union[str, "_models.PowerStateEnum"]] = rest_field(
        name="powerState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The power state of the virtual machine instance. Known values are: \"Deallocated\",
     \"Deallocating\", \"Running\", \"Starting\", \"Stopped\", \"Stopping\", \"Paused\", \"Saved\",
     and \"Unknown\"."""
    provisioning_status: Optional["_models.VirtualMachineInstanceStatusProvisioningStatus"] = rest_field(
        name="provisioningStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provisioning status of the virtual machine instance."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        power_state: Optional[Union[str, "_models.PowerStateEnum"]] = None,
        provisioning_status: Optional["_models.VirtualMachineInstanceStatusProvisioningStatus"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceStatusProvisioningStatus(_Model):  # pylint: disable=name-too-long
    """Virtual machine instance provisioning status.

    :ivar operation_id: The ID of the operation performed on the virtual machine instance.
    :vartype operation_id: str
    :ivar status: The status of the operation performed on the virtual machine instance [Succeeded,
     Failed, InProgress]. Known values are: "Succeeded", "Failed", and "InProgress".
    :vartype status: str or ~azure.mgmt.azurestackhcivm.models.Status
    """

    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the operation performed on the virtual machine instance."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the operation performed on the virtual machine instance [Succeeded, Failed,
     InProgress]. Known values are: \"Succeeded\", \"Failed\", and \"InProgress\"."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceUpdateProperties(_Model):
    """Defines the resource properties for the update.

    :ivar hardware_profile: HardwareProfile - Specifies the hardware settings for the virtual
     machine instance.
    :vartype hardware_profile: ~azure.mgmt.azurestackhcivm.models.HardwareProfileUpdate
    :ivar storage_profile: StorageProfile - Specifies the storage settings for the virtual machine
     instance.
    :vartype storage_profile: ~azure.mgmt.azurestackhcivm.models.StorageProfileUpdate
    :ivar network_profile: NetworkProfile - describes the network update configuration the virtual
     machine instance.
    :vartype network_profile: ~azure.mgmt.azurestackhcivm.models.NetworkProfileUpdate
    :ivar os_profile: OsProfile - describes the update configuration of the operating system.
    :vartype os_profile: ~azure.mgmt.azurestackhcivm.models.OsProfileUpdate
    """

    hardware_profile: Optional["_models.HardwareProfileUpdate"] = rest_field(
        name="hardwareProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """HardwareProfile - Specifies the hardware settings for the virtual machine instance."""
    storage_profile: Optional["_models.StorageProfileUpdate"] = rest_field(
        name="storageProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """StorageProfile - Specifies the storage settings for the virtual machine instance."""
    network_profile: Optional["_models.NetworkProfileUpdate"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """NetworkProfile - describes the network update configuration the virtual machine instance."""
    os_profile: Optional["_models.OsProfileUpdate"] = rest_field(
        name="osProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """OsProfile - describes the update configuration of the operating system."""

    @overload
    def __init__(
        self,
        *,
        hardware_profile: Optional["_models.HardwareProfileUpdate"] = None,
        storage_profile: Optional["_models.StorageProfileUpdate"] = None,
        network_profile: Optional["_models.NetworkProfileUpdate"] = None,
        os_profile: Optional["_models.OsProfileUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceUpdateRequest(_Model):
    """The virtual machine instance resource patch definition.

    :ivar properties: Defines the resource properties for the update.
    :vartype properties: ~azure.mgmt.azurestackhcivm.models.VirtualMachineInstanceUpdateProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.azurestackhcivm.models.Identity
    """

    properties: Optional["_models.VirtualMachineInstanceUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the resource properties for the update."""
    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identity for the resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualMachineInstanceUpdateProperties"] = None,
        identity: Optional["_models.Identity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceView(_Model):
    """The instance view of a virtual machine.

    :ivar vm_agent: The VM Config Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.azurestackhcivm.models.VirtualMachineConfigAgentInstanceView
    """

    vm_agent: Optional["_models.VirtualMachineConfigAgentInstanceView"] = rest_field(
        name="vmAgent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The VM Config Agent running on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        vm_agent: Optional["_models.VirtualMachineConfigAgentInstanceView"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMDiskSecurityProfile(_Model):
    """Specifies the security profile settings for the managed disk. NOTE: It can only be set for
    Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     NonPersistedTPM for not persisting firmware state in the VMGuestState blob. NOTE: It can be set
     for only Confidential VMs. "NonPersistedTPM"
    :vartype security_encryption_type: str or
     ~azure.mgmt.azurestackhcivm.models.SecurityEncryptionType
    """

    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionType"]] = rest_field(
        name="securityEncryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the EncryptionType of the managed disk. It is set to NonPersistedTPM for not
     persisting firmware state in the VMGuestState blob. NOTE: It can be set for only Confidential
     VMs. \"NonPersistedTPM\""""

    @overload
    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmImageRepositoryCredentials(_Model):
    """The credentials used to login to the image repository that has access to the specified image.

    :ivar username: Username for accessing image repository. Required.
    :vartype username: str
    :ivar password: Password for accessing image repository. Required.
    :vartype password: str
    """

    username: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Username for accessing image repository. Required."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Password for accessing image repository. Required."""

    @overload
    def __init__(
        self,
        *,
        username: str,
        password: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
