/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.CaretMonitor;

public class SyntaxTester
extends JFrame {
    private JComboBox jCmbLangs;
    private JEditorPane jEdtTest;
    private JScrollPane jScrollPane1;
    private JLabel lblCaretPos;
    private JLabel lblToken;

    public SyntaxTester() {
        DefaultSyntaxKit.initKit();
        this.initComponents();
        this.jCmbLangs.setModel(new DefaultComboBoxModel<String>(DefaultSyntaxKit.getContentTypes()));
        this.jCmbLangs.setSelectedItem("text/java");
        new CaretMonitor(this.jEdtTest, this.lblCaretPos);
    }

    private void initComponents() {
        this.lblCaretPos = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEdtTest = new JEditorPane();
        this.lblToken = new JLabel();
        this.jCmbLangs = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSyntaxPane Tester");
        this.lblCaretPos.setText("Caret Position");
        this.jEdtTest.setContentType("");
        this.jEdtTest.setFont(new Font("Monospaced", 0, 13));
        this.jEdtTest.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                SyntaxTester.this.jEdtTestCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEdtTest);
        this.lblToken.setFont(new Font("Courier New", 0, 12));
        this.lblToken.setText("Token under cursor");
        this.jCmbLangs.setMaximumRowCount(20);
        this.jCmbLangs.setFocusable(false);
        this.jCmbLangs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SyntaxTester.this.jCmbLangsItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblToken, GroupLayout.Alignment.LEADING, -1, 612, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCmbLangs, 0, 231, Short.MAX_VALUE).addGap(262, 262, 262).addComponent(this.lblCaretPos, -2, 119, -2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 612, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 395, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.lblToken, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbLangs, -2, -1, -2).addComponent(this.lblCaretPos, -1, 23, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jEdtTestCaretUpdate(CaretEvent evt) {
        SyntaxDocument sDoc;
        Token t;
        if (this.jEdtTest.getDocument() instanceof SyntaxDocument && (t = (sDoc = (SyntaxDocument)this.jEdtTest.getDocument()).getTokenAt(evt.getDot())) != null) {
            try {
                String tData = sDoc.getText(t.start, Math.min(t.length, 40));
                if (t.length > 40) {
                    tData = tData + "...";
                }
                this.lblToken.setText(t.toString() + ": " + tData);
            }
            catch (BadLocationException ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
        }
    }

    private void jCmbLangsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String lang = this.jCmbLangs.getSelectedItem().toString();
            String t = this.jEdtTest.getText();
            int caretPosition = this.jEdtTest.getCaretPosition();
            Rectangle visibleRectangle = this.jEdtTest.getVisibleRect();
            this.jEdtTest.setContentType(lang);
            SyntaxDocument sDoc = (SyntaxDocument)this.jEdtTest.getDocument();
            this.jEdtTest.setText(t);
            sDoc.clearUndos();
            this.jEdtTest.setCaretPosition(caretPosition);
            this.jEdtTest.scrollRectToVisible(visibleRectangle);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SyntaxTester().setVisible(true);
            }
        });
    }
}

