/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

@FileStatefulCheck
public class UncommentedMainCheck
extends AbstractCheck {
    public static final String MSG_KEY = "uncommented.main";
    private static final Set<String> STRING_PARAMETER_NAMES = Set.of(String[].class.getCanonicalName(), String.class.getCanonicalName(), String[].class.getSimpleName(), String.class.getSimpleName());
    private Pattern excludedClasses = Pattern.compile("^$");
    private String currentClass;
    private FullIdent packageName;
    private int classDepth;

    public void setExcludedClasses(Pattern excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9, 14, 16, 199};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.packageName = FullIdent.createFullIdent(null);
        this.currentClass = null;
        this.classDepth = 0;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14) {
            --this.classDepth;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.visitPackageDef(ast);
                break;
            }
            case 14: 
            case 199: {
                this.visitClassOrRecordDef(ast);
                break;
            }
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitPackageDef(DetailAST packageDef) {
        this.packageName = FullIdent.createFullIdent(packageDef.getLastChild().getPreviousSibling());
    }

    private void visitClassOrRecordDef(DetailAST classOrRecordDef) {
        if (this.classDepth == 0) {
            DetailAST ident = classOrRecordDef.findFirstToken(58);
            this.currentClass = this.packageName.getText() + "." + ident.getText();
            ++this.classDepth;
        }
    }

    private void visitMethodDef(DetailAST method) {
        if (this.classDepth == 1 && this.checkClassName() && UncommentedMainCheck.checkName(method) && UncommentedMainCheck.checkModifiers(method) && UncommentedMainCheck.checkType(method) && UncommentedMainCheck.checkParams(method)) {
            this.log(method, MSG_KEY, new Object[0]);
        }
    }

    private boolean checkClassName() {
        return !this.excludedClasses.matcher(this.currentClass).find();
    }

    private static boolean checkName(DetailAST method) {
        DetailAST ident = method.findFirstToken(58);
        return "main".equals(ident.getText());
    }

    private static boolean checkModifiers(DetailAST method) {
        DetailAST modifiers = method.findFirstToken(5);
        return modifiers.findFirstToken(62) != null && modifiers.findFirstToken(64) != null;
    }

    private static boolean checkType(DetailAST method) {
        DetailAST type = method.findFirstToken(13).getFirstChild();
        return type.getType() == 49;
    }

    private static boolean checkParams(DetailAST method) {
        boolean checkPassed = false;
        DetailAST params = method.findFirstToken(20);
        if (params.getChildCount() == 1) {
            DetailAST parameterType = params.getFirstChild().findFirstToken(13);
            boolean isArrayDeclaration = parameterType.findFirstToken(17) != null;
            Optional<DetailAST> varargs = Optional.ofNullable(params.getFirstChild().findFirstToken(171));
            if (isArrayDeclaration || varargs.isPresent()) {
                checkPassed = UncommentedMainCheck.isStringType(parameterType.getFirstChild());
            }
        }
        return checkPassed;
    }

    private static boolean isStringType(DetailAST typeAst) {
        FullIdent type = FullIdent.createFullIdent(typeAst);
        return STRING_PARAMETER_NAMES.contains(type.getText());
    }
}

