/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldif.Base64EncodingStrategy;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFMessages;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriterChangeRecordTranslator;
import com.unboundid.ldif.LDIFWriterEntryTranslator;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFWriter
implements Closeable {
    private static volatile boolean commentAboutBase64EncodedValues = false;
    @NotNull
    private static final String PROPERTY_BASE64_ENCODING_STRATEGY = "com.unboundid.ldif.base64EncodingStrategy";
    @NotNull
    private static volatile Base64EncodingStrategy base64EncodingStrategy = Base64EncodingStrategy.DEFAULT;
    @NotNull
    private static final byte[] VERSION_1_HEADER_BYTES;
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    @NotNull
    private final BufferedOutputStream writer;
    @NotNull
    private final ByteStringBuffer buffer;
    @Nullable
    private final LDIFWriterChangeRecordTranslator changeRecordTranslator;
    @Nullable
    private final LDIFWriterEntryTranslator entryTranslator;
    private int wrapColumn = 0;
    private int wrapColumnMinusTwo = -2;
    @Nullable
    private final ParallelProcessor<LDIFRecord, ByteStringBuffer> toLdifBytesInvoker;

    public LDIFWriter(@NotNull String path) throws IOException {
        this(new FileOutputStream(path));
    }

    public LDIFWriter(@NotNull File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public LDIFWriter(@NotNull OutputStream outputStream) {
        this(outputStream, 0);
    }

    public LDIFWriter(@NotNull OutputStream outputStream, int parallelThreads) {
        this(outputStream, parallelThreads, null);
    }

    public LDIFWriter(@NotNull OutputStream outputStream, int parallelThreads, @Nullable LDIFWriterEntryTranslator entryTranslator) {
        this(outputStream, parallelThreads, entryTranslator, null);
    }

    public LDIFWriter(@NotNull OutputStream outputStream, int parallelThreads, final @Nullable LDIFWriterEntryTranslator entryTranslator, final @Nullable LDIFWriterChangeRecordTranslator changeRecordTranslator) {
        Validator.ensureNotNull(outputStream);
        Validator.ensureTrue(parallelThreads >= 0, "LDIFWriter.parallelThreads must not be negative.");
        this.entryTranslator = entryTranslator;
        this.changeRecordTranslator = changeRecordTranslator;
        this.buffer = new ByteStringBuffer();
        this.writer = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 131072);
        if (parallelThreads == 0) {
            this.toLdifBytesInvoker = null;
        } else {
            LDAPSDKThreadFactory threadFactory = new LDAPSDKThreadFactory("LDIFWriter Worker", true, null);
            this.toLdifBytesInvoker = new ParallelProcessor<LDIFRecord, ByteStringBuffer>(new Processor<LDIFRecord, ByteStringBuffer>(){

                @Override
                @NotNull
                public ByteStringBuffer process(@NotNull LDIFRecord input) throws IOException {
                    LDIFRecord r;
                    if (entryTranslator != null && input instanceof Entry) {
                        r = entryTranslator.translateEntryToWrite((Entry)input);
                        if (r == null) {
                            return null;
                        }
                    } else if (changeRecordTranslator != null && input instanceof LDIFChangeRecord) {
                        r = changeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)input);
                        if (r == null) {
                            return null;
                        }
                    } else {
                        r = input;
                    }
                    ByteStringBuffer b = new ByteStringBuffer(200);
                    r.toLDIF(b, LDIFWriter.this.wrapColumn);
                    return b;
                }
            }, threadFactory, parallelThreads, 5);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.toLdifBytesInvoker != null) {
                try {
                    this.toLdifBytesInvoker.shutdown();
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.writer.close();
        }
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        this.wrapColumnMinusTwo = wrapColumn - 2;
    }

    public static boolean commentAboutBase64EncodedValues() {
        return commentAboutBase64EncodedValues;
    }

    public static void setCommentAboutBase64EncodedValues(boolean commentAboutBase64EncodedValues) {
        LDIFWriter.commentAboutBase64EncodedValues = commentAboutBase64EncodedValues;
    }

    @NotNull
    public static Base64EncodingStrategy getBase64EncodingStrategy() {
        return base64EncodingStrategy;
    }

    public static void setBase64EncodingStrategy(@NotNull Base64EncodingStrategy base64EncodingStrategy) {
        Validator.ensureNotNull(base64EncodingStrategy);
        LDIFWriter.base64EncodingStrategy = base64EncodingStrategy;
    }

    public void writeVersionHeader() throws IOException {
        this.writer.write(VERSION_1_HEADER_BYTES);
    }

    public void writeEntry(@NotNull Entry entry) throws IOException {
        this.writeEntry(entry, null);
    }

    public void writeEntry(@NotNull Entry entry, @Nullable String comment) throws IOException {
        Entry e;
        Validator.ensureNotNull(entry);
        if (this.entryTranslator == null) {
            e = entry;
        } else {
            e = this.entryTranslator.translateEntryToWrite(entry);
            if (e == null) {
                return;
            }
        }
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        Debug.debugLDIFWrite(e);
        this.writeLDIF(e);
    }

    public void writeChangeRecord(@NotNull LDIFChangeRecord changeRecord) throws IOException {
        this.writeChangeRecord(changeRecord, null);
    }

    public void writeChangeRecord(@NotNull LDIFChangeRecord changeRecord, @Nullable String comment) throws IOException {
        LDIFChangeRecord r;
        Validator.ensureNotNull(changeRecord);
        if (this.changeRecordTranslator == null) {
            r = changeRecord;
        } else {
            r = this.changeRecordTranslator.translateChangeRecordToWrite(changeRecord);
            if (r == null) {
                return;
            }
        }
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        Debug.debugLDIFWrite(r);
        this.writeLDIF(r);
    }

    public void writeLDIFRecord(@NotNull LDIFRecord record) throws IOException {
        this.writeLDIFRecord(record, null);
    }

    public void writeLDIFRecord(@NotNull LDIFRecord record, @Nullable String comment) throws IOException {
        LDIFRecord r;
        Validator.ensureNotNull(record);
        if (this.entryTranslator != null && record instanceof Entry) {
            r = this.entryTranslator.translateEntryToWrite((Entry)record);
            if (r == null) {
                return;
            }
        } else if (this.changeRecordTranslator != null && record instanceof LDIFChangeRecord) {
            r = this.changeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)record);
            if (r == null) {
                return;
            }
        } else {
            r = record;
        }
        Debug.debugLDIFWrite(r);
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        this.writeLDIF(r);
    }

    public void writeLDIFRecords(@NotNull List<? extends LDIFRecord> ldifRecords) throws IOException, InterruptedException {
        if (this.toLdifBytesInvoker == null) {
            for (LDIFRecord lDIFRecord : ldifRecords) {
                this.writeLDIFRecord(lDIFRecord);
            }
        } else {
            ArrayList<Result<? extends LDIFRecord, ByteStringBuffer>> results = this.toLdifBytesInvoker.processAll(ldifRecords);
            for (Result result : results) {
                LDIFWriter.rethrow(result.getFailureCause());
                ByteStringBuffer encodedBytes = (ByteStringBuffer)result.getOutput();
                if (encodedBytes == null) continue;
                encodedBytes.write(this.writer);
                this.writer.write(StaticUtils.EOL_BYTES);
            }
        }
    }

    public void writeComment(@NotNull String comment, boolean spaceBefore, boolean spaceAfter) throws IOException {
        Validator.ensureNotNull(comment);
        if (spaceBefore) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
        if (comment.indexOf(10) < 0) {
            this.writeSingleLineComment(comment);
        } else {
            String[] lines;
            for (String line : lines = comment.split("\\r?\\n")) {
                this.writeSingleLineComment(line);
            }
        }
        if (spaceAfter) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
    }

    private void writeSingleLineComment(@NotNull String comment) throws IOException {
        int commentWrapMinusTwo = this.wrapColumn <= 0 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : this.wrapColumnMinusTwo;
        this.buffer.clear();
        int length = comment.length();
        if (length <= commentWrapMinusTwo) {
            this.buffer.append("# ");
            this.buffer.append(comment);
            this.buffer.append(StaticUtils.EOL_BYTES);
        } else {
            int minPos = 0;
            while (minPos < length) {
                int pos;
                int spacePos;
                if (length - minPos <= commentWrapMinusTwo) {
                    this.buffer.append("# ");
                    this.buffer.append(comment.substring(minPos));
                    this.buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                boolean spaceFound = false;
                for (spacePos = pos = minPos + commentWrapMinusTwo; spacePos > minPos; --spacePos) {
                    if (comment.charAt(spacePos) != ' ') continue;
                    spaceFound = true;
                    break;
                }
                if (!spaceFound) {
                    for (spacePos = pos + 1; spacePos < length; ++spacePos) {
                        if (comment.charAt(spacePos) != ' ') continue;
                        spaceFound = true;
                        break;
                    }
                    if (!spaceFound) {
                        this.buffer.append("# ");
                        this.buffer.append(comment.substring(minPos));
                        this.buffer.append(StaticUtils.EOL_BYTES);
                        break;
                    }
                }
                this.buffer.append("# ");
                this.buffer.append(comment.substring(minPos, spacePos));
                this.buffer.append(StaticUtils.EOL_BYTES);
                for (minPos = spacePos + 1; minPos < length && comment.charAt(minPos) == ' '; ++minPos) {
                }
            }
        }
        this.buffer.write(this.writer);
    }

    private void writeLDIF(@NotNull LDIFRecord record) throws IOException {
        this.buffer.clear();
        record.toLDIF(this.buffer, this.wrapColumn);
        this.buffer.append(StaticUtils.EOL_BYTES);
        this.buffer.write(this.writer);
    }

    @NotNull
    public static List<String> wrapLines(int wrapColumn, String ... ldifLines) {
        return LDIFWriter.wrapLines(wrapColumn, Arrays.asList(ldifLines));
    }

    @NotNull
    public static List<String> wrapLines(int wrapColumn, @NotNull List<String> ldifLines) {
        if (wrapColumn <= 2) {
            return new ArrayList<String>(ldifLines);
        }
        ArrayList<String> newLines = new ArrayList<String>(ldifLines.size());
        block0: for (String s : ldifLines) {
            int length = s.length();
            if (length <= wrapColumn) {
                newLines.add(s);
                continue;
            }
            newLines.add(s.substring(0, wrapColumn));
            for (int pos = wrapColumn; pos < length; pos += wrapColumn - 1) {
                if (length - pos + 1 <= wrapColumn) {
                    newLines.add(' ' + s.substring(pos));
                    continue block0;
                }
                newLines.add(' ' + s.substring(pos, pos + wrapColumn - 1));
            }
        }
        return newLines;
    }

    @NotNull
    public static String encodeNameAndValue(@NotNull String name, @NotNull ASN1OctetString value) {
        StringBuilder buffer = new StringBuilder();
        LDIFWriter.encodeNameAndValue(name, value, buffer);
        return buffer.toString();
    }

    public static void encodeNameAndValue(@NotNull String name, @NotNull ASN1OctetString value, @NotNull StringBuilder buffer) {
        LDIFWriter.encodeNameAndValue(name, value, buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeNameAndValue(@NotNull String name, @NotNull ASN1OctetString value, @NotNull StringBuilder buffer, int wrapColumn) {
        int bufferStartPos = buffer.length();
        byte[] valueBytes = value.getValue();
        boolean base64Encoded = false;
        try {
            buffer.append(name);
            buffer.append(':');
            if (base64EncodingStrategy.shouldBase64Encode(value)) {
                buffer.append(": ");
                Base64.encode(valueBytes, buffer);
                base64Encoded = true;
            } else {
                buffer.append(' ');
                buffer.append(value.stringValue());
            }
        }
        finally {
            int length;
            if (wrapColumn > 2 && (length = buffer.length() - bufferStartPos) > wrapColumn) {
                String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                int pos = bufferStartPos + wrapColumn;
                while (pos < buffer.length()) {
                    char c = buffer.charAt(pos);
                    if (Character.isLowSurrogate(c)) {
                        ++pos;
                        continue;
                    }
                    buffer.insert(pos, EOL_PLUS_SPACE);
                    pos += wrapColumn - 1 + EOL_PLUS_SPACE.length();
                }
            }
            if (base64Encoded && commentAboutBase64EncodedValues) {
                LDIFWriter.writeBase64DecodedValueComment(valueBytes, buffer, wrapColumn);
            }
        }
    }

    private static void writeBase64DecodedValueComment(@NotNull byte[] valueBytes, @NotNull StringBuilder buffer, int wrapColumn) {
        if (commentAboutBase64EncodedValues && valueBytes.length <= 1000) {
            int wrapColumnMinusTwo = wrapColumn <= 5 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : wrapColumn - 2;
            int wrapColumnMinusThree = wrapColumnMinusTwo - 1;
            boolean first = true;
            String comment = "Non-base64-encoded representation of the above value: " + LDIFWriter.getEscapedValue(valueBytes);
            for (String s : StaticUtils.wrapLine(comment, wrapColumnMinusTwo, wrapColumnMinusThree)) {
                buffer.append(StaticUtils.EOL);
                buffer.append("# ");
                if (first) {
                    first = false;
                } else {
                    buffer.append(' ');
                }
                buffer.append(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeNameAndValue(@NotNull String name, @NotNull ASN1OctetString value, @NotNull ByteStringBuffer buffer, int wrapColumn) {
        boolean base64Encoded;
        block9: {
            int bufferStartPos = buffer.length();
            base64Encoded = false;
            try {
                int length;
                buffer.append(name);
                base64Encoded = LDIFWriter.encodeValue(value, buffer);
                if (wrapColumn <= 2 || (length = buffer.length() - bufferStartPos) <= wrapColumn) break block9;
            }
            catch (Throwable throwable) {
                int length;
                if (wrapColumn > 2 && (length = buffer.length() - bufferStartPos) > wrapColumn) {
                    byte[] EOL_BYTES_PLUS_SPACE = new byte[StaticUtils.EOL_BYTES.length + 1];
                    System.arraycopy(StaticUtils.EOL_BYTES, 0, EOL_BYTES_PLUS_SPACE, 0, StaticUtils.EOL_BYTES.length);
                    EOL_BYTES_PLUS_SPACE[StaticUtils.EOL_BYTES.length] = 32;
                    int pos = bufferStartPos + wrapColumn;
                    while (pos < buffer.length()) {
                        byte byteAtPos = buffer.byteAt(pos);
                        if ((byteAtPos & 0xC0) == 128) {
                            ++pos;
                            continue;
                        }
                        buffer.insert(pos, EOL_BYTES_PLUS_SPACE);
                        pos += wrapColumn - 1 + EOL_BYTES_PLUS_SPACE.length;
                    }
                }
                if (base64Encoded && commentAboutBase64EncodedValues) {
                    LDIFWriter.writeBase64DecodedValueComment(value.getValue(), buffer, wrapColumn);
                }
                throw throwable;
            }
            byte[] EOL_BYTES_PLUS_SPACE = new byte[StaticUtils.EOL_BYTES.length + 1];
            System.arraycopy(StaticUtils.EOL_BYTES, 0, EOL_BYTES_PLUS_SPACE, 0, StaticUtils.EOL_BYTES.length);
            EOL_BYTES_PLUS_SPACE[StaticUtils.EOL_BYTES.length] = 32;
            int pos = bufferStartPos + wrapColumn;
            while (pos < buffer.length()) {
                byte byteAtPos = buffer.byteAt(pos);
                if ((byteAtPos & 0xC0) == 128) {
                    ++pos;
                    continue;
                }
                buffer.insert(pos, EOL_BYTES_PLUS_SPACE);
                pos += wrapColumn - 1 + EOL_BYTES_PLUS_SPACE.length;
            }
        }
        if (base64Encoded && commentAboutBase64EncodedValues) {
            LDIFWriter.writeBase64DecodedValueComment(value.getValue(), buffer, wrapColumn);
        }
    }

    static boolean encodeValue(@NotNull ASN1OctetString value, @NotNull ByteStringBuffer buffer) {
        buffer.append(':');
        byte[] valueBytes = value.getValue();
        if (base64EncodingStrategy.shouldBase64Encode(valueBytes)) {
            buffer.append(": ");
            Base64.encode(valueBytes, buffer);
            return true;
        }
        buffer.append(' ');
        buffer.append(valueBytes);
        return false;
    }

    private static void writeBase64DecodedValueComment(@NotNull byte[] valueBytes, @NotNull ByteStringBuffer buffer, int wrapColumn) {
        if (commentAboutBase64EncodedValues && valueBytes.length <= 1000 && StaticUtils.isValidUTF8(valueBytes)) {
            int wrapColumnMinusTwo = wrapColumn <= 5 ? StaticUtils.TERMINAL_WIDTH_COLUMNS - 3 : wrapColumn - 2;
            int wrapColumnMinusThree = wrapColumnMinusTwo - 1;
            boolean first = true;
            String comment = "Non-base64-encoded representation of the above value: " + LDIFWriter.getEscapedValue(valueBytes);
            for (String s : StaticUtils.wrapLine(comment, wrapColumnMinusTwo, wrapColumnMinusThree)) {
                buffer.append(StaticUtils.EOL);
                buffer.append("# ");
                if (first) {
                    first = false;
                } else {
                    buffer.append(' ');
                }
                buffer.append(s);
            }
        }
    }

    @NotNull
    private static String getEscapedValue(@NotNull byte[] valueBytes) {
        String valueString = StaticUtils.toUTF8String(valueBytes);
        StringBuilder buffer = new StringBuilder(valueString.length());
        block12: for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            switch (c) {
                case '\t': {
                    buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_TAB.get());
                    continue block12;
                }
                case '\n': {
                    buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_CARRIAGE_RETURN.get());
                    continue block12;
                }
                case '\r': {
                    buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_LINE_FEED.get());
                    continue block12;
                }
                case ' ': {
                    if (i == 0) {
                        buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_LEADING_SPACE.get());
                        continue block12;
                    }
                    if (i == valueString.length() - 1) {
                        buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_TRAILING_SPACE.get());
                        continue block12;
                    }
                    buffer.append(' ');
                    continue block12;
                }
                case ':': {
                    if (i == 0) {
                        buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_LEADING_COLON.get());
                        continue block12;
                    }
                    buffer.append(c);
                    continue block12;
                }
                case '<': {
                    if (i == 0) {
                        buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_LEADING_LESS_THAN.get());
                        continue block12;
                    }
                    buffer.append(c);
                    continue block12;
                }
                case '{': {
                    buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_OPENING_CURLY_BRACE.get());
                    continue block12;
                }
                case '}': {
                    buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_CLOSING_CURLY_BRACE.get());
                    continue block12;
                }
                default: {
                    if (c >= '!' && c <= '~') {
                        buffer.append(c);
                        continue block12;
                    }
                    int codePoint = Character.codePointAt(valueString, i);
                    if (StaticUtils.isLikelyDisplayableCharacter(codePoint)) {
                        int[] codePointArray = new int[]{codePoint};
                        buffer.append(new String(codePointArray, 0, 1));
                    } else {
                        String codePointName;
                        try {
                            codePointName = Character.getName(codePoint);
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            codePointName = null;
                        }
                        if (codePointName == null || codePointName.isEmpty()) {
                            int[] codePointArray = new int[]{codePoint};
                            byte[] codePointBytes = StaticUtils.getBytes(new String(codePointArray, 0, 1));
                            buffer.append(LDIFMessages.INFO_LDIF_WRITER_CHAR_HEX.get(StaticUtils.toHex(codePointBytes)));
                        } else {
                            buffer.append("{");
                            buffer.append(codePointName);
                            buffer.append('}');
                        }
                    }
                    int numChars = Character.charCount(codePoint);
                    i += numChars - 1;
                }
            }
        }
        return buffer.toString();
    }

    static void rethrow(@Nullable Throwable t) throws IOException {
        if (t == null) {
            return;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t);
    }

    static {
        String propertyValue = StaticUtils.getSystemProperty(PROPERTY_BASE64_ENCODING_STRATEGY);
        if (propertyValue != null) {
            switch (StaticUtils.toUpperCase(propertyValue).replace('-', '_')) {
                case "MINIMAL": 
                case "MINIMAL_COMPLIANT": {
                    base64EncodingStrategy = Base64EncodingStrategy.MINIMAL_COMPLIANT;
                    break;
                }
                case "USER_FRIENDLY": 
                case "USER_FRIENDLY_NON_COMPLIANT": {
                    base64EncodingStrategy = Base64EncodingStrategy.USER_FRIENDLY_NON_COMPLIANT;
                    break;
                }
                case "MAXIMAL": {
                    base64EncodingStrategy = Base64EncodingStrategy.MAXIMAL;
                    break;
                }
                default: {
                    base64EncodingStrategy = Base64EncodingStrategy.DEFAULT;
                }
            }
        }
        VERSION_1_HEADER_BYTES = StaticUtils.getBytes("version: 1" + StaticUtils.EOL);
    }
}

