// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Redispatch redispatch
//
// swagger:model redispatch
type Redispatch struct {
	// enabled
	// Required: true
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Enabled *string `json:"enabled"`

	// interval
	Interval int64 `json:"interval,omitempty"`
}

// Validate validates this redispatch
func (m *Redispatch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var redispatchTypeEnabledPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		redispatchTypeEnabledPropEnum = append(redispatchTypeEnabledPropEnum, v)
	}
}

const (

	// RedispatchEnabledEnabled captures enum value "enabled"
	RedispatchEnabledEnabled string = "enabled"

	// RedispatchEnabledDisabled captures enum value "disabled"
	RedispatchEnabledDisabled string = "disabled"
)

// prop value enum
func (m *Redispatch) validateEnabledEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, redispatchTypeEnabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Redispatch) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	// value enum
	if err := m.validateEnabledEnum("enabled", "body", *m.Enabled); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this redispatch based on context it is used
func (m *Redispatch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Redispatch) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Redispatch) UnmarshalBinary(b []byte) error {
	var res Redispatch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
