echo "----------------------------------------------------------------"
echo "Please enter full pathname of SOURCE Enterprise release with the arch"
echo "as the trailing directory"
read TREESITE
if [ ! -d $TREESITE ] ; then
  echo "The SOURCE Enterprise directory $TREESITE does not exist." 
  exit
fi
#TREESITE=/export/mirrors/cern/cel3/$ARCH
ARCH=`basename $TREESITE`
export ARCH
#
echo "----------------------------------------------------------------"
echo "Please enter directory name of \"RedHat\"/RPMS directory, ie RedHat"
read DEFAULTSITE
if [ ! -d $TREESITE/$DEFAULTSITE/RPMS ] ; then
  echo "The SOURCE Enterprise directory $TREESITE/$DEFAULTSITE does not exist." 
  exit
fi
#DEFAULTSITE=RedHat
#
if [ -z $site ] ; then
   echo "----------------------------------------------------------------"
   echo "Please enter new site name, one word only please"
   read SITE
else
   SITE=$site
fi
export SITE
#SITE=cel3
if [ -z $tree ] ; then
   echo "----------------------------------------------------------------"
   echo "Enter full pathname of Scientific Linux 3.0.1 release with the arch"
   echo "as the last directory"
   read TREE
else
   TREE=$tree
fi
DEFAULT=SL
if [ ! -d $TREE/$DEFAULT/RPMS ] ; then
  echo "The Scientific Linux directory $TREE does not exist." 
  exit
fi
export TREE
slarch=`basename $TREE`
if [ "$ARCH"  ! -eq "$slarch" ] ; then
  echo "The SOURCE pathname $TREESITE arch does not match the "
  echo "Scientific Linux $TREE arch"
  exit
fi
TO1=$TREE/$DEFAULT/RPMS/
TO2=$TREE/notsupported/RPMS/
TO3=$TREE/errata/obsolete/RPMS/
#
cd $TREESITE
#
mkdir $TREE/sites/$SITE
mkdir $TREE/sites/$SITE/documentation
mkdir $TREE/sites/$SITE/SRPMS
mkdir $TREE/sites/$SITE/Updates
#
mkdir $TREE/sites/$SITE/build
cp -var $TREE/sites/example/build/* $TREE/sites/$SITE/build/
#
mkdir $TREE/sites/$SITE/base
mkdir $TREE/sites/$SITE/base/scripts
mkdir $TREE/sites/$SITE/base/oldcomps
cp -var $TREE/sites/example/base/scripts/* $TREE/sites/$SITE/base/scripts
cp -var $TREESITE/$DEFAULTSITE/base/* $TREE/sites/$SITE/base/ 
#
mkdir $TREE/sites/$SITE/build/isolinux
cp -va $TREESITE/isolinux/*.cfg $TREE/sites/$SITE/build/isolinux
cp -va $TREESITE/isolinux/*.msg $TREE/sites/$SITE/build/isolinux
cp -va $TREESITE/isolinux/*.lss $TREE/sites/$SITE/build/isolinux
#
if [ -d $TREESITE/RHupdates ] ; then
  mkdir $TREE/sites/$SITE/RHupdates
  cp -var $TREESITE/RHupdates/* $TREE/sites/$SITE/RHupdates/ 
fi
#
if [ -f $TREESITE/README ] ; then
  cp -a $TREESITE/README* $TREE/sites/$SITE/ 
fi
if [ -f $TREESITE/RELEASE-NOTES.html ] ; then
  cp -a $TREESITE/RELEASE-NOTES* $TREE/sites/$SITE/ 
fi

echo "Checking if rpms from $TREESITE are in $TO1 and $TO2 "
#echo "Checking if rpms from $TREESITE are in $TO1 and $TO2 and $TO3"
#and if they do not exist in the above places then copy then over
cd $TREESITE/$DEFAULTSITE/RPMS
for i in *.rpm
do
	if [ -f $TO1/$i ] ; then
		echo "$i exists in $TO1"
	else
	   if [ -f $TO2/$i ] ; then
		echo "$i exists in $TO2"
	   else
#	     if [ -f $TO3/$i ] ; then
#		echo "$i exists in $TO3"
#	     else
		echo "$i does NOT exist and copying site/$SITE/Updates"
		cp -a $TREESITE/$DEFAULTSITE/RPMS/$i $TREE/sites/$SITE/Updates 
#	     fi
	   fi
	fi
done
#Now check for some special cases
#First we check for anaconda-9* and anaconda-runtime because we really want
#to use our version
answer=`ls $TREE/sites/$SITE/Updates/anaconda-9.1*.$ARCH.rpm 2>/dev/null` 
if [ ! -z "$answer" ] ; then
  echo "----------------------------------------------------------------"
  echo "You have anaconda-9.1*.$ARCH.rpm in your new Updates area, I will "
  echo "remove it so as to assure that the SL anaconda code is used. "
  echo "If you still want to add your code back in I suggest you put "
  echo "all python modules that are not in /RHupdates/ in your site"
  echo "$TREESITE/sites/$SITE/RHupdates/ directory.  For all "
  echo "python modules that conflict with $TREE/RHupdates/ "
  echo "you need to copy the modules from"
  echo "$TREE/RHupdates/ into "
  echo "$TREESITE/sites/$SITE/RHupdates/ and add your changes "
  echo "to those."
  echo "----------------------------------------------------------------"
  rm $TREE/sites/$SITE/Updates/anaconda-9.1*.$ARCH.rpm
fi
answer=""
answer=`ls $TREE/sites/$SITE/Updates/anaconda-runtime*.$ARCH.rpm 2>/dev/null` 
if [ ! -z "$answer" ] ; then
  echo "----------------------------------------------------------------"
  echo "You have anaconda-runtime*.$ARCH.rpm in your new Updates area, I will "
  echo "remove it so as to assure that the SL anaconda code is used. "
  rm $TREE/sites/$SITE/Updates/anaconda-runtime*.$ARCH.rpm
  echo "----------------------------------------------------------------"
fi
