#!/usr/bin/env python2.2

# Copyright (C) 2003 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import sys
import os
import os.path
import string
import getopt
import time
import types
import rpm

class Timber:
    """Split trees like no other"""
    def __init__(self):
        
        """self.release_str : the name and version of the product, ie "Red Hat Linux 9"
     
self.package_order_file : the location of the file which has
the package ordering
        
self.arch : the arch the tree is intended for
        
self.real_arch : the arch found in the unified tree's
.discinfo file
        
self.dist_dir : the loaction of the unified tree

self.src_dir : the location of the unified SRPM dir
        
self.start_time : the timestamp that's in .discinfo files
        
self.dir_info : The info other than start_time that goes
into the .discinfo files. The info should already exist
after running buildinstall in the unified tree
        
self.total_discs : total number of discs
        
self.total_bin_discs : total number of discs with RPMs
        
self.total_srpm_discs : total number of discs with SRPMs
        
self.reverse_sort_srpms : sort the srpms in reverse order to
fit. Usually only needed if we share a disc between SRPMs
and RPMs. Set to 1 to turn on."""
        
        self.target_size = 640.0 * 1024.0 * 1024
        self.fudge_factor = 1.2 * 1024.0 * 1024
        self.comps_size = 10.0 * 1024 * 1024
        self.release_str = None
        self.package_order_file = None
        self.arch = None
        self.real_arch = None
        self.dist_dir = None
        self.src_dir = None
        self.start_time = None
        self.dir_info = None
        self.total_discs = None
        self.bin_discs = None
        self.src_discs = None
        self.bin_list = []
        self.src_list = []
        self.shared_list = []
        self.reverse_sort_srpms=None
        self.common_files = ['beta_eula.txt', 'EULA', 'README', 'GPL', 'RPM-GPG-KEY', 'RPM-GPG-KEY-beta']
        self.logfile = []
	self.defarea = None 
	self.sitedir = "sites"
	self.site  = None 
	self.dir = None
	self.disc1only = []
	self.disc2only = []
	self.disc3only = ['/misc/']
	self.disc4only = ['/notsupported/','/contrib/']
	self.excludedirs = ['/errata/','/apt-rpm/','/images/','/sites/']

    def getSize(seld, path, blocksize=None):
        """Gets the size as reported by du -s"""

        if blocksize:
            p = os.popen("du -s --block-size=1 %s" % path, 'r')
            thesize = p.read()
            p.close()
            thesize = int(string.split(thesize)[0])
            return thesize
        else:
            p = os.popen("du -sh %s" % path, 'r')
            thesize = p.read()
            p.close()
            thesize = string.split(thesize)[0]
            return thesize

    def reportSizes(self, disc, firstpkg=None, lastpkg=None):
        """appends to self.logfile"""
        
        if firstpkg:
            self.logfile.append("First package on disc%d: %s" % (disc, firstpkg))
        if lastpkg:
            self.logfile.append("Last package on disc%d : %s" % (disc, lastpkg))

        discsize = self.getSize("%s-disc%d" % (self.dist_dir, disc))
        self.logfile.append("%s-disc%d size: %s" % (self.arch, disc, discsize))

    def linkFiles(self, src_dir, dest_dir, filelist):
        """Creates hardlinks from files in the unified dir to files in the split dirs. This is not for RPMs or SRPMs"""

        for file in filelist:
            src = "%s/%s" % (src_dir, file)
            dest = "%s/%s" % (dest_dir, file)
            try:
                os.link(src, dest)
            except OSError, (errno, msg):
                pass

    def rebuild_with_excludelist(self,filelist,excludelist):
        newlist = []
	for searchitem in excludelist:
	   print "searchitem is %s" % searchitem
	   for j in range(0, len(filelist)):
	      print "filelist[j] is %s" % filelist[j]
	      result=string.find(filelist[j],searchitem)
	      if result < 0 :
		print "ok"
		newlist.append(filelist[j])
	      else:
		print "found it"
        filelist=newlist

    def createSplitDirs(self):
        """Figures out which discs are for RPMs, which are for SRPMs,
        and which are shared. Also creates links for files on disc1
        and files which are common across all discs"""

        if self.bin_discs > self.total_discs or self.src_discs > self.total_discs:
            raise RuntimeError, "CRITICAL ERROR : Number of discs specified exceeds the total number of discs"

        # get a list of discs for each type of disc. shared_list will
        # be returned for sorting out which discs SRPMS can land on
        self.bin_list = range(1, self.bin_discs + 1)
        self.src_list = range(self.total_discs - self.src_discs + 1, self.total_discs + 1)
        self.shared_list = range(self.total_discs - self.src_discs + 1, self.bin_discs + 1)

        for i in range(self.bin_list[0], self.bin_list[-1] + 1):
            if i == 1:
                p = os.popen('find %s -type f -not -name .discinfo ' % self.dist_dir, 'r')
                filelist = p.read()
                p.close()
                filelist = string.split(filelist)
		print "filelist"
		print filelist                
                p = os.popen('find %s -type d -not -name RPMS -not -name SRPMS' % self.dist_dir, 'r')
                dirlist = p.read()
                p.close()
                dirlist = string.split(dirlist)
		print "-----------------------------------------------------"
		print "First dirlist"
		print dirlist
                
                dont_create = []
                # we need to clean up the dirlist first. We don't want everything yet
                for j in range(0, len(dirlist)):
                    dirlist[j] = string.replace(dirlist[j], self.dist_dir, '')
		self.rebuild_with_excludelist(dirlist,self.excludedirs)
		    
		print "-----------------------------------------------------"
		print "New dirlist"
		print dirlist
		print "-----------------------------------------------------"
                # now create the dirs for disc1
                for j in range(0, len(dirlist)):
                    os.makedirs("%s-disc%d/%s" % (self.dist_dir, i, dirlist[j]))
                                
                for j in range(0, len(filelist)):
                    filelist[j] = string.replace(filelist[j], self.dist_dir, '')
		    print ("filelist[j] is %s/%s at %s-disc%d/%s" % (self.dist_dir,filelist[j],self.dist_dir, i, filelist[j] ))
                    try:
                        os.link(os.path.normpath("%s/%s" % (self.dist_dir, filelist[j])),
                                os.path.normpath("%s-disc%d/%s" % (self.dist_dir, i, filelist[j])))
                    except OSError, (errno, msg):
                        pass

                # now create the self.defarea/RPMS dir
                os.makedirs("%s-disc%d/%s/RPMS" % (self.dist_dir, i,self.defarea))
                
            else:
                os.makedirs("%s-disc%d/%s/RPMS" % (self.dist_dir, i,self.defarea))
                self.linkFiles(self.dist_dir, "%s-disc%d" %(self.dist_dir, i), self.common_files)
            
        for i in range(self.src_list[0], self.src_list[-1] + 1):
            os.makedirs("%s-disc%d/SRPMS" % (self.dist_dir, i))
            self.linkFiles(self.dist_dir, "%s-disc%d" %(self.dist_dir, i), self.common_files)

    def main(self):
        self.createSplitDirs()
        return self.logfile

def usage(theerror):
    print theerror
    print """Usage: %s --arch=i386 --total-discs=6 --bin-discs=3 --src-discs=3 --release-string="Red Hat Linux" --default=<default> --site=<site> --pkgorderfile=/tmp/pkgorder.12345 --distdir=/usr/src/someunifiedtree --srcdir=/usr/src/someunifiedtree/SRPMS""" % sys.argv[0]
    sys.exit(1)

        
if "__main__" == __name__:
    import getopt
    
    timber = Timber()

    theargs = ["arch=", "total-discs=", "bin-discs=",
               "src-discs=", "release-string=", "pkgorderfile=",
               "distdir=", "srcdir=", "default=", "site="]

    try:
        options, args = getopt.getopt(sys.argv[1:], '', theargs)
    except getopt.error, error:
        usage(msg)

    myopts = {}
    for i in options:
        myopts[i[0]] = i[1]

    options = myopts

    if options.has_key("--arch"):
        timber.arch = options['--arch']
    else:
        usage("You forgot to specify --arch")

    if options.has_key("--total-discs"):
        timber.total_discs = int(options['--total-discs'])
    else:
        usage("You forgot to specify --total-discs")

    if options.has_key("--bin-discs"):
        timber.bin_discs = int(options['--bin-discs'])
    else:
        usage("You forgot to specify --bin-discs")

    if options.has_key("--src-discs"):
        timber.src_discs = int(options['--src-discs'])
    else:
        usage("You forgot to specify --src-discs")

    if options.has_key("--release-string"):
        timber.release_str = options["--release-string"]
    else:
        usage("You forgot to specify --release-string")

    if options.has_key("--pkgorderfile"):
        timber.package_order_file = options["--pkgorderfile"]
    else:
        usage("You forgot to specify --pkgorderfile")

    if options.has_key("--distdir"):
        timber.dist_dir = options["--distdir"]
    else:
        usage("You forgot to specify --distdir")

    if options.has_key("--srcdir"):
        timber.src_dir = options["--srcdir"]
    else:
        usage("You forgot to specify --srcdir")

    if options.has_key("--default"):
        timber.defarea = options["--default"]
    else:
        usage("You forgot to specify --default")
    
    if options.has_key("--site"):
        timber.site = options["--site"]

    logfile = timber.main()
    
    for logentry in range(0, len(logfile)):
        print logfile[logentry]

    sys.exit(0)
