/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.rmic;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TabbedWriter
extends FilterWriter {
    private static final String defaultTabstring = "    ";
    private char[] tabstring;
    private int tabs = 0;

    public TabbedWriter(Writer o) {
        this(o, defaultTabstring);
    }

    public TabbedWriter(Writer o, String str) {
        super(o);
        this.tabstring = str.toCharArray();
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        if (c == 10) {
            for (int i = 0; i < this.tabs; ++i) {
                this.out.write(this.tabstring, 0, this.tabstring.length);
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[i + off]);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    public void unindent() throws IOException {
        this.unindent(1);
    }

    public void unindent(int nr) throws IOException {
        this.indent(-nr);
    }

    public void indent() throws IOException {
        this.indent(1);
    }

    public void indent(int nr) throws IOException {
        this.tabs += nr;
        if (this.tabs < 0) {
            this.tabs = 0;
        }
        this.write(10);
    }
}

