/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rectangle(Point p, Dimension d) {
        this.x = p.x;
        this.y = p.y;
        this.width = d.width;
        this.height = d.height;
    }

    public Rectangle(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Rectangle(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRect(double x, double y, double width, double height) {
        this.x = (int)x;
        this.y = (int)y;
        this.width = (int)width;
        this.height = (int)height;
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void resize(int width, int height) {
        this.setSize(width, height);
    }

    public boolean contains(Point p) {
        return this.width > 0 && this.height > 0 && p.x >= this.x && p.x < this.x + this.width && p.y >= this.y && p.y < this.y + this.height;
    }

    public boolean contains(int x, int y) {
        return this.width > 0 && this.height > 0 && this.x <= x && this.x + this.width > x && this.y <= y && this.y + this.height > y;
    }

    public boolean contains(Rectangle r) {
        return this.width > 0 && this.height > 0 && r.width > 0 && r.height > 0 && r.x >= this.x && r.x + r.width <= this.x + this.width && r.y >= this.y && r.y + r.height <= this.y + this.height;
    }

    public boolean contains(int x, int y, int w, int h) {
        return this.width > 0 && this.height > 0 && w > 0 && h > 0 && this.x <= x && x + w <= this.x + this.width && this.y <= y && y + h <= this.y + this.height;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public boolean intersects(Rectangle r) {
        return this.width > 0 && this.height > 0 && r.width > 0 && r.height > 0 && r.x < this.x + this.width && r.x + r.width > this.x && r.y < this.y + this.height && r.y + r.height > this.y;
    }

    public Rectangle intersection(Rectangle r) {
        Rectangle res = new Rectangle();
        Rectangle2D.intersect(this, r, res);
        return res;
    }

    public Rectangle union(Rectangle r) {
        Rectangle res = new Rectangle();
        Rectangle2D.union(this, r, res);
        return res;
    }

    public void add(int x, int y) {
        this.add((double)x, (double)y);
    }

    public void add(Point p) {
        this.add((double)p.x, (double)p.y);
    }

    public void add(Rectangle r) {
        Rectangle2D.union(this, r, this);
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.y -= v;
        int n = h;
        this.width += n + n;
        int n2 = v;
        this.height += n2 + n2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int outcode(double x, double y) {
        int result = 0;
        if (this.width <= 0) {
            result |= 5;
        } else if (x < (double)this.x) {
            result |= 1;
        } else if (x > (double)(this.x + this.width)) {
            result |= 4;
        }
        if (this.height <= 0) {
            result |= 0xA;
        } else if (y < (double)this.y) {
            result |= 2;
        } else if (y > (double)(this.y + this.height)) {
            result |= 8;
        }
        return result;
    }

    public Rectangle2D createIntersection(Rectangle2D r) {
        Rectangle2D res = r.getBounds2D();
        Rectangle2D.intersect(this, r, res);
        return res;
    }

    public Rectangle2D createUnion(Rectangle2D r) {
        Rectangle2D res = r.getBounds2D();
        Rectangle2D.union(this, r, res);
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D r = (Rectangle2D)obj;
        return r.getX() == (double)this.x && r.getY() == (double)this.y && r.getWidth() == (double)this.width && r.getHeight() == (double)this.height;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + ']';
    }
}

