/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharBufferImpl
extends CharBuffer {
    private boolean readOnly;

    CharBufferImpl(int capacity) {
        this(new char[capacity], 0, capacity, capacity, 0, -1, false);
    }

    CharBufferImpl(char[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public CharBufferImpl(CharBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public CharBuffer slice() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public CharBuffer duplicate() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public CharBuffer asReadOnlyBuffer() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public CharBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final CharSequence subSequence(int start, int end) {
        if (start < 0 || start > this.length() || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.position() + end, this.position() + start, -1, this.isReadOnly());
    }

    public final char get() {
        char result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final CharBuffer put(char value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final char get(int index) {
        if (index < 0 || index >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        return this.backing_buffer[index];
    }

    public final CharBuffer put(int index, char value) {
        if (index < 0 || index >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

