/*
** Copyright (c) 2018-2023 Valve Corporation
** Copyright (c) 2018-2023 LunarG, Inc.
** Copyright (c) 2023 Advanced Micro Devices, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_VULKAN_LAYER_FUNC_TABLE_H
#define  GFXRECON_GENERATED_VULKAN_LAYER_FUNC_TABLE_H

#include "encode/custom_vulkan_api_call_encoders.h"
#include "generated/generated_vulkan_api_call_encoders.h"
#include "layer/layer_vulkan_entry.h"
#include "util/defines.h"

#include "vulkan/vulkan.h"
#include "vk_video/vulkan_video_codec_h264std.h"
#include "vk_video/vulkan_video_codec_h264std_decode.h"
#include "vk_video/vulkan_video_codec_h264std_encode.h"
#include "vk_video/vulkan_video_codec_h265std.h"
#include "vk_video/vulkan_video_codec_h265std_decode.h"
#include "vk_video/vulkan_video_codec_h265std_encode.h"
#include "vk_video/vulkan_video_codecs_common.h"

#include <unordered_map>

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(vulkan_layer)
// This static function can be used to avoid issues with static variable initialization order.
static inline const std::unordered_map<std::string, PFN_vkVoidFunction> GetVulkanLayerFuncTable() {
    return {
        { "vkCreateInstance",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateInstance) },
        { "vkDestroyInstance",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyInstance) },
        { "vkEnumeratePhysicalDevices",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkEnumeratePhysicalDevices) },
        { "vkGetPhysicalDeviceFeatures",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFeatures) },
        { "vkGetPhysicalDeviceFormatProperties",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFormatProperties) },
        { "vkGetPhysicalDeviceImageFormatProperties",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceImageFormatProperties) },
        { "vkGetPhysicalDeviceProperties",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceProperties) },
        { "vkGetPhysicalDeviceQueueFamilyProperties",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyProperties) },
        { "vkGetPhysicalDeviceMemoryProperties",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceMemoryProperties) },
        { "vkGetInstanceProcAddr",                                                                               reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::GetInstanceProcAddr) },
        { "vkGetDeviceProcAddr",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::GetDeviceProcAddr) },
        { "vkCreateDevice",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDevice) },
        { "vkDestroyDevice",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDevice) },
        { "vkEnumerateInstanceExtensionProperties",                                                              reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::EnumerateInstanceExtensionProperties) },
        { "vkEnumerateDeviceExtensionProperties",                                                                reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::EnumerateDeviceExtensionProperties) },
        { "vkEnumerateInstanceLayerProperties",                                                                  reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::EnumerateInstanceLayerProperties) },
        { "vkEnumerateDeviceLayerProperties",                                                                    reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::EnumerateDeviceLayerProperties) },
        { "vkGetDeviceQueue",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceQueue) },
        { "vkQueueSubmit",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueSubmit) },
        { "vkQueueWaitIdle",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueWaitIdle) },
        { "vkDeviceWaitIdle",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkDeviceWaitIdle) },
        { "vkAllocateMemory",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkAllocateMemory) },
        { "vkFreeMemory",                                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkFreeMemory) },
        { "vkMapMemory",                                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkMapMemory) },
        { "vkUnmapMemory",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkUnmapMemory) },
        { "vkFlushMappedMemoryRanges",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkFlushMappedMemoryRanges) },
        { "vkInvalidateMappedMemoryRanges",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkInvalidateMappedMemoryRanges) },
        { "vkGetDeviceMemoryCommitment",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceMemoryCommitment) },
        { "vkBindBufferMemory",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindBufferMemory) },
        { "vkBindImageMemory",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindImageMemory) },
        { "vkGetBufferMemoryRequirements",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferMemoryRequirements) },
        { "vkGetImageMemoryRequirements",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageMemoryRequirements) },
        { "vkGetImageSparseMemoryRequirements",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSparseMemoryRequirements) },
        { "vkGetPhysicalDeviceSparseImageFormatProperties",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSparseImageFormatProperties) },
        { "vkQueueBindSparse",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueBindSparse) },
        { "vkCreateFence",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateFence) },
        { "vkDestroyFence",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyFence) },
        { "vkResetFences",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetFences) },
        { "vkGetFenceStatus",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetFenceStatus) },
        { "vkWaitForFences",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkWaitForFences) },
        { "vkCreateSemaphore",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSemaphore) },
        { "vkDestroySemaphore",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySemaphore) },
        { "vkCreateQueryPool",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateQueryPool) },
        { "vkDestroyQueryPool",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyQueryPool) },
        { "vkGetQueryPoolResults",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetQueryPoolResults) },
        { "vkCreateBuffer",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateBuffer) },
        { "vkDestroyBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyBuffer) },
        { "vkCreateImage",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateImage) },
        { "vkDestroyImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyImage) },
        { "vkGetImageSubresourceLayout",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSubresourceLayout) },
        { "vkCreateImageView",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateImageView) },
        { "vkDestroyImageView",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyImageView) },
        { "vkCreateCommandPool",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateCommandPool) },
        { "vkDestroyCommandPool",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyCommandPool) },
        { "vkResetCommandPool",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetCommandPool) },
        { "vkAllocateCommandBuffers",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkAllocateCommandBuffers) },
        { "vkFreeCommandBuffers",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkFreeCommandBuffers) },
        { "vkBeginCommandBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkBeginCommandBuffer) },
        { "vkEndCommandBuffer",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkEndCommandBuffer) },
        { "vkResetCommandBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetCommandBuffer) },
        { "vkCmdCopyBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBuffer) },
        { "vkCmdCopyImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImage) },
        { "vkCmdCopyBufferToImage",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBufferToImage) },
        { "vkCmdCopyImageToBuffer",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImageToBuffer) },
        { "vkCmdUpdateBuffer",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdUpdateBuffer) },
        { "vkCmdFillBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdFillBuffer) },
        { "vkCmdPipelineBarrier",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPipelineBarrier) },
        { "vkCmdBeginQuery",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginQuery) },
        { "vkCmdEndQuery",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndQuery) },
        { "vkCmdResetQueryPool",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResetQueryPool) },
        { "vkCmdWriteTimestamp",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteTimestamp) },
        { "vkCmdCopyQueryPoolResults",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyQueryPoolResults) },
        { "vkCmdExecuteCommands",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdExecuteCommands) },
        { "vkCreateEvent",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateEvent) },
        { "vkDestroyEvent",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyEvent) },
        { "vkGetEventStatus",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetEventStatus) },
        { "vkSetEvent",                                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetEvent) },
        { "vkResetEvent",                                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetEvent) },
        { "vkCreateBufferView",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateBufferView) },
        { "vkDestroyBufferView",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyBufferView) },
        { "vkCreateShaderModule",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateShaderModule) },
        { "vkDestroyShaderModule",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyShaderModule) },
        { "vkCreatePipelineCache",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreatePipelineCache) },
        { "vkDestroyPipelineCache",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPipelineCache) },
        { "vkGetPipelineCacheData",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineCacheData) },
        { "vkMergePipelineCaches",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkMergePipelineCaches) },
        { "vkCreateComputePipelines",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateComputePipelines) },
        { "vkDestroyPipeline",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPipeline) },
        { "vkCreatePipelineLayout",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreatePipelineLayout) },
        { "vkDestroyPipelineLayout",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPipelineLayout) },
        { "vkCreateSampler",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSampler) },
        { "vkDestroySampler",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySampler) },
        { "vkCreateDescriptorSetLayout",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDescriptorSetLayout) },
        { "vkDestroyDescriptorSetLayout",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDescriptorSetLayout) },
        { "vkCreateDescriptorPool",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDescriptorPool) },
        { "vkDestroyDescriptorPool",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDescriptorPool) },
        { "vkResetDescriptorPool",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetDescriptorPool) },
        { "vkAllocateDescriptorSets",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkAllocateDescriptorSets) },
        { "vkFreeDescriptorSets",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkFreeDescriptorSets) },
        { "vkUpdateDescriptorSets",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateDescriptorSets) },
        { "vkCmdBindPipeline",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindPipeline) },
        { "vkCmdBindDescriptorSets",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorSets) },
        { "vkCmdClearColorImage",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdClearColorImage) },
        { "vkCmdDispatch",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatch) },
        { "vkCmdDispatchIndirect",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatchIndirect) },
        { "vkCmdSetEvent",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetEvent) },
        { "vkCmdResetEvent",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResetEvent) },
        { "vkCmdWaitEvents",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWaitEvents) },
        { "vkCmdPushConstants",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushConstants) },
        { "vkCreateGraphicsPipelines",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateGraphicsPipelines) },
        { "vkCreateFramebuffer",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateFramebuffer) },
        { "vkDestroyFramebuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyFramebuffer) },
        { "vkCreateRenderPass",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateRenderPass) },
        { "vkDestroyRenderPass",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyRenderPass) },
        { "vkGetRenderAreaGranularity",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRenderAreaGranularity) },
        { "vkCmdSetViewport",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewport) },
        { "vkCmdSetScissor",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetScissor) },
        { "vkCmdSetLineWidth",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineWidth) },
        { "vkCmdSetDepthBias",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBias) },
        { "vkCmdSetBlendConstants",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetBlendConstants) },
        { "vkCmdSetDepthBounds",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBounds) },
        { "vkCmdSetStencilCompareMask",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilCompareMask) },
        { "vkCmdSetStencilWriteMask",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilWriteMask) },
        { "vkCmdSetStencilReference",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilReference) },
        { "vkCmdBindIndexBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindIndexBuffer) },
        { "vkCmdBindVertexBuffers",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindVertexBuffers) },
        { "vkCmdDraw",                                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDraw) },
        { "vkCmdDrawIndexed",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndexed) },
        { "vkCmdDrawIndirect",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndirect) },
        { "vkCmdDrawIndexedIndirect",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndexedIndirect) },
        { "vkCmdBlitImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBlitImage) },
        { "vkCmdClearDepthStencilImage",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdClearDepthStencilImage) },
        { "vkCmdClearAttachments",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdClearAttachments) },
        { "vkCmdResolveImage",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResolveImage) },
        { "vkCmdBeginRenderPass",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginRenderPass) },
        { "vkCmdNextSubpass",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdNextSubpass) },
        { "vkCmdEndRenderPass",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRenderPass) },
        { "vkBindBufferMemory2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindBufferMemory2) },
        { "vkBindImageMemory2",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindImageMemory2) },
        { "vkGetDeviceGroupPeerMemoryFeatures",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceGroupPeerMemoryFeatures) },
        { "vkCmdSetDeviceMask",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDeviceMask) },
        { "vkEnumeratePhysicalDeviceGroups",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkEnumeratePhysicalDeviceGroups) },
        { "vkGetImageMemoryRequirements2",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageMemoryRequirements2) },
        { "vkGetBufferMemoryRequirements2",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferMemoryRequirements2) },
        { "vkGetImageSparseMemoryRequirements2",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSparseMemoryRequirements2) },
        { "vkGetPhysicalDeviceFeatures2",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFeatures2) },
        { "vkGetPhysicalDeviceProperties2",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceProperties2) },
        { "vkGetPhysicalDeviceFormatProperties2",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFormatProperties2) },
        { "vkGetPhysicalDeviceImageFormatProperties2",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceImageFormatProperties2) },
        { "vkGetPhysicalDeviceQueueFamilyProperties2",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyProperties2) },
        { "vkGetPhysicalDeviceMemoryProperties2",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceMemoryProperties2) },
        { "vkGetPhysicalDeviceSparseImageFormatProperties2",                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSparseImageFormatProperties2) },
        { "vkTrimCommandPool",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkTrimCommandPool) },
        { "vkGetDeviceQueue2",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceQueue2) },
        { "vkGetPhysicalDeviceExternalBufferProperties",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalBufferProperties) },
        { "vkGetPhysicalDeviceExternalFenceProperties",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalFenceProperties) },
        { "vkGetPhysicalDeviceExternalSemaphoreProperties",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalSemaphoreProperties) },
        { "vkCmdDispatchBase",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatchBase) },
        { "vkCreateDescriptorUpdateTemplate",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDescriptorUpdateTemplate) },
        { "vkDestroyDescriptorUpdateTemplate",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDescriptorUpdateTemplate) },
        { "vkUpdateDescriptorSetWithTemplate",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateDescriptorSetWithTemplate) },
        { "vkGetDescriptorSetLayoutSupport",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetLayoutSupport) },
        { "vkCreateSamplerYcbcrConversion",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSamplerYcbcrConversion) },
        { "vkDestroySamplerYcbcrConversion",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySamplerYcbcrConversion) },
        { "vkResetQueryPool",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetQueryPool) },
        { "vkGetSemaphoreCounterValue",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSemaphoreCounterValue) },
        { "vkWaitSemaphores",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkWaitSemaphores) },
        { "vkSignalSemaphore",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkSignalSemaphore) },
        { "vkGetBufferDeviceAddress",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferDeviceAddress) },
        { "vkGetBufferOpaqueCaptureAddress",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferOpaqueCaptureAddress) },
        { "vkGetDeviceMemoryOpaqueCaptureAddress",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceMemoryOpaqueCaptureAddress) },
        { "vkCmdDrawIndirectCount",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndirectCount) },
        { "vkCmdDrawIndexedIndirectCount",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndexedIndirectCount) },
        { "vkCreateRenderPass2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateRenderPass2) },
        { "vkCmdBeginRenderPass2",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginRenderPass2) },
        { "vkCmdNextSubpass2",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdNextSubpass2) },
        { "vkCmdEndRenderPass2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRenderPass2) },
        { "vkGetPhysicalDeviceToolProperties",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceToolProperties) },
        { "vkCreatePrivateDataSlot",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreatePrivateDataSlot) },
        { "vkDestroyPrivateDataSlot",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPrivateDataSlot) },
        { "vkSetPrivateData",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetPrivateData) },
        { "vkGetPrivateData",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPrivateData) },
        { "vkCmdPipelineBarrier2",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPipelineBarrier2) },
        { "vkCmdWriteTimestamp2",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteTimestamp2) },
        { "vkQueueSubmit2",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueSubmit2) },
        { "vkCmdCopyBuffer2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBuffer2) },
        { "vkCmdCopyImage2",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImage2) },
        { "vkCmdCopyBufferToImage2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBufferToImage2) },
        { "vkCmdCopyImageToBuffer2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImageToBuffer2) },
        { "vkGetDeviceBufferMemoryRequirements",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceBufferMemoryRequirements) },
        { "vkGetDeviceImageMemoryRequirements",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageMemoryRequirements) },
        { "vkGetDeviceImageSparseMemoryRequirements",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageSparseMemoryRequirements) },
        { "vkCmdSetEvent2",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetEvent2) },
        { "vkCmdResetEvent2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResetEvent2) },
        { "vkCmdWaitEvents2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWaitEvents2) },
        { "vkCmdBlitImage2",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBlitImage2) },
        { "vkCmdResolveImage2",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResolveImage2) },
        { "vkCmdBeginRendering",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginRendering) },
        { "vkCmdEndRendering",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRendering) },
        { "vkCmdSetCullMode",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCullMode) },
        { "vkCmdSetFrontFace",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetFrontFace) },
        { "vkCmdSetPrimitiveTopology",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPrimitiveTopology) },
        { "vkCmdSetViewportWithCount",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportWithCount) },
        { "vkCmdSetScissorWithCount",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetScissorWithCount) },
        { "vkCmdBindVertexBuffers2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindVertexBuffers2) },
        { "vkCmdSetDepthTestEnable",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthTestEnable) },
        { "vkCmdSetDepthWriteEnable",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthWriteEnable) },
        { "vkCmdSetDepthCompareOp",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthCompareOp) },
        { "vkCmdSetDepthBoundsTestEnable",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBoundsTestEnable) },
        { "vkCmdSetStencilTestEnable",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilTestEnable) },
        { "vkCmdSetStencilOp",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilOp) },
        { "vkCmdSetRasterizerDiscardEnable",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRasterizerDiscardEnable) },
        { "vkCmdSetDepthBiasEnable",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBiasEnable) },
        { "vkCmdSetPrimitiveRestartEnable",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPrimitiveRestartEnable) },
        { "vkMapMemory2",                                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkMapMemory2) },
        { "vkUnmapMemory2",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkUnmapMemory2) },
        { "vkGetDeviceImageSubresourceLayout",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageSubresourceLayout) },
        { "vkGetImageSubresourceLayout2",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSubresourceLayout2) },
        { "vkCopyMemoryToImage",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMemoryToImage) },
        { "vkCopyImageToMemory",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyImageToMemory) },
        { "vkCopyImageToImage",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyImageToImage) },
        { "vkTransitionImageLayout",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkTransitionImageLayout) },
        { "vkCmdPushDescriptorSet",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSet) },
        { "vkCmdPushDescriptorSetWithTemplate",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSetWithTemplate) },
        { "vkCmdBindDescriptorSets2",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorSets2) },
        { "vkCmdPushConstants2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushConstants2) },
        { "vkCmdPushDescriptorSet2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSet2) },
        { "vkCmdPushDescriptorSetWithTemplate2",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSetWithTemplate2) },
        { "vkCmdSetLineStipple",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineStipple) },
        { "vkCmdBindIndexBuffer2",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindIndexBuffer2) },
        { "vkGetRenderingAreaGranularity",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRenderingAreaGranularity) },
        { "vkCmdSetRenderingAttachmentLocations",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRenderingAttachmentLocations) },
        { "vkCmdSetRenderingInputAttachmentIndices",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRenderingInputAttachmentIndices) },
        { "vkDestroySurfaceKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySurfaceKHR) },
        { "vkGetPhysicalDeviceSurfaceSupportKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceSupportKHR) },
        { "vkGetPhysicalDeviceSurfaceCapabilitiesKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceCapabilitiesKHR) },
        { "vkGetPhysicalDeviceSurfaceFormatsKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceFormatsKHR) },
        { "vkGetPhysicalDeviceSurfacePresentModesKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfacePresentModesKHR) },
        { "vkCreateSwapchainKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSwapchainKHR) },
        { "vkDestroySwapchainKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySwapchainKHR) },
        { "vkGetSwapchainImagesKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSwapchainImagesKHR) },
        { "vkAcquireNextImageKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireNextImageKHR) },
        { "vkQueuePresentKHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueuePresentKHR) },
        { "vkGetDeviceGroupPresentCapabilitiesKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceGroupPresentCapabilitiesKHR) },
        { "vkGetDeviceGroupSurfacePresentModesKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceGroupSurfacePresentModesKHR) },
        { "vkGetPhysicalDevicePresentRectanglesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDevicePresentRectanglesKHR) },
        { "vkAcquireNextImage2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireNextImage2KHR) },
        { "vkGetPhysicalDeviceDisplayPropertiesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceDisplayPropertiesKHR) },
        { "vkGetPhysicalDeviceDisplayPlanePropertiesKHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceDisplayPlanePropertiesKHR) },
        { "vkGetDisplayPlaneSupportedDisplaysKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDisplayPlaneSupportedDisplaysKHR) },
        { "vkGetDisplayModePropertiesKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDisplayModePropertiesKHR) },
        { "vkCreateDisplayModeKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDisplayModeKHR) },
        { "vkGetDisplayPlaneCapabilitiesKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDisplayPlaneCapabilitiesKHR) },
        { "vkCreateDisplayPlaneSurfaceKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDisplayPlaneSurfaceKHR) },
        { "vkCreateSharedSwapchainsKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSharedSwapchainsKHR) },
        { "vkCreateXlibSurfaceKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateXlibSurfaceKHR) },
        { "vkGetPhysicalDeviceXlibPresentationSupportKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceXlibPresentationSupportKHR) },
        { "vkCreateXcbSurfaceKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateXcbSurfaceKHR) },
        { "vkGetPhysicalDeviceXcbPresentationSupportKHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceXcbPresentationSupportKHR) },
        { "vkCreateWaylandSurfaceKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateWaylandSurfaceKHR) },
        { "vkGetPhysicalDeviceWaylandPresentationSupportKHR",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceWaylandPresentationSupportKHR) },
        { "vkCreateAndroidSurfaceKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateAndroidSurfaceKHR) },
        { "vkCreateWin32SurfaceKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateWin32SurfaceKHR) },
        { "vkGetPhysicalDeviceWin32PresentationSupportKHR",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceWin32PresentationSupportKHR) },
        { "vkGetPhysicalDeviceVideoCapabilitiesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceVideoCapabilitiesKHR) },
        { "vkGetPhysicalDeviceVideoFormatPropertiesKHR",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceVideoFormatPropertiesKHR) },
        { "vkCreateVideoSessionKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateVideoSessionKHR) },
        { "vkDestroyVideoSessionKHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyVideoSessionKHR) },
        { "vkGetVideoSessionMemoryRequirementsKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetVideoSessionMemoryRequirementsKHR) },
        { "vkBindVideoSessionMemoryKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindVideoSessionMemoryKHR) },
        { "vkCreateVideoSessionParametersKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateVideoSessionParametersKHR) },
        { "vkUpdateVideoSessionParametersKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateVideoSessionParametersKHR) },
        { "vkDestroyVideoSessionParametersKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyVideoSessionParametersKHR) },
        { "vkCmdBeginVideoCodingKHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginVideoCodingKHR) },
        { "vkCmdEndVideoCodingKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndVideoCodingKHR) },
        { "vkCmdControlVideoCodingKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdControlVideoCodingKHR) },
        { "vkCmdDecodeVideoKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDecodeVideoKHR) },
        { "vkCmdBeginRenderingKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginRenderingKHR) },
        { "vkCmdEndRenderingKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRenderingKHR) },
        { "vkGetPhysicalDeviceFeatures2KHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFeatures2KHR) },
        { "vkGetPhysicalDeviceProperties2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceProperties2KHR) },
        { "vkGetPhysicalDeviceFormatProperties2KHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFormatProperties2KHR) },
        { "vkGetPhysicalDeviceImageFormatProperties2KHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceImageFormatProperties2KHR) },
        { "vkGetPhysicalDeviceQueueFamilyProperties2KHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyProperties2KHR) },
        { "vkGetPhysicalDeviceMemoryProperties2KHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceMemoryProperties2KHR) },
        { "vkGetPhysicalDeviceSparseImageFormatProperties2KHR",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSparseImageFormatProperties2KHR) },
        { "vkGetDeviceGroupPeerMemoryFeaturesKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceGroupPeerMemoryFeaturesKHR) },
        { "vkCmdSetDeviceMaskKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDeviceMaskKHR) },
        { "vkCmdDispatchBaseKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatchBaseKHR) },
        { "vkTrimCommandPoolKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkTrimCommandPoolKHR) },
        { "vkEnumeratePhysicalDeviceGroupsKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkEnumeratePhysicalDeviceGroupsKHR) },
        { "vkGetPhysicalDeviceExternalBufferPropertiesKHR",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalBufferPropertiesKHR) },
        { "vkGetMemoryWin32HandleKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryWin32HandleKHR) },
        { "vkGetMemoryWin32HandlePropertiesKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryWin32HandlePropertiesKHR) },
        { "vkGetMemoryFdKHR",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryFdKHR) },
        { "vkGetMemoryFdPropertiesKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryFdPropertiesKHR) },
        { "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR) },
        { "vkImportSemaphoreWin32HandleKHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkImportSemaphoreWin32HandleKHR) },
        { "vkGetSemaphoreWin32HandleKHR",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSemaphoreWin32HandleKHR) },
        { "vkImportSemaphoreFdKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkImportSemaphoreFdKHR) },
        { "vkGetSemaphoreFdKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSemaphoreFdKHR) },
        { "vkCmdPushDescriptorSetKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSetKHR) },
        { "vkCmdPushDescriptorSetWithTemplateKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSetWithTemplateKHR) },
        { "vkCreateDescriptorUpdateTemplateKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDescriptorUpdateTemplateKHR) },
        { "vkDestroyDescriptorUpdateTemplateKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDescriptorUpdateTemplateKHR) },
        { "vkUpdateDescriptorSetWithTemplateKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateDescriptorSetWithTemplateKHR) },
        { "vkCreateRenderPass2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateRenderPass2KHR) },
        { "vkCmdBeginRenderPass2KHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginRenderPass2KHR) },
        { "vkCmdNextSubpass2KHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdNextSubpass2KHR) },
        { "vkCmdEndRenderPass2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRenderPass2KHR) },
        { "vkGetSwapchainStatusKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSwapchainStatusKHR) },
        { "vkGetPhysicalDeviceExternalFencePropertiesKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalFencePropertiesKHR) },
        { "vkImportFenceWin32HandleKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkImportFenceWin32HandleKHR) },
        { "vkGetFenceWin32HandleKHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetFenceWin32HandleKHR) },
        { "vkImportFenceFdKHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkImportFenceFdKHR) },
        { "vkGetFenceFdKHR",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetFenceFdKHR) },
        { "vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR",                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR) },
        { "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR",                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR) },
        { "vkAcquireProfilingLockKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireProfilingLockKHR) },
        { "vkReleaseProfilingLockKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseProfilingLockKHR) },
        { "vkGetPhysicalDeviceSurfaceCapabilities2KHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceCapabilities2KHR) },
        { "vkGetPhysicalDeviceSurfaceFormats2KHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceFormats2KHR) },
        { "vkGetPhysicalDeviceDisplayProperties2KHR",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceDisplayProperties2KHR) },
        { "vkGetPhysicalDeviceDisplayPlaneProperties2KHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceDisplayPlaneProperties2KHR) },
        { "vkGetDisplayModeProperties2KHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDisplayModeProperties2KHR) },
        { "vkGetDisplayPlaneCapabilities2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDisplayPlaneCapabilities2KHR) },
        { "vkGetImageMemoryRequirements2KHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageMemoryRequirements2KHR) },
        { "vkGetBufferMemoryRequirements2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferMemoryRequirements2KHR) },
        { "vkGetImageSparseMemoryRequirements2KHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSparseMemoryRequirements2KHR) },
        { "vkCreateSamplerYcbcrConversionKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateSamplerYcbcrConversionKHR) },
        { "vkDestroySamplerYcbcrConversionKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroySamplerYcbcrConversionKHR) },
        { "vkBindBufferMemory2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindBufferMemory2KHR) },
        { "vkBindImageMemory2KHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindImageMemory2KHR) },
        { "vkGetDescriptorSetLayoutSupportKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetLayoutSupportKHR) },
        { "vkCmdDrawIndirectCountKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndirectCountKHR) },
        { "vkCmdDrawIndexedIndirectCountKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndexedIndirectCountKHR) },
        { "vkGetSemaphoreCounterValueKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSemaphoreCounterValueKHR) },
        { "vkWaitSemaphoresKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkWaitSemaphoresKHR) },
        { "vkSignalSemaphoreKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkSignalSemaphoreKHR) },
        { "vkGetPhysicalDeviceFragmentShadingRatesKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceFragmentShadingRatesKHR) },
        { "vkCmdSetFragmentShadingRateKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetFragmentShadingRateKHR) },
        { "vkCmdSetRenderingAttachmentLocationsKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRenderingAttachmentLocationsKHR) },
        { "vkCmdSetRenderingInputAttachmentIndicesKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRenderingInputAttachmentIndicesKHR) },
        { "vkWaitForPresentKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkWaitForPresentKHR) },
        { "vkGetBufferDeviceAddressKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferDeviceAddressKHR) },
        { "vkGetBufferOpaqueCaptureAddressKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferOpaqueCaptureAddressKHR) },
        { "vkGetDeviceMemoryOpaqueCaptureAddressKHR",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceMemoryOpaqueCaptureAddressKHR) },
        { "vkCreateDeferredOperationKHR",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDeferredOperationKHR) },
        { "vkDestroyDeferredOperationKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDeferredOperationKHR) },
        { "vkGetDeferredOperationMaxConcurrencyKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeferredOperationMaxConcurrencyKHR) },
        { "vkGetDeferredOperationResultKHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeferredOperationResultKHR) },
        { "vkDeferredOperationJoinKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkDeferredOperationJoinKHR) },
        { "vkGetPipelineExecutablePropertiesKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineExecutablePropertiesKHR) },
        { "vkGetPipelineExecutableStatisticsKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineExecutableStatisticsKHR) },
        { "vkGetPipelineExecutableInternalRepresentationsKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineExecutableInternalRepresentationsKHR) },
        { "vkMapMemory2KHR",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkMapMemory2KHR) },
        { "vkUnmapMemory2KHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkUnmapMemory2KHR) },
        { "vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR",                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR) },
        { "vkGetEncodedVideoSessionParametersKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetEncodedVideoSessionParametersKHR) },
        { "vkCmdEncodeVideoKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEncodeVideoKHR) },
        { "vkCmdSetEvent2KHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetEvent2KHR) },
        { "vkCmdResetEvent2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResetEvent2KHR) },
        { "vkCmdWaitEvents2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWaitEvents2KHR) },
        { "vkCmdPipelineBarrier2KHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPipelineBarrier2KHR) },
        { "vkCmdWriteTimestamp2KHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteTimestamp2KHR) },
        { "vkQueueSubmit2KHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueSubmit2KHR) },
        { "vkCmdCopyBuffer2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBuffer2KHR) },
        { "vkCmdCopyImage2KHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImage2KHR) },
        { "vkCmdCopyBufferToImage2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyBufferToImage2KHR) },
        { "vkCmdCopyImageToBuffer2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyImageToBuffer2KHR) },
        { "vkCmdBlitImage2KHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBlitImage2KHR) },
        { "vkCmdResolveImage2KHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdResolveImage2KHR) },
        { "vkCmdTraceRaysIndirect2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdTraceRaysIndirect2KHR) },
        { "vkGetDeviceBufferMemoryRequirementsKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceBufferMemoryRequirementsKHR) },
        { "vkGetDeviceImageMemoryRequirementsKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageMemoryRequirementsKHR) },
        { "vkGetDeviceImageSparseMemoryRequirementsKHR",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageSparseMemoryRequirementsKHR) },
        { "vkCmdBindIndexBuffer2KHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindIndexBuffer2KHR) },
        { "vkGetRenderingAreaGranularityKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRenderingAreaGranularityKHR) },
        { "vkGetDeviceImageSubresourceLayoutKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceImageSubresourceLayoutKHR) },
        { "vkGetImageSubresourceLayout2KHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSubresourceLayout2KHR) },
        { "vkWaitForPresent2KHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkWaitForPresent2KHR) },
        { "vkCreatePipelineBinariesKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreatePipelineBinariesKHR) },
        { "vkDestroyPipelineBinaryKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPipelineBinaryKHR) },
        { "vkGetPipelineKeyKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineKeyKHR) },
        { "vkGetPipelineBinaryDataKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineBinaryDataKHR) },
        { "vkReleaseCapturedPipelineDataKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseCapturedPipelineDataKHR) },
        { "vkReleaseSwapchainImagesKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseSwapchainImagesKHR) },
        { "vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR) },
        { "vkCmdSetLineStippleKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineStippleKHR) },
        { "vkGetPhysicalDeviceCalibrateableTimeDomainsKHR",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCalibrateableTimeDomainsKHR) },
        { "vkGetCalibratedTimestampsKHR",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetCalibratedTimestampsKHR) },
        { "vkCmdBindDescriptorSets2KHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorSets2KHR) },
        { "vkCmdPushConstants2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushConstants2KHR) },
        { "vkCmdPushDescriptorSet2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSet2KHR) },
        { "vkCmdPushDescriptorSetWithTemplate2KHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPushDescriptorSetWithTemplate2KHR) },
        { "vkCmdSetDescriptorBufferOffsets2EXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDescriptorBufferOffsets2EXT) },
        { "vkCmdBindDescriptorBufferEmbeddedSamplers2EXT",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT) },
        { "vkCmdCopyMemoryIndirectKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMemoryIndirectKHR) },
        { "vkCmdCopyMemoryToImageIndirectKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMemoryToImageIndirectKHR) },
        { "vkCmdEndRendering2KHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRendering2KHR) },
        { "vkFrameBoundaryANDROID",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkFrameBoundaryANDROID) },
        { "vkCreateDebugReportCallbackEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDebugReportCallbackEXT) },
        { "vkDestroyDebugReportCallbackEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDebugReportCallbackEXT) },
        { "vkDebugReportMessageEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkDebugReportMessageEXT) },
        { "vkDebugMarkerSetObjectTagEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkDebugMarkerSetObjectTagEXT) },
        { "vkDebugMarkerSetObjectNameEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkDebugMarkerSetObjectNameEXT) },
        { "vkCmdDebugMarkerBeginEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDebugMarkerBeginEXT) },
        { "vkCmdDebugMarkerEndEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDebugMarkerEndEXT) },
        { "vkCmdDebugMarkerInsertEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDebugMarkerInsertEXT) },
        { "vkCmdBindTransformFeedbackBuffersEXT",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindTransformFeedbackBuffersEXT) },
        { "vkCmdBeginTransformFeedbackEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginTransformFeedbackEXT) },
        { "vkCmdEndTransformFeedbackEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndTransformFeedbackEXT) },
        { "vkCmdBeginQueryIndexedEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginQueryIndexedEXT) },
        { "vkCmdEndQueryIndexedEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndQueryIndexedEXT) },
        { "vkCmdDrawIndirectByteCountEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndirectByteCountEXT) },
        { "vkGetImageViewHandleNVX",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageViewHandleNVX) },
        { "vkGetImageViewHandle64NVX",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageViewHandle64NVX) },
        { "vkGetImageViewAddressNVX",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageViewAddressNVX) },
        { "vkGetDeviceCombinedImageSamplerIndexNVX",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceCombinedImageSamplerIndexNVX) },
        { "vkCmdDrawIndirectCountAMD",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndirectCountAMD) },
        { "vkCmdDrawIndexedIndirectCountAMD",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawIndexedIndirectCountAMD) },
        { "vkGetShaderInfoAMD",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetShaderInfoAMD) },
        { "vkCreateStreamDescriptorSurfaceGGP",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateStreamDescriptorSurfaceGGP) },
        { "vkGetPhysicalDeviceExternalImageFormatPropertiesNV",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceExternalImageFormatPropertiesNV) },
        { "vkGetMemoryWin32HandleNV",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryWin32HandleNV) },
        { "vkCreateViSurfaceNN",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateViSurfaceNN) },
        { "vkCmdBeginConditionalRenderingEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginConditionalRenderingEXT) },
        { "vkCmdEndConditionalRenderingEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndConditionalRenderingEXT) },
        { "vkCmdSetViewportWScalingNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportWScalingNV) },
        { "vkReleaseDisplayEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseDisplayEXT) },
        { "vkAcquireXlibDisplayEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireXlibDisplayEXT) },
        { "vkGetRandROutputDisplayEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRandROutputDisplayEXT) },
        { "vkGetPhysicalDeviceSurfaceCapabilities2EXT",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfaceCapabilities2EXT) },
        { "vkDisplayPowerControlEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkDisplayPowerControlEXT) },
        { "vkRegisterDeviceEventEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkRegisterDeviceEventEXT) },
        { "vkRegisterDisplayEventEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkRegisterDisplayEventEXT) },
        { "vkGetSwapchainCounterEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSwapchainCounterEXT) },
        { "vkGetRefreshCycleDurationGOOGLE",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRefreshCycleDurationGOOGLE) },
        { "vkGetPastPresentationTimingGOOGLE",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPastPresentationTimingGOOGLE) },
        { "vkCmdSetDiscardRectangleEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDiscardRectangleEXT) },
        { "vkCmdSetDiscardRectangleEnableEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDiscardRectangleEnableEXT) },
        { "vkCmdSetDiscardRectangleModeEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDiscardRectangleModeEXT) },
        { "vkSetHdrMetadataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetHdrMetadataEXT) },
        { "vkCreateIOSSurfaceMVK",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateIOSSurfaceMVK) },
        { "vkCreateMacOSSurfaceMVK",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateMacOSSurfaceMVK) },
        { "vkSetDebugUtilsObjectNameEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetDebugUtilsObjectNameEXT) },
        { "vkSetDebugUtilsObjectTagEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetDebugUtilsObjectTagEXT) },
        { "vkQueueBeginDebugUtilsLabelEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueBeginDebugUtilsLabelEXT) },
        { "vkQueueEndDebugUtilsLabelEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueEndDebugUtilsLabelEXT) },
        { "vkQueueInsertDebugUtilsLabelEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueInsertDebugUtilsLabelEXT) },
        { "vkCmdBeginDebugUtilsLabelEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginDebugUtilsLabelEXT) },
        { "vkCmdEndDebugUtilsLabelEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndDebugUtilsLabelEXT) },
        { "vkCmdInsertDebugUtilsLabelEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdInsertDebugUtilsLabelEXT) },
        { "vkCreateDebugUtilsMessengerEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDebugUtilsMessengerEXT) },
        { "vkDestroyDebugUtilsMessengerEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDebugUtilsMessengerEXT) },
        { "vkSubmitDebugUtilsMessageEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkSubmitDebugUtilsMessageEXT) },
        { "vkGetAndroidHardwareBufferPropertiesANDROID",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAndroidHardwareBufferPropertiesANDROID) },
        { "vkGetMemoryAndroidHardwareBufferANDROID",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryAndroidHardwareBufferANDROID) },
        { "vkCmdSetSampleLocationsEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetSampleLocationsEXT) },
        { "vkGetPhysicalDeviceMultisamplePropertiesEXT",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceMultisamplePropertiesEXT) },
        { "vkGetImageDrmFormatModifierPropertiesEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageDrmFormatModifierPropertiesEXT) },
        { "vkCreateValidationCacheEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateValidationCacheEXT) },
        { "vkDestroyValidationCacheEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyValidationCacheEXT) },
        { "vkMergeValidationCachesEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkMergeValidationCachesEXT) },
        { "vkGetValidationCacheDataEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetValidationCacheDataEXT) },
        { "vkCmdBindShadingRateImageNV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindShadingRateImageNV) },
        { "vkCmdSetViewportShadingRatePaletteNV",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportShadingRatePaletteNV) },
        { "vkCmdSetCoarseSampleOrderNV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoarseSampleOrderNV) },
        { "vkCreateAccelerationStructureNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateAccelerationStructureNV) },
        { "vkDestroyAccelerationStructureNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyAccelerationStructureNV) },
        { "vkGetAccelerationStructureMemoryRequirementsNV",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAccelerationStructureMemoryRequirementsNV) },
        { "vkBindAccelerationStructureMemoryNV",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindAccelerationStructureMemoryNV) },
        { "vkCmdBuildAccelerationStructureNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBuildAccelerationStructureNV) },
        { "vkCmdCopyAccelerationStructureNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyAccelerationStructureNV) },
        { "vkCmdTraceRaysNV",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdTraceRaysNV) },
        { "vkCreateRayTracingPipelinesNV",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateRayTracingPipelinesNV) },
        { "vkGetRayTracingShaderGroupHandlesKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRayTracingShaderGroupHandlesKHR) },
        { "vkGetRayTracingShaderGroupHandlesNV",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRayTracingShaderGroupHandlesNV) },
        { "vkGetAccelerationStructureHandleNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAccelerationStructureHandleNV) },
        { "vkCmdWriteAccelerationStructuresPropertiesNV",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteAccelerationStructuresPropertiesNV) },
        { "vkCompileDeferredNV",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCompileDeferredNV) },
        { "vkGetMemoryHostPointerPropertiesEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryHostPointerPropertiesEXT) },
        { "vkCmdWriteBufferMarkerAMD",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteBufferMarkerAMD) },
        { "vkCmdWriteBufferMarker2AMD",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteBufferMarker2AMD) },
        { "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCalibrateableTimeDomainsEXT) },
        { "vkGetCalibratedTimestampsEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetCalibratedTimestampsEXT) },
        { "vkCmdDrawMeshTasksNV",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksNV) },
        { "vkCmdDrawMeshTasksIndirectNV",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksIndirectNV) },
        { "vkCmdDrawMeshTasksIndirectCountNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksIndirectCountNV) },
        { "vkCmdSetExclusiveScissorEnableNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetExclusiveScissorEnableNV) },
        { "vkCmdSetExclusiveScissorNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetExclusiveScissorNV) },
        { "vkCmdSetCheckpointNV",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCheckpointNV) },
        { "vkGetQueueCheckpointDataNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetQueueCheckpointDataNV) },
        { "vkGetQueueCheckpointData2NV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetQueueCheckpointData2NV) },
        { "vkSetSwapchainPresentTimingQueueSizeEXT",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetSwapchainPresentTimingQueueSizeEXT) },
        { "vkGetSwapchainTimingPropertiesEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSwapchainTimingPropertiesEXT) },
        { "vkGetSwapchainTimeDomainPropertiesEXT",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSwapchainTimeDomainPropertiesEXT) },
        { "vkGetPastPresentationTimingEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPastPresentationTimingEXT) },
        { "vkInitializePerformanceApiINTEL",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkInitializePerformanceApiINTEL) },
        { "vkUninitializePerformanceApiINTEL",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkUninitializePerformanceApiINTEL) },
        { "vkCmdSetPerformanceMarkerINTEL",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPerformanceMarkerINTEL) },
        { "vkCmdSetPerformanceStreamMarkerINTEL",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPerformanceStreamMarkerINTEL) },
        { "vkCmdSetPerformanceOverrideINTEL",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPerformanceOverrideINTEL) },
        { "vkAcquirePerformanceConfigurationINTEL",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquirePerformanceConfigurationINTEL) },
        { "vkReleasePerformanceConfigurationINTEL",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleasePerformanceConfigurationINTEL) },
        { "vkQueueSetPerformanceConfigurationINTEL",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueSetPerformanceConfigurationINTEL) },
        { "vkGetPerformanceParameterINTEL",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPerformanceParameterINTEL) },
        { "vkSetLocalDimmingAMD",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetLocalDimmingAMD) },
        { "vkCreateImagePipeSurfaceFUCHSIA",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateImagePipeSurfaceFUCHSIA) },
        { "vkCreateMetalSurfaceEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateMetalSurfaceEXT) },
        { "vkGetBufferDeviceAddressEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferDeviceAddressEXT) },
        { "vkGetPhysicalDeviceToolPropertiesEXT",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceToolPropertiesEXT) },
        { "vkGetPhysicalDeviceCooperativeMatrixPropertiesNV",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCooperativeMatrixPropertiesNV) },
        { "vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV",                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV) },
        { "vkGetPhysicalDeviceSurfacePresentModes2EXT",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceSurfacePresentModes2EXT) },
        { "vkAcquireFullScreenExclusiveModeEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireFullScreenExclusiveModeEXT) },
        { "vkReleaseFullScreenExclusiveModeEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseFullScreenExclusiveModeEXT) },
        { "vkGetDeviceGroupSurfacePresentModes2EXT",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceGroupSurfacePresentModes2EXT) },
        { "vkCreateHeadlessSurfaceEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateHeadlessSurfaceEXT) },
        { "vkCmdSetLineStippleEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineStippleEXT) },
        { "vkResetQueryPoolEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkResetQueryPoolEXT) },
        { "vkCmdSetCullModeEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCullModeEXT) },
        { "vkCmdSetFrontFaceEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetFrontFaceEXT) },
        { "vkCmdSetPrimitiveTopologyEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPrimitiveTopologyEXT) },
        { "vkCmdSetViewportWithCountEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportWithCountEXT) },
        { "vkCmdSetScissorWithCountEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetScissorWithCountEXT) },
        { "vkCmdBindVertexBuffers2EXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindVertexBuffers2EXT) },
        { "vkCmdSetDepthTestEnableEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthTestEnableEXT) },
        { "vkCmdSetDepthWriteEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthWriteEnableEXT) },
        { "vkCmdSetDepthCompareOpEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthCompareOpEXT) },
        { "vkCmdSetDepthBoundsTestEnableEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBoundsTestEnableEXT) },
        { "vkCmdSetStencilTestEnableEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilTestEnableEXT) },
        { "vkCmdSetStencilOpEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetStencilOpEXT) },
        { "vkCopyMemoryToImageEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMemoryToImageEXT) },
        { "vkCopyImageToMemoryEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyImageToMemoryEXT) },
        { "vkCopyImageToImageEXT",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyImageToImageEXT) },
        { "vkTransitionImageLayoutEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkTransitionImageLayoutEXT) },
        { "vkGetImageSubresourceLayout2EXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageSubresourceLayout2EXT) },
        { "vkReleaseSwapchainImagesEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkReleaseSwapchainImagesEXT) },
        { "vkGetGeneratedCommandsMemoryRequirementsNV",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetGeneratedCommandsMemoryRequirementsNV) },
        { "vkCmdPreprocessGeneratedCommandsNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPreprocessGeneratedCommandsNV) },
        { "vkCmdExecuteGeneratedCommandsNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdExecuteGeneratedCommandsNV) },
        { "vkCmdBindPipelineShaderGroupNV",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindPipelineShaderGroupNV) },
        { "vkCreateIndirectCommandsLayoutNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateIndirectCommandsLayoutNV) },
        { "vkDestroyIndirectCommandsLayoutNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyIndirectCommandsLayoutNV) },
        { "vkCmdSetDepthBias2EXT",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBias2EXT) },
        { "vkAcquireDrmDisplayEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireDrmDisplayEXT) },
        { "vkGetDrmDisplayEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDrmDisplayEXT) },
        { "vkCreatePrivateDataSlotEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreatePrivateDataSlotEXT) },
        { "vkDestroyPrivateDataSlotEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyPrivateDataSlotEXT) },
        { "vkSetPrivateDataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetPrivateDataEXT) },
        { "vkGetPrivateDataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPrivateDataEXT) },
        { "vkCmdDispatchTileQCOM",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatchTileQCOM) },
        { "vkCmdBeginPerTileExecutionQCOM",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginPerTileExecutionQCOM) },
        { "vkCmdEndPerTileExecutionQCOM",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndPerTileExecutionQCOM) },
        { "vkGetDescriptorSetLayoutSizeEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetLayoutSizeEXT) },
        { "vkGetDescriptorSetLayoutBindingOffsetEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetLayoutBindingOffsetEXT) },
        { "vkGetDescriptorEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorEXT) },
        { "vkCmdBindDescriptorBuffersEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorBuffersEXT) },
        { "vkCmdSetDescriptorBufferOffsetsEXT",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDescriptorBufferOffsetsEXT) },
        { "vkCmdBindDescriptorBufferEmbeddedSamplersEXT",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindDescriptorBufferEmbeddedSamplersEXT) },
        { "vkGetBufferOpaqueCaptureDescriptorDataEXT",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetBufferOpaqueCaptureDescriptorDataEXT) },
        { "vkGetImageOpaqueCaptureDescriptorDataEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageOpaqueCaptureDescriptorDataEXT) },
        { "vkGetImageViewOpaqueCaptureDescriptorDataEXT",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetImageViewOpaqueCaptureDescriptorDataEXT) },
        { "vkGetSamplerOpaqueCaptureDescriptorDataEXT",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSamplerOpaqueCaptureDescriptorDataEXT) },
        { "vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT",                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT) },
        { "vkCmdSetFragmentShadingRateEnumNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetFragmentShadingRateEnumNV) },
        { "vkGetDeviceFaultInfoEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceFaultInfoEXT) },
        { "vkAcquireWinrtDisplayNV",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkAcquireWinrtDisplayNV) },
        { "vkGetWinrtDisplayNV",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetWinrtDisplayNV) },
        { "vkCreateDirectFBSurfaceEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDirectFBSurfaceEXT) },
        { "vkGetPhysicalDeviceDirectFBPresentationSupportEXT",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceDirectFBPresentationSupportEXT) },
        { "vkCmdSetVertexInputEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetVertexInputEXT) },
        { "vkGetMemoryZirconHandleFUCHSIA",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryZirconHandleFUCHSIA) },
        { "vkGetMemoryZirconHandlePropertiesFUCHSIA",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryZirconHandlePropertiesFUCHSIA) },
        { "vkImportSemaphoreZirconHandleFUCHSIA",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkImportSemaphoreZirconHandleFUCHSIA) },
        { "vkGetSemaphoreZirconHandleFUCHSIA",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetSemaphoreZirconHandleFUCHSIA) },
        { "vkCmdBindInvocationMaskHUAWEI",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindInvocationMaskHUAWEI) },
        { "vkGetMemoryRemoteAddressNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryRemoteAddressNV) },
        { "vkCmdSetPatchControlPointsEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPatchControlPointsEXT) },
        { "vkCmdSetRasterizerDiscardEnableEXT",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRasterizerDiscardEnableEXT) },
        { "vkCmdSetDepthBiasEnableEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthBiasEnableEXT) },
        { "vkCmdSetLogicOpEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLogicOpEXT) },
        { "vkCmdSetPrimitiveRestartEnableEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPrimitiveRestartEnableEXT) },
        { "vkCreateScreenSurfaceQNX",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateScreenSurfaceQNX) },
        { "vkGetPhysicalDeviceScreenPresentationSupportQNX",                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceScreenPresentationSupportQNX) },
        { "vkCmdSetColorWriteEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetColorWriteEnableEXT) },
        { "vkCmdDrawMultiEXT",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMultiEXT) },
        { "vkCmdDrawMultiIndexedEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMultiIndexedEXT) },
        { "vkCreateMicromapEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateMicromapEXT) },
        { "vkDestroyMicromapEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyMicromapEXT) },
        { "vkCmdBuildMicromapsEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBuildMicromapsEXT) },
        { "vkBuildMicromapsEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkBuildMicromapsEXT) },
        { "vkCopyMicromapEXT",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMicromapEXT) },
        { "vkCopyMicromapToMemoryEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMicromapToMemoryEXT) },
        { "vkCopyMemoryToMicromapEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMemoryToMicromapEXT) },
        { "vkWriteMicromapsPropertiesEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkWriteMicromapsPropertiesEXT) },
        { "vkCmdCopyMicromapEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMicromapEXT) },
        { "vkCmdCopyMicromapToMemoryEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMicromapToMemoryEXT) },
        { "vkCmdCopyMemoryToMicromapEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMemoryToMicromapEXT) },
        { "vkCmdWriteMicromapsPropertiesEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteMicromapsPropertiesEXT) },
        { "vkGetDeviceMicromapCompatibilityEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceMicromapCompatibilityEXT) },
        { "vkGetMicromapBuildSizesEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMicromapBuildSizesEXT) },
        { "vkCmdDrawClusterHUAWEI",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawClusterHUAWEI) },
        { "vkCmdDrawClusterIndirectHUAWEI",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawClusterIndirectHUAWEI) },
        { "vkSetDeviceMemoryPriorityEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetDeviceMemoryPriorityEXT) },
        { "vkGetDescriptorSetLayoutHostMappingInfoVALVE",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetLayoutHostMappingInfoVALVE) },
        { "vkGetDescriptorSetHostMappingVALVE",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDescriptorSetHostMappingVALVE) },
        { "vkGetPipelineIndirectMemoryRequirementsNV",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineIndirectMemoryRequirementsNV) },
        { "vkCmdUpdatePipelineIndirectBufferNV",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdUpdatePipelineIndirectBufferNV) },
        { "vkGetPipelineIndirectDeviceAddressNV",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPipelineIndirectDeviceAddressNV) },
        { "vkCmdSetDepthClampEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthClampEnableEXT) },
        { "vkCmdSetPolygonModeEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetPolygonModeEXT) },
        { "vkCmdSetRasterizationSamplesEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRasterizationSamplesEXT) },
        { "vkCmdSetSampleMaskEXT",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetSampleMaskEXT) },
        { "vkCmdSetAlphaToCoverageEnableEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetAlphaToCoverageEnableEXT) },
        { "vkCmdSetAlphaToOneEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetAlphaToOneEnableEXT) },
        { "vkCmdSetLogicOpEnableEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLogicOpEnableEXT) },
        { "vkCmdSetColorBlendEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetColorBlendEnableEXT) },
        { "vkCmdSetColorBlendEquationEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetColorBlendEquationEXT) },
        { "vkCmdSetColorWriteMaskEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetColorWriteMaskEXT) },
        { "vkCmdSetTessellationDomainOriginEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetTessellationDomainOriginEXT) },
        { "vkCmdSetRasterizationStreamEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRasterizationStreamEXT) },
        { "vkCmdSetConservativeRasterizationModeEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetConservativeRasterizationModeEXT) },
        { "vkCmdSetExtraPrimitiveOverestimationSizeEXT",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetExtraPrimitiveOverestimationSizeEXT) },
        { "vkCmdSetDepthClipEnableEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthClipEnableEXT) },
        { "vkCmdSetSampleLocationsEnableEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetSampleLocationsEnableEXT) },
        { "vkCmdSetColorBlendAdvancedEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetColorBlendAdvancedEXT) },
        { "vkCmdSetProvokingVertexModeEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetProvokingVertexModeEXT) },
        { "vkCmdSetLineRasterizationModeEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineRasterizationModeEXT) },
        { "vkCmdSetLineStippleEnableEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetLineStippleEnableEXT) },
        { "vkCmdSetDepthClipNegativeOneToOneEXT",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthClipNegativeOneToOneEXT) },
        { "vkCmdSetViewportWScalingEnableNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportWScalingEnableNV) },
        { "vkCmdSetViewportSwizzleNV",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetViewportSwizzleNV) },
        { "vkCmdSetCoverageToColorEnableNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageToColorEnableNV) },
        { "vkCmdSetCoverageToColorLocationNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageToColorLocationNV) },
        { "vkCmdSetCoverageModulationModeNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageModulationModeNV) },
        { "vkCmdSetCoverageModulationTableEnableNV",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageModulationTableEnableNV) },
        { "vkCmdSetCoverageModulationTableNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageModulationTableNV) },
        { "vkCmdSetShadingRateImageEnableNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetShadingRateImageEnableNV) },
        { "vkCmdSetRepresentativeFragmentTestEnableNV",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRepresentativeFragmentTestEnableNV) },
        { "vkCmdSetCoverageReductionModeNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetCoverageReductionModeNV) },
        { "vkGetShaderModuleIdentifierEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetShaderModuleIdentifierEXT) },
        { "vkGetShaderModuleCreateInfoIdentifierEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetShaderModuleCreateInfoIdentifierEXT) },
        { "vkGetPhysicalDeviceOpticalFlowImageFormatsNV",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceOpticalFlowImageFormatsNV) },
        { "vkCreateOpticalFlowSessionNV",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateOpticalFlowSessionNV) },
        { "vkDestroyOpticalFlowSessionNV",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyOpticalFlowSessionNV) },
        { "vkBindOpticalFlowSessionImageNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindOpticalFlowSessionImageNV) },
        { "vkCmdOpticalFlowExecuteNV",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdOpticalFlowExecuteNV) },
        { "vkAntiLagUpdateAMD",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkAntiLagUpdateAMD) },
        { "vkCreateShadersEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateShadersEXT) },
        { "vkDestroyShaderEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyShaderEXT) },
        { "vkGetShaderBinaryDataEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetShaderBinaryDataEXT) },
        { "vkCmdBindShadersEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindShadersEXT) },
        { "vkCmdSetDepthClampRangeEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetDepthClampRangeEXT) },
        { "vkGetFramebufferTilePropertiesQCOM",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetFramebufferTilePropertiesQCOM) },
        { "vkGetDynamicRenderingTilePropertiesQCOM",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDynamicRenderingTilePropertiesQCOM) },
        { "vkGetPhysicalDeviceCooperativeVectorPropertiesNV",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCooperativeVectorPropertiesNV) },
        { "vkConvertCooperativeVectorMatrixNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkConvertCooperativeVectorMatrixNV) },
        { "vkCmdConvertCooperativeVectorMatrixNV",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdConvertCooperativeVectorMatrixNV) },
        { "vkSetLatencySleepModeNV",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetLatencySleepModeNV) },
        { "vkLatencySleepNV",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkLatencySleepNV) },
        { "vkSetLatencyMarkerNV",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkSetLatencyMarkerNV) },
        { "vkGetLatencyTimingsNV",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetLatencyTimingsNV) },
        { "vkQueueNotifyOutOfBandNV",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkQueueNotifyOutOfBandNV) },
        { "vkCreateDataGraphPipelinesARM",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDataGraphPipelinesARM) },
        { "vkCreateDataGraphPipelineSessionARM",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateDataGraphPipelineSessionARM) },
        { "vkGetDataGraphPipelineSessionBindPointRequirementsARM",                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDataGraphPipelineSessionBindPointRequirementsARM) },
        { "vkGetDataGraphPipelineSessionMemoryRequirementsARM",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDataGraphPipelineSessionMemoryRequirementsARM) },
        { "vkBindDataGraphPipelineSessionMemoryARM",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkBindDataGraphPipelineSessionMemoryARM) },
        { "vkDestroyDataGraphPipelineSessionARM",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyDataGraphPipelineSessionARM) },
        { "vkCmdDispatchDataGraphARM",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDispatchDataGraphARM) },
        { "vkGetDataGraphPipelineAvailablePropertiesARM",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDataGraphPipelineAvailablePropertiesARM) },
        { "vkGetDataGraphPipelinePropertiesARM",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDataGraphPipelinePropertiesARM) },
        { "vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM",                                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM) },
        { "vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM",                                reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM) },
        { "vkCmdSetAttachmentFeedbackLoopEnableEXT",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetAttachmentFeedbackLoopEnableEXT) },
        { "vkCmdBindTileMemoryQCOM",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBindTileMemoryQCOM) },
        { "vkCmdDecompressMemoryEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDecompressMemoryEXT) },
        { "vkCmdDecompressMemoryIndirectCountEXT",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDecompressMemoryIndirectCountEXT) },
        { "vkGetPartitionedAccelerationStructuresBuildSizesNV",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPartitionedAccelerationStructuresBuildSizesNV) },
        { "vkCmdBuildPartitionedAccelerationStructuresNV",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBuildPartitionedAccelerationStructuresNV) },
        { "vkGetGeneratedCommandsMemoryRequirementsEXT",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetGeneratedCommandsMemoryRequirementsEXT) },
        { "vkCmdPreprocessGeneratedCommandsEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdPreprocessGeneratedCommandsEXT) },
        { "vkCmdExecuteGeneratedCommandsEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdExecuteGeneratedCommandsEXT) },
        { "vkCreateIndirectCommandsLayoutEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateIndirectCommandsLayoutEXT) },
        { "vkDestroyIndirectCommandsLayoutEXT",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyIndirectCommandsLayoutEXT) },
        { "vkCreateIndirectExecutionSetEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateIndirectExecutionSetEXT) },
        { "vkDestroyIndirectExecutionSetEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyIndirectExecutionSetEXT) },
        { "vkUpdateIndirectExecutionSetPipelineEXT",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateIndirectExecutionSetPipelineEXT) },
        { "vkUpdateIndirectExecutionSetShaderEXT",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkUpdateIndirectExecutionSetShaderEXT) },
        { "vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV",                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV) },
        { "vkGetMemoryMetalHandleEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryMetalHandleEXT) },
        { "vkGetMemoryMetalHandlePropertiesEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetMemoryMetalHandlePropertiesEXT) },
        { "vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM",                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM) },
        { "vkCmdEndRendering2EXT",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdEndRendering2EXT) },
        { "vkCmdBeginCustomResolveEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBeginCustomResolveEXT) },
        { "vkCmdSetComputeOccupancyPriorityNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetComputeOccupancyPriorityNV) },
        { "vkCreateAccelerationStructureKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateAccelerationStructureKHR) },
        { "vkDestroyAccelerationStructureKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkDestroyAccelerationStructureKHR) },
        { "vkCmdBuildAccelerationStructuresKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBuildAccelerationStructuresKHR) },
        { "vkCmdBuildAccelerationStructuresIndirectKHR",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdBuildAccelerationStructuresIndirectKHR) },
        { "vkBuildAccelerationStructuresKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkBuildAccelerationStructuresKHR) },
        { "vkCopyAccelerationStructureKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyAccelerationStructureKHR) },
        { "vkCopyAccelerationStructureToMemoryKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyAccelerationStructureToMemoryKHR) },
        { "vkCopyMemoryToAccelerationStructureKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCopyMemoryToAccelerationStructureKHR) },
        { "vkWriteAccelerationStructuresPropertiesKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkWriteAccelerationStructuresPropertiesKHR) },
        { "vkCmdCopyAccelerationStructureKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyAccelerationStructureKHR) },
        { "vkCmdCopyAccelerationStructureToMemoryKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyAccelerationStructureToMemoryKHR) },
        { "vkCmdCopyMemoryToAccelerationStructureKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdCopyMemoryToAccelerationStructureKHR) },
        { "vkGetAccelerationStructureDeviceAddressKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAccelerationStructureDeviceAddressKHR) },
        { "vkCmdWriteAccelerationStructuresPropertiesKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdWriteAccelerationStructuresPropertiesKHR) },
        { "vkGetDeviceAccelerationStructureCompatibilityKHR",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetDeviceAccelerationStructureCompatibilityKHR) },
        { "vkGetAccelerationStructureBuildSizesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetAccelerationStructureBuildSizesKHR) },
        { "vkCmdTraceRaysKHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdTraceRaysKHR) },
        { "vkCreateRayTracingPipelinesKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::vkCreateRayTracingPipelinesKHR) },
        { "vkGetRayTracingCaptureReplayShaderGroupHandlesKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRayTracingCaptureReplayShaderGroupHandlesKHR) },
        { "vkCmdTraceRaysIndirectKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdTraceRaysIndirectKHR) },
        { "vkGetRayTracingShaderGroupStackSizeKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkGetRayTracingShaderGroupStackSizeKHR) },
        { "vkCmdSetRayTracingPipelineStackSizeKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdSetRayTracingPipelineStackSizeKHR) },
        { "vkCmdDrawMeshTasksEXT",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksEXT) },
        { "vkCmdDrawMeshTasksIndirectEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksIndirectEXT) },
        { "vkCmdDrawMeshTasksIndirectCountEXT",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::vkCmdDrawMeshTasksIndirectCountEXT) },
        { "vk_layerGetPhysicalDeviceProcAddr",                                                                   reinterpret_cast<PFN_vkVoidFunction>(vulkan_layer::GetPhysicalDeviceProcAddr) },
    };
}

GFXRECON_END_NAMESPACE(vulkan_layer)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif // GFXRECON_GENERATED_VULKAN_LAYER_FUNC_TABLE_H
