#!/usr/bin/perl -w
# Slightly modified version of <https://gitlab.gnome.org/GNOME/gtk/-/blob/main/gdk/gen-keyname-table.pl>

if (@ARGV != 1) {
    die "Usage: gen-keyname-table.pl keynames.txt > keyname-table.h\n";
}

open IN, $ARGV[0] || die "Cannot open $ARGV[0]: $!\n";

@keys = ();
@translate = ();
while (defined($_ = <IN>)) {
    next if /^!/;
    if (!/^\s*(0x[0-9a-f]+)\s+([\w_]*\S)\s+(1)?\s*$/) {
	die "Cannot parse line $_";
    }

    push @keys, [$1, $2];

    if (defined ($3)) {
	push @translate, $2;
    }
}
close IN;

$offset = 0;

$date = gmtime;

print <<EOT;
/* keyname-table.h: Generated by gen-keyname-table.pl from keynames.txt
 *
 *  Date: $date
 *
 * Do not edit.   
 */
static const char keynames[] =
EOT

for $key (@keys) {
    $name = $key->[1];

    if ($offset != 0) {
	print qq(\n);
    }
    print qq(  "$name\\0");

    $key->[3] = $offset;
    $offset += length($name) + 1;
}

print ";\n\n";

print <<EOT;
typedef struct {
    unsigned int keyval;
    unsigned int offset;
} clutter_key;

static const clutter_key clutter_keys_by_keyval[] = {
EOT

$i = 0;
for $key (@keys) {
    $keyval = $key->[0];
    $name = $key->[1];
    $offset = $key->[3];

    if ($i != 0) {
	print ",\n";
    }
    print "  { $keyval, $offset }";
    $i++;
}

print "\n};\n\n";

@keys = sort { $a->[1] cmp $b->[1] } @keys;


print <<EOT;
static const clutter_key clutter_keys_by_name[] = {
EOT

$i = 0;
for $key (@keys) {
    $keyval = $key->[0];
    $name = $key->[1];
    $offset = $key->[3];

    if ($i != 0) {
	print ",\n";
    }
    print "  { $keyval, $offset }";
    $i++;
}

print <<EOT;
};
EOT
