---
title: Overview
---

# Overview

## Description

Written by Google, the Google OAuth Client Library for Java is a
powerful and easy-to-use Java library for the OAuth 1.0a and OAuth 2.0
authorization standards.

The Google OAuth Client Library for Java is designed to work with any
OAuth service on the web, not just with Google APIs. The library is
built on the [Google HTTP Client Library for Java][google-http-client],
and it supports Java 7 (or higher) standard (SE) and enterprise (EE),
Android 4.0 (or higher), and Google App Engine.

For access to Google APIs, see the
[Google API Client Library for Java][google-api-client].

This is an open-source library, and you can access the
[source on GitHub][google-oauth-client]. [Contributions][contributions] are
welcome.

## Beta Features

Features marked with the `@Beta` annotation at the class or method level
are subject to change. They might be modified in any way, or even removed,
in any major release. You should not use beta features if your code is a
library itself (that is, if your code is used on the `CLASSPATH` of users
outside your own control).

## Deprecated Features

Deprecated non-beta features will be removed eighteen months after the
release in which they are first deprecated. You must fix your usages before
this time. If you don't, any type of breakage might result, and you are not
guaranteed a compilation error.

[google-http-client]: https://github.com/googleapis/google-http-java-client
[google-api-client]: https://github.com/googleapis/google-api-java-client
[google-oauth-client]: https://github.com/googleapis/google-oauth-java-client
[contributions]: https://github.com/googleapis/google-oauth-java-client/blob/master/CONTRIBUTING.md