#if   !defined(__EQUIPMENTCOMPOSITE_HPP)
#define  __EQUIPMENTCOMPOSITE_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COMPOSITEEXCEPTION_HPP)
#include <CompositeException.hpp>
#endif

#if   !defined(__EQUIPMENT_HPP)
#include <Equipment.hpp>
#endif


/// Domain list

DECLARE_CLASS( EquipmentComposite );

/**
EquipmentComposite implements the TransparentComponent children management
routines as well as the domain behavior of Equipment. In our implementation
we use the EquipmentComposite as the concrete composite. Other implementations
may wish to extend the Equipment composite to real world composit types of
the problem domain.
*/

class EquipmentComposite : public Equipment
{
public:

   //
   // Constructors and Destructors
   //
                  /// Always requires a name in derivations
               
                  EquipmentComposite( NameCref );

                  /// Copy constructor - DEEP copy

                  EquipmentComposite( EquipmentCompositeCref );

                  /// Virtual destructor

   virtual        ~EquipmentComposite( void );

   //
   // Operators
   //
            /// Equal if theName == theName

            bool        operator==( EquipmentCompositeCref ) const;

   //
   // Accessors
   //
            /// Return the power requirement

   virtual  Watt        getPower( void ) ;

   //
   // Mutators overloaded from TransparentComponent
   //

   virtual  void        addComponent( EquipmentPtr ) throw(CORELINUX(InvalidCompositeException));

   virtual  void        removeComponent( EquipmentPtr ) throw(CORELINUX(InvalidCompositeException));

   //
   // Factory overloaded from TransparentComponent
   //

            /// Create a iterator and manage it's instance

   virtual  CORELINUX(Iterator)<EquipmentPtr>* createIterator( void ) throw(CORELINUX(InvalidCompositeException));

            /// Destroy the iterator if it is ours

   virtual  void     destroyIterator( CORELINUX(Iterator)<EquipmentPtr>* ) throw(CORELINUX(InvalidCompositeException));

protected:

   //
   // Constructors
   //
                        /// Default constructor not allowed

                        EquipmentComposite( void ) 
                           throw(CORELINUX(CompositeException));


   //
   // Operators
   //
            /// Assignment operator can't overwrite name

            EquipmentCompositeRef   operator=( EquipmentCompositeCref )
                                       throw(CORELINUX(CompositeException));


private:

};

#endif // if !defined(__EQUIPMENTCOMPOSITE_HPP);

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.3 $
   $Date: 2000/08/31 22:49:00 $
   $Locker:  $
*/


