/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.j2semodule.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.ComboBoxModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.java.j2semodule.J2SEModularProjectUtil;
import org.netbeans.modules.java.j2semodule.ui.customizer.J2SEModularProjectProperties;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.WeakListeners;

/**
 *
 * @author Dusan Balek
 */
public class PanelOptionsVisual extends SettingsPanel {

    private PanelConfigureProject panel;    
    
    /**
     * Creates new form PanelOptionsVisual
     */
    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        initComponents();
        platformComboBox.setModel(createPlatformComboBoxModel());
        platformComboBox.setRenderer(PlatformUiSupport.createPlatformListCellRenderer());
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange(new JavaPlatformChangeListener(), JavaPlatformManager.getDefault()));
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("javaPlatform", getSelectedPlatform());
    }

    @Override
    void read(WizardDescriptor d) {
    }

    @Override
    boolean valid(WizardDescriptor d) {
        return J2SEModularProjectProperties.MODULAR_PLATFORM_FILTER.accept(getSelectedPlatform());
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
        // nothing to validate
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        platformLabel = new javax.swing.JLabel();
        platformComboBox = new javax.swing.JComboBox<>();
        managePlatformsButton = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(platformLabel, org.openide.util.NbBundle.getMessage(PanelOptionsVisual.class, "PanelOptionsVisual.platformLabel.text")); // NOI18N

        platformComboBox.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        platformComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                platformComboBoxItemStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(managePlatformsButton, org.openide.util.NbBundle.getMessage(PanelOptionsVisual.class, "PanelOptionsVisual.managePlatformsButton.text")); // NOI18N
        managePlatformsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                managePlatformsButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(platformLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(platformComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 237, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(managePlatformsButton))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(platformLabel)
                    .addComponent(platformComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(managePlatformsButton))
                .addGap(0, 275, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void managePlatformsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_managePlatformsButtonActionPerformed
        PlatformsCustomizer.showCustomizer(getSelectedPlatform());
    }//GEN-LAST:event_managePlatformsButtonActionPerformed

    private void platformComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_platformComboBoxItemStateChanged
        this.panel.fireChangeEvent();
    }//GEN-LAST:event_platformComboBoxItemStateChanged

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = (selectedItem == null ? null : PlatformUiSupport.getPlatform(selectedItem));
        return platform;
    }

    private ComboBoxModel createPlatformComboBoxModel() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification(CommonProjectUtils.J2SE_PLATFORM_TYPE, J2SEModularProjectUtil.MIN_SOURCE_LEVEL));
        return PlatformUiSupport.createPlatformComboBoxModel(platforms.length > 0 ? platforms[0].getProperties().get("platform.ant.name") : null, //NOI18N
                Collections.singleton(J2SEModularProjectProperties.MODULAR_PLATFORM_FILTER));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton managePlatformsButton;
    private javax.swing.JComboBox<String> platformComboBox;
    private javax.swing.JLabel platformLabel;
    // End of variables declaration//GEN-END:variables

    private class JavaPlatformChangeListener implements PropertyChangeListener {

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}
