# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .entity_health_state_chunk import EntityHealthStateChunk


class ReplicaHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a stateful service replica or a
    stateless service instance.
    The replica health state contains the replica ID and its aggregated health
    state.
    .

    :param health_state: Possible values include: 'Invalid', 'Ok', 'Warning',
     'Error', 'Unknown'
    :type health_state: str
    :param replica_or_instance_id: The ID of the stateful service replica or
     the stateless service instance.
    :type replica_or_instance_id: str
    """ 

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'replica_or_instance_id': {'key': 'ReplicaOrInstanceId', 'type': 'str'},
    }

    def __init__(self, health_state=None, replica_or_instance_id=None):
        super(ReplicaHealthStateChunk, self).__init__(health_state=health_state)
        self.replica_or_instance_id = replica_or_instance_id
