# Generated by default/object.tt
package Paws::MediaStore::MetricPolicyRule;
  use Moose;
  has ObjectGroup => (is => 'ro', isa => 'Str', required => 1);
  has ObjectGroupName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaStore::MetricPolicyRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaStore::MetricPolicyRule object:

  $service_obj->Method(Att1 => { ObjectGroup => $value, ..., ObjectGroupName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaStore::MetricPolicyRule object:

  $result = $service_obj->Method(...);
  $result->Att1->ObjectGroup

=head1 DESCRIPTION

A setting that enables metrics at the object level. Each rule contains
an object group and an object group name. If the policy includes the
MetricPolicyRules parameter, you must include at least one rule. Each
metric policy can include up to five rules by default. You can also
request a quota increase
(https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas)
to allow up to 300 rules per policy.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ObjectGroup => Str

A path or file name that defines which objects to include in the group.
Wildcards (*) are acceptable.


=head2 B<REQUIRED> ObjectGroupName => Str

A name that allows you to refer to the object group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaStore>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

