/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

class FormatElement {
    static final String DESCRIPTORS = "doxfeEgG";
    private static final String INT_DESCRIPTORS = "dox";
    private static final int INT_DESCRIPTOR = 0;
    private static final int FLOAT_DESCRIPTOR = 1;
    private final char _descriptor;
    private final int _descriptorType;
    private final double _tenToPrecision;
    private boolean _decimalPoint;
    private boolean _flushLeft;
    private boolean _leadingZeros;
    private boolean _alwaysSign;
    private int _width;
    private int _precision;

    private static final double power(double d, int n) {
        return n < 0 ? 1.0 / FormatElement.power2(d, -n) : FormatElement.power2(d, n);
    }

    private static final double power2(double d, int n) {
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return d;
            }
        }
        double d2 = FormatElement.power2(d, n / 2);
        return d2 * d2 * FormatElement.power2(d, n % 2);
    }

    FormatElement(String string) {
        int n = string.length() - 1;
        this._descriptor = string.charAt(n);
        if (DESCRIPTORS.indexOf(this._descriptor) < 0) {
            throw new IllegalArgumentException("Format element '" + string + "' does not ends with one of the following characters: " + DESCRIPTORS);
        }
        int n2 = this._descriptorType = INT_DESCRIPTORS.indexOf(this._descriptor) >= 0 ? 0 : 1;
        if (string.length() > 1) {
            int n3;
            switch (string.charAt(0)) {
                case '-': {
                    this._flushLeft = true;
                    string = string.substring(1);
                    break;
                }
                case '0': {
                    this._leadingZeros = true;
                    string = string.substring(1);
                    break;
                }
                case '+': {
                    this._alwaysSign = true;
                    string = string.substring(1);
                }
            }
            n = string.length() - 1;
            int n4 = string.indexOf(46);
            this._decimalPoint = n4 >= 0;
            int n5 = n3 = this._decimalPoint ? n4 : n;
            if (n3 > 0) {
                this._width = Integer.parseInt(string.substring(0, n3));
            }
            if (this._decimalPoint && ++n4 < n) {
                this._precision = Integer.parseInt(string.substring(n4, n));
            }
        }
        this._tenToPrecision = FormatElement.power(10.0, this._precision);
    }

    public void form(StringBuffer stringBuffer, long l) {
        if (this._descriptorType == 1) {
            this.form(stringBuffer, (double)l);
        } else {
            stringBuffer.append(this.form(l < 0L, Long.toString(Math.abs(l), this._descriptor == 'o' ? 8 : (this._descriptor == 'x' ? 16 : 10)), ""));
        }
    }

    public void form(StringBuffer stringBuffer, double d) {
        if (this._descriptorType == 0) {
            this.form(stringBuffer, (long)Math.floor(d + 0.5));
        } else if (this._descriptor == 'f') {
            stringBuffer.append(this.formF(d));
        } else if (this._descriptor == 'e' || this._descriptor == 'E') {
            stringBuffer.append(this.formE(d));
        } else if (this._descriptor == 'g' || this._descriptor == 'G') {
            String string = this.formF(d);
            String string2 = this.formE(d);
            stringBuffer.append(string.length() > string2.length() ? string2 : string);
        }
    }

    private String form(boolean bl, String string, String string2) {
        int n = string.length() + string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (this._alwaysSign || bl) {
            stringBuffer.append(bl ? (char)'-' : '+');
            ++n2;
        }
        if (this._leadingZeros) {
            for (int i = n2 + n; i < this._width; ++i) {
                stringBuffer.append('0');
                ++n2;
            }
        }
        stringBuffer.append(string).append(string2);
        n2 += n;
        if (this._flushLeft) {
            while (n2 < this._width) {
                stringBuffer.append(' ');
                ++n2;
            }
        } else {
            while (n2 < this._width) {
                stringBuffer.insert(0, ' ');
                ++n2;
            }
        }
        return new String(stringBuffer);
    }

    private String formE(double d) {
        int n = 0;
        String string = "00000000000000000000000".substring(0, this._precision + 1);
        if (d != 0.0) {
            n = (int)Math.floor(Math.log(Math.abs(d)) / Math.log(10.0));
            double d2 = Math.floor(Math.abs(d * FormatElement.power(10.0, this._precision - n)) + 0.5);
            if (d2 >= 10.0 * this._tenToPrecision) {
                d2 = Math.floor(Math.abs(d * FormatElement.power(10.0, this._precision - ++n)) + 0.5);
            }
            string = Long.toString((long)d2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._decimalPoint) {
            stringBuffer.append('.').append(string.substring(1));
        }
        stringBuffer.append(Character.isLowerCase(this._descriptor) ? (char)'e' : 'E').append(n < 0 ? (char)'-' : '+');
        n = Math.abs(n);
        int n2 = stringBuffer.length();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.insert(n2, Character.forDigit(n % 10, 10));
            n /= 10;
        }
        return this.form(d < 0.0, string.substring(0, 1), new String(stringBuffer));
    }

    private String formF(double d) {
        String string;
        double d2 = d < 0.0 ? -this._tenToPrecision : this._tenToPrecision;
        String string2 = string = Long.toString((long)Math.floor(d * d2 + 0.5));
        StringBuffer stringBuffer = new StringBuffer();
        if (this._decimalPoint) {
            int n;
            stringBuffer.append('.').append(string.substring(Math.max(0, n)));
            if (n > 0) {
                string2 = string.substring(0, n);
            } else {
                string2 = "0";
                for (n = string.length() - this._precision; n < 0; ++n) {
                    stringBuffer.insert(1, '0');
                }
            }
        }
        return this.form(d < 0.0, string2, new String(stringBuffer));
    }
}

