#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/Pi/;
use Math::BigFloat try => "GMP,Pari";
my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};
my $usexs = Math::Prime::Util::prime_get_config->{'xs'};

my $Pi = '3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588174881520920962829254091715364367892590360011330530548820466521384146951941511609433057270365759591953092186117381932611793105118548074462379962749567351885752724891227938183011949129833673362440656643086021394946395224737190702179860943702770539217176293176752384674818467669405132000568127145263560827785771342757789609173637178721468440901224953430146549585371050792279689258923542019956112129021960864034418159813629774771309960518707211349999998372978049951059731732816096318595024459455346908302642522308253344685035261931188171010003137838752886587533208381420617177669147303598253490428755468731159562863882353787593751957781857780532171226806613001927876611195909216420199';

my $roundt = Math::Prime::Util::prime_get_config->{gmp};
my $ninitial = 50;
if ($extra) {
  $roundt = 0;
  $ninitial = 1000;
}

plan tests => 3 + ($roundt ? 11 : 0) + 1;

is(Pi(0), 0+$Pi, "Pi(0) gives floating point pi");
is(Pi(1), 3, "Pi(1) = 3");
is_deeply( [map { stringPi($_) } 2 .. $ninitial],
           [map { roundpi($_) } 2 ..  $ninitial],
           "Pi(2 .. $ninitial)" );

if ($roundt) {
  for my $len (760 .. 770) {
    is( stringPi($len), roundpi($len), "Pi($len)" );
  }
}

# Force test of C code
SKIP: {
  skip "Not using XS, skipping XS _pidigits", 1 unless $usexs;
  is(Math::Prime::Util::_pidigits(82), roundpi(82), "XS _pidigits");
}

sub roundpi {
  my $n = shift;
  my $pi = Math::BigFloat->new($Pi, $n);
  $pi =~ s/0*$//;
  $pi;
}
sub stringPi {
  my $n = shift;
  my $pi = Pi($n);
  $pi =~ s/0*$//;
  $pi;
}
