# Mise  jour 20070108 V0.1
# Mise  jour 20070515 V0.2
# Mise  jour 20080528 V0.5
# MISE  jour 20090420 V1.1
# Mise  jour 20090604 v1.2

0. Localisation des fichiers
----------------------------
0.1 Outils
~~~~~~~~~~
Le rpertoire *outils* contient les scripts ncessaires  la mise en place de la
rplication entre deux serveurs.

0.2 etc
~~~~~~~
Le rpertoire *etc* contient les fichier d'inclusion *slony_include.h*,
*bases.h*, *relations.h* et *slon.cfg*.
Il comprend galement le fichier *fonctions.sh* qui dfinit quelques fonctions
utiles utilises par les scripts outils.
C'est dans ce rpertoire que seront placs les fichiers de prambule qui
contiennent les informations utiles aux scripts *slonik*.

1. Fichiers d'inclusion
-----------------------
1.1. slony_include.h
~~~~~~~~~~~~~~~~~~~~
Le fichier *slony_include.h*, stock dans le rpertoire ../etc/, est  modifier
en fonction des installations des serveurs de bases de donnes.
Il contient les chemins d'accs aux diffrents rpertoires.

Les variables dfinies sont les suivantes :
SLON_BIN=/opt/appli/slony1/bin
SLON_TOOLS=/opt/appli/slony1/tools
SLON=/opt/appli/slony1
SLON_CTL=/opt/appli/slony1
SLON_ETC=$SLON_CTL/etc
SLON_OUTILS=$SLON_CTL/outils
SLON_LOG=$SLON_CTL/logs
SLON_TEMP=/tmp
SLONY_USER=slony
SLONY_PWD=whatever_pwd_is
PG=/usr/lib/postgresql/8.3

1.2. bases.h
~~~~~~~~~~~~
Le fichier bases.h permet de dfinir les instances de rplication, et 
l'intrieur de ces instances, chaque base participant  la rplication.

Chaque ligne  la forme suivante :

INSTANCE	NODE	BASE	HOST	PORT

qui correspond au nom d'une instance, un numro de noeud, un nom de base, un
host et un port pour le serveur PostgreSQL.

Ex :
#INSTANCE	NODE	BASE	HOST		PORT
#test PG 8.3.1 et Slony CVS
test2	    1		test1	localhost   5433
test2	    2		test2	localhost   5433
test2	    3		test3	localhost   5433
test2	    4		test4	localhost   5433
test2	    5		test5	localhost   5433

1.3. relations.h
~~~~~~~~~~~~~~~~
Le fichier relations.h contient la liste des relations entre un matre et un
esclave. Chaque ligne est de la forme :

INSTANCE	SET	NODE	NODE

Instance est un identifiant de rplication, comme pour le fichier prcdant. SET
est le numro d'un set de rplication, MASTER et SLAVE les numros des noeuds.
Les trois derniers numros correspondent  ceux dfinis dans le fichier bases.h.

Ex:
#INSTANCE	SET	MASTER	SLAVE
# La rplication test2
test2		1	2		1
test2		1	2		3
test2		1	2		5
test2		1	3		4
test2		2	4		3
test2		2	3		2
test2		2	2		1


1.4. Les fichiers de prambule
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Les fichiers de prambule contiennent des lignes d'information de deux types :
CLUSTER NAME : le nom du cluster
NODE X ADMIN CONNINFO = 'connection information'


Ex:
CLUSTER NAME = test2 ;
    NODE 1 ADMIN CONNINFO = 'dbname=test1 host=localhost port=5433 user=slony
password=whatever_is_pwd';
    NODE 2 ADMIN CONNINFO = 'dbname=test2 host=localhost port=5433 user=slony
password=whatever_is_pwd';
    NODE 3 ADMIN CONNINFO = 'dbname=test3 host=localhost port=5433 user=slony
password=whatever_is_pwd';
    NODE 4 ADMIN CONNINFO = 'dbname=test4 host=localhost port=5433 user=slony
password=whatever_is_pwd';
    NODE 5 ADMIN CONNINFO = 'dbname=test5 host=localhost port=5433 user=slony
password=whatever_is_pwd';

1.5 slon.cfg
~~~~~~~~~~~~
Ce fichier permet de dfinir les paramtres des dmons *slon*.

Ex:
syslog 2
log_level 0
sync_interval 10000
vac_frequency 0
syslog_facility local1
syslog_ident slon

2. Les scripts outils
---------------------
2.1 01_create_init.sh
~~~~~~~~~~~~~~~~~~~~~
Le script *01_create_init.sh* cre les scripts .slon ncessaires au dmarrage de
la rplication. Il appelle le script *create_slon.sh*.
Le script rsultant, nomm ''INSTANCE''.slon est plac dans le rpertoire /tmp.

Il accepte un paramtre, le nom d'une instance. Dans ce cas, seuls les fichiers
correspondant  cette instance sont cres.

Ex:
./01_create_init.sh -c test2

2.2 02_exec_init.sh
~~~~~~~~~~~~~~~~~~~
Le script *02_exec_init.sh* permet d'initialiser les rplications  partir des
scripts engendrs par *01_create_init.sh*.
Le script prend en paramtre le nom d'une instance.

Ex:
./02_exec_init.sh -c test2

2.3 11_create_addobj.sh
~~~~~~~~~~~~~~~~~~~~~~~
Le script *11_create_addobj.sh* permet de crer le script d'ajout d'objets  une
rplication active. Il prend en arguments le nom d'une instance, le numro du
set et un script numrant les objets  rpliquer.

Le script rsultant est stock dans le rpertoire /tmp.

2.10.1. script d'ajout
Le script d'ajout est de la forme :
TAB="..."
SEQ="..."

Ex:
./11_create_addobj.sh -c test2 -f ajout.txt

ajout.txt :
TAB="public.a_table public.another_table"
SEQ="public.a_sequence"

2.4 12_exec_addobj.sh
~~~~~~~~~~~~~~~~~~~~~
Ce script permet d'excuter le script engendr par *11_create_addobj.sh*.

Il prend en paramtre le nom d'une instance et le set auquel les objets sont
ajouts.

2.5 21_create_addnode.sh
~~~~~~~~~~~~~~~~~~~~~~~~
Le script *21_create_addnode.sh* permet d'ajouter un noeud  une rplication
active. Il appelle le script *slony_addnode.sh* qui cre le script slon d'ajout
de noeud  une rplication.

Il prend en argument le nom d'une instance de rplication et le numro du noeud
 ajouter.

Le script rsultant est stock dans le rpertoire /tmp.

Ex:
./21_create_addnode.sh -c test2 -n 5

2.6 22_exec_addnode.sh
~~~~~~~~~~~~~~~~~~~~~~
Ce script permet d'excuter le script egendr par *21_create_addnode*.

Il prend en arguments le nom d'une instance et le numro du noeud  ajouter.

Ex:
./22_exec_addnode.sh -c test2 -n 5

2.7 31_create_set.sh
~~~~~~~~~~~~~~~~~~~~
Le script *31_create_set* permet de crer le script d'ajout d'un set  une
rplication. Il fait appel au script *create_slon.sh* en lui passant un numro
de set comme argument.

Ce script prend en arguments le nom d'une instance et le numro d'un set.

Le script rsultant est stock dans le rpertoire /tmp.

Ex :
./31_create_set.sh -c test2 -s 2

2.8 32_exec_set.sh
~~~~~~~~~~~~~~~~~~
Le script *32_exec_set.sh* permet d'initialiser la rplication d'un set  partir
du script engendr par *31_create_set.sh*.
Le script prend en paramtre le nom d'une instance et le numro du set.

Ex:
./32_exec_set.sh -c test2 -s 2

2.9 42_exec_exec.sh
~~~~~~~~~~~~~~~~~~~
Ce script lance *slony_execute.sh*.

Il prend en arguments le nom d'une instance, le numro d'un set et le fichier 
excuter.

Ex :
./42_exec_exec.sh -c test2 -s 2 -f myscript.sql

2.10 51_create_upgrade.sh
~~~~~~~~~~~~~~~~~~~~~~~~~
Ce script cre les scripts de mise  jour des procdures
stockes utilises par Slony1 sur chacun des noeuds d'un cluster.
Il appelle *upgrade_slon.sh*.

La mise  jour s'effectue pour toutes les instances.
Les scripts produits sont stocks dans le rpertoire /tmp.

Ex :
./51_create_upgrade.sh

2.11 52_exec_upgrade.sh
~~~~~~~~~~~~~~~~~~~~~~~
Excute les scripts crs par *51_create_upgrade.sh*.

Ex :
./52_exec_upgrade

2.12 62_exec_subscribe.sh
~~~~~~~~~~~~~~~~~~~~~~~~~
Ce script permet de recrer les souscriptions d'une rplication.
Il appelle *slony_subscribe.sh*.

Il prend en argument le nom d'une instance de rplication.

Ex :
./slony_subscribe.sh -c test2

2.13 71_create_path.sh
~~~~~~~~~~~~~~~~~~~~~~
Utilitaire permettant de crer un fichier contenant toutes les combinaisons
possibles de chemins entre deux noeuds d'une rplication.
Il prend en argument le nom d'une instance.

Le script produit est stock dans le rpertoire /tmp.

Ex :
./71_create_path -c test2

2.14 72_exec_path.sh
~~~~~~~~~~~~~~~~~~~~
Excute le rsultat du script prcdant.
Il est en gnral intressant d'diter le script avant de l'xcuter.

Ex :
./72_exec_path -c test2

2.15 82_exec_switch.sh
~~~~~~~~~~~~~~~~~~~~~~
Excute une bascule contrle entre deux noeuds.
Ce script appelle *slony_switch.sh*.

Il prend en arguments le nom d'une instance et les noeuds matre et de secours.

Ex :
./82_exec_switch -c test2 -f 1 -b 2

2.16 92_exec_fail.sh
~~~~~~~~~~~~~~~~~~~~
Effectue une bascule sur incident entre deux noeuds d'une rplication.
Il prend en arguments le noeud  supprimer et le noeud de secours.
Ce script appelle *slony_fail.sh*.

Ex :
./92_exec_fail -c test2 -f 1 -b 2

2.19 aff_tree.sh
~~~~~~~~~~~~~~~~
Script qui permet d'afficher l'arbre (de manire simplifie) de relation entre les noeuds d'une rplication.

Il appelle *tree.sh*.

Ex :
./aff_tree.sh -c test2 -s 1

2.20 create_preamble.sh
~~~~~~~~~~~~~~~~~~~~~~~
Le script *create_preamble.sh* permet de crer les informations ncessaires 
tous les scripts *slonik*.
Ces fichiers dont le nom est compos du nom d'une instance de rplication et
d'une extension preamble, sous la forme INSTANCE.preamble, sont stocks dans le
rpertoire $SLONY_ETC.
Ce script est appel par le script *01_create_replicat.sh*.

Ex :
./create_preamble.sh -c test2

2.21 create_slon.sh
~~~~~~~~~~~~~~~~~~~
2.21.1 Principe
Le script *create_slon.sh* cre les fichiers INSTANCE.slon, scripts shell qui
permettent de dmarrer la rplication. Ces fichiers sont stocks dans le
rpertoire /tmp.

Ce script ne doit pas tre appel directement, mais par *01_create_init.sh* ou
par *31_create_set.sh*.

ATTENTION : Les fichiers INSTANCE.slon sont utilises uniquement pour
l'initialisation des rplications. Ces fichiers ne sont pas maintenus par la
suite. Ils ne sont en effet plus ncessaires, puisque toutes les informations
ncessaires  la rplication sont stockes dans les tables des schmas slony
(tables et squences  rpliquer par exemple).
ATTENTION : Lorsque plusieurs sets sont dfinis, il est impratif de reprendre
les scripts INSTANCE.slon pour affiner la rpartition des tables dans les sets.

2.21.2 Fonctionnement interne
La premire tape consiste  installer le langage procdural plpgsql sur
l'ensemble des noeuds participant  la rplication.

La deuxime tape arrte toutes les rplications en cours (pour la base
considre) et supprime les schmas slony.

Vient ensuite l'excution du script *slonik* permettant d'initialiser la
rplication sur le matre, rcupration des informations sur les tables et les
squences  rpliquer.

ATTENTION : dans le script, les tables sont rcupres  partir d'un motif
particulier, tout comme les squences.
TODO : Faire en sorte que ce motif soit paramtrable.
Toutes les tables et squences doivent suivre ce formalisme au risque de ne pas
tre rpliques.

init cluster : commande d'initialisation sur le matre
create set : cration de l'ensemble  rpliquer
set add table : ajout d'une table  un ensemble
set add sequence : ajout d'une squence  l'ensemble
store node : enregistrement et initialisation d'un esclave
store path : enregistrement d'un chemin matre-esclave
store listen : les noeuds s'coutent

La rplication peut alors tre dmarre :
${SLON_BIN}/slon ...

Enfin, la souscription de l'ensemble de rplication est ralise.
subscribe set 

2.22 create_struct.sh
~~~~~~~~~~~~~~~~~~~~~
Ce script permet de supprimer les schmas sur les noeuds esclaves avant de les recrer en copiant le schma depuis le noeud matre.

ATTENTION : Ce script est dangereux dans la mesure o il supprime la base de donnes cible.

Ex :
./create_struct.sh -c test2

2.23 slony_addnode.sh
~~~~~~~~~~~~~~~~~~~~~
Ce script cre le script slon qui permet d'ajouter un noeud  une rplication.
Il prend en argument le nom d'une instance et le numro du noeud  ajouter.
Les fichiers de prambule et de dfinition des bases et relations doivent tre 
jour.
Ce script est appel par *21_create_addnode.sh*. Il ne doit pas tre appel
directement.

2.24 slony_addobj.sh
~~~~~~~~~~~~~~~~~~~~
Script appel par *11_create_addobj.sh*. Il permet de crer le script d'ajout
qui sera jou sur le noeud principal de la rplication.

Il ne doit pas tre appel directement.

2.25 slony_ctl.sh
~~~~~~~~~~~~~~~~~
Le script *slony_ctl.sh* est un script permettant d'arrter une rplication, de
la dmarrer ou redmarrer et d'en afficher le status. Il prend en argument le
nom d'une instance et l'action  effectuer.

L'action restart a pour effet supplmentaire de se connecter  toutes les bases
participant  la rplication pour supprimer le contenu des tables sl_nodelock
avant le dmarrage des processus slon.

Ex :
./slony_ctl.sh -c test2 start
./slony_ctl.sh -c test2 status

2.26 slony_execute.sh
~~~~~~~~~~~~~~~~~~~~~
Le script *slony_execute.sh* permet de propager un script SQL contenant des
instructions DDL (create, alter...). Il prend en argument le nom d'une instance
et le script.

Ce script est appel par *42_exec_exec.sh*. Il est prfrable de ne pas l'appeler directement.

2.27 slony_fail.sh
~~~~~~~~~~~~~~~~~~
Le script *slony_fail.sh* permet de supprimer le matre d'une rplication s'il
est devenu inaccessible.
Ce script prend en argument le nom d'une instance et le numro du noeud 
supprimer.

Attention : Il est prfrable de toujours essayer la bascule avant la
suppression. En effet, en cas de suppression, le noeud n'existe plus dans la
rplication. Il est alors ncessaire de le recrer intgralement pour le
rintgrer dans le rseau de rplication.

Ce script est appel par *92_exec_fail.sh*.

2.28 slony_path.sh
~~~~~~~~~~~~~~~~~~
Ce script recre les chemins entre les noeuds de la rplication. Il est appel par *71_create_path.sh*.

2.29 slony_repstat.sh
~~~~~~~~~~~~~~~~~~~~~
Le script *slony_repstat.sh* permet de calculer l'cart de rplication entre un
noeud et son matre.
Il prend en argument le nom d'une instance, et les numros des deux noeuds,
matre et esclave.

Ce script est appel par l'option *status* de *slony_ctl.sh*.

2.30 slony_subscribe.sh
~~~~~~~~~~~~~~~~~~~~~~~
Le script *slony_subscribe.sh* permet de resouscrire les noeuds d'une
rplication conformment au fichier relations.h.

Il prend en paramtre le nom d'une instance.

2.31 slony_switch.sh
~~~~~~~~~~~~~~~~~~~~
Le script *slony_switch.sh* permet d'effectuer une bascule entre un maitre et un
esclave. Il prend en arguments le nom d'une instance, le numro du noeud matre
et le numro du noeud qui va prendre le rle de matre.

Ce script est appel par *82_exec_switch.sh*.

Ex :
./slony_switch.sh -c test2 -f 1 -b 2

2.32 tree.sh
~~~~~~~~~~~~
Partie rcursive de l'affichage d'un arbre.
Appel par *aff_tree.sh*.

2.33 upgrade_slon.sh
~~~~~~~~~~~~~~~~~~~~
Le script *upgrade_slon.sh* arrte les rplications, met  jour les fonctions
sur les diffrents noeuds et redmarre les rplications.

2.34. slony_dropobj.sh
~~~~~~~~~~~~~~~~~~~~~~
Ce script permet de crer la suite de commande  utiliser pour
supprimer des objets (tables/squences) d'une rplication active.

Les objets  supprimer sont dfinis dans un fichier externe.

Ce script est appel par *111_create_dropobj.sh*.

2.35. 111_create_dropobj.sh
~~~~~~~~~~~~~~~~~~~~~~~~~~~
Le script *111_create_dropobj.sh* appelle le script prcdent de faon
 crer la suite de commande ncessaire  la suppression d'objets.

Il prend 2 arguments :
  - Le nom de l'instance de rplication ;
  - Le nom du fichier contenant les objets  supprimer.

Le script rsultant est stock, par dfaut, dans le rpertoire /tmp.

2.35.1. Format du fichier
.........................
Le fichier de dfinition est de la forme : 
TAB="..."
SEQ="..."

Ex:
./111_create_dropobj.sh -c test2 -f drop.txt

drop.txt :
TAB="test.a_table public.another_table"
SEQ="test.a_sequence"


2.36 112_exec_dropobj.sh
~~~~~~~~~~~~~~~~~~~~~~~~
Ce script permet d'excuter le script prcdemment cr.

Il prend un paramtre, le nom de l'instance de rplication.

Ex: 
./112_exec_dropobj.sh -c test2


2.37. slony_propagate.sh
~~~~~~~~~~~~~~~~~~~~~~~~
Script de propagation de requtes SQL  l'ensemble des 
noeuds d'une rplication.

Les requtes sont excutes directement sur la base, sans passer 
par Slony.

Ce script est appel par 102_exec_propagate.sh.

Il prend deux arguments, le nom de l'instance et le nom du fichier.


2.38. 102_exec_propagate.sh
~~~~~~~~~~~~~~~~~~~~~~~~~~~
Ce script permet de propager les requtes contenues dans le ficheir pass
en argument  l'ensemble des noeuds d'une rplication.

Le script prend deux paramtres, le nom de l'instance et le nom du fichier.

Ex : 
./102_exec_propagate.sh -c test2 -f /chemin/vers/le/fichier.sql


3. Utilisation des scripts
3.1. Initialisation de la rplication
3.1.0. Cration des structures sur les esclaves
./create_struct.sh -c <instance>

3.1.1. Cration des scripts
./01_create_init.sh -c <instance>

3.1.2. Lancement de la rplication
./02_exec_init.sh -c <instance>

3.2. Arrt d'une rplication
./slony_ctl.sh -c <instance> stop

3.3. [Re]Dmarrage de la rplication d'une instance
./slony_ctl -c <instance> [re]start

3.4. Vrification d'une rplication
./slony_ctl -c <instance> [-s <set_num>] status

3.5. Bascule contrle d'une rplication
./82_exec_switch.sh -c <instance> -f <node> -b <node>

3.6. Bascule sur incident
./92_exec_fail.sh -c <instance> -f <node> -b <node>

3.7. Propagation d'un script sur l'ensemble des noeuds
./42_exec_exec.sh -c <instance> -s <set_num> -f <sript_SQL>

3.8. Mise  jour de Slony1
./51_create_upgrade.sh
./52_exec_upgrade.sh

3.9. Ajout de tables/squences  une rplication
./11_create_addobj.sh -c <instance> -s <set_num> -f <script>
./12_exec_addobj.sh -c <instance> -s <set_num>

3.10. Ajout d'un noeud  une rplication
./21_create_addnode.sh -c <instance> -n <node>
./22_exec_addnode.sh -c <instance> -n <node>

3.11. Ajout d'un set de rplication
./31_create_set.sh -c <instance> -s <set_num>
./32_exec_set.sh -c <instance> -s <set_num>

3.12. Resouscription des noeuds en fonction de relations.h
./62_exec_subscribe.sh -c <instance>

3.13. Recration des chemins entre noeuds
./71_create_path.sh -c <instance>
./72_exec_path -c <instance>

3.14. Afficher l'arbre de rplication
./aff_tree.sh -c <instance> -s <set_num>

3.15. Supprimer des tables/squences
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
./111_create_dropobj.sh -c <instance> -f <file>
./112_exec_dropobj.sh -c <instance>

3.16. Excuter un script
~~~~~~~~~~~~~~~~~~~~~~~~
./102_exec_propagate.sh -c <instance> -f <file>
