#!/bin/bash
# fonctions.sh
# Auteur : Stphane Schildknecht
# Some generic functions


#############
# Excution #
#############
cd `dirname $0`
cd ..
SLON=`pwd`
#. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib

#set -x
#################
# Les fonctions #
#################

# Constitution d'un tableau  deux dimensions.
# Cela permet de stocker :
# NoeudX : BASE | HOST | PORT
# Ainsi :
# NODE[$i]=numro du noeud
# NODE[$1+1]=base
# NODE[$i+2]=host
# NODE[$i+3]=port
# INDEX est un tableau qui permet de savoir  quel indice du tableau NODE
# est stock le noeud

node (){
	INSTANCE=$1
	nb_node=1
	while read line
	do
	    echo $line | grep -v "^#" | grep "^$INSTANCE\b" > /dev/null
	    if [ $? -eq 0 ] ; then
		BASE=( $line )
		NODE[$nb_node]=${BASE[1]} #Numro du noeud
    		NODE[$nb_node+1]=${BASE[2]} #Base
    		NODE[$nb_node+2]=${BASE[3]} #Host
		NODE[$nb_node+3]=${BASE[4]} #Port
		INDEX[${BASE[1]}]=$nb_node
    		let nb_node=$nb_node+4
	    fi
	done < $SLON_ETC/bases.h

	let taille_nod=$nb_node-4
	let nb_node=$(($nb_node-1))/4
    return $nb_node
}

# Constitution du tableau des relations entre les noeuds
# RELATION : maitre | esclave
# Ainsi :
# $REL[$i]=maitre
# $REL[$i+1]=esclave
# Le tableau est reconstruit pour chaque set...

relation (){
    MASTER=0
    nb_rel=1
    SET_ID=$1
    # Il va falloir reconstruire les relations set par set...
    # Faut-il stocker le nb_rel par set ?
    while read line
    do
    	tempset=`echo $line | grep -v "^#" | grep "^$INSTANCE\b" | awk '{print $2}'`
    	if [[ $tempset -ne 0 && $tempset -eq $SET_ID ]]; then
	    BASE=( $line )
	    REL[$nb_rel]=${BASE[2]}
	    REL[$nb_rel+1]=${BASE[3]}
	    if [ ${MASTER} -eq 0 ]; then
		MASTER=${BASE[2]}
	    else
    		if [ ${MASTER} -eq ${BASE[3]} ]; then
		    MASTER=${BASE[2]}
    		fi
    	    fi
	    let nb_rel=$nb_rel+2
	fi
    done < $SLON_ETC/relations.h
    
    let taille_rel=$nb_rel-2
    let nb_rel=$(($nb_rel-1))/2
    return $nb_rel
}

# Mise  jour du fichier de relations
relation_file(){
    CLUSTER=$1
    DB=$2
    HOST=$3
    PORT=$4

    echo "Mise  jour du fichier de realtions"

    cp $SLON_ETC/relations.h $SLON_ETC/relations.h.`date +%y%m%d%H`
    grep -v "\b$CLUSTER\b" $SLON_ETC/relations.h.`date +%y%m%d%H` > $SLON_ETC/relations.h
#	echo "" >> $SLON_ETC/relations.h
    echo "# La rplication $CLUSTER" >> $SLON_ETC/relations.h
    psql -t $DB -U$SLONY_USER -p$PORT -h$HOST -c "select E'$CLUSTER  '||sub_set||E'  '||sub_provider||E'  '||sub_receiver from _$INSTANCE.sl_subscribe order by sub_set asc,sub_provider,sub_receiver asc;" | sed -e 's/^ //' | sed -e 's/  /\t/g' >> $SLON_ETC/relations.h

#mv $SLON_ETC/relations.h $SLON_ETC/relations.h.`date +%y%m%d`
#cp $SLON_TEMP/relations.h $SLON_ETC/relations.h
}

test_repli() {
    SEUIL=5
    REPLI="_$1"
    BASE=$2
    USEUR=$SLONY_USER
    HOTE=$3
    PORT=$4
    PF_TAMPON=$SLON_LOG/decalage_slony
    
    l_retour=0
    for l_noeud in `/usr/bin/psql $BASE -U $USEUR -h $HOTE -p $PORT -t \
                    -c "select no_id from "$REPLI".sl_node order by no_id asc;"`
    do
            l_decalage=`/usr/bin/psql $BASE -U $USEUR -h $HOTE -p $PORT -t \
                    -c "select st_lag_num_events from "$REPLI".sl_status where st_received=$l_noeud;"`
    
            l_decalage=`expr $l_decalage + 0`
            echo " - $l_decalage transactions pour le noeud $l_noeud" >&2
            if test $l_decalage -gt $SEUIL
            then
    	    l_retour=`expr $l_retour + $l_noeud`
            fi
    done
    
    touch $PF_TAMPON
    if [ $l_retour -ne 0 ]
    then
            if [ "`cat $PF_TAMPON`" != "`date +%Y%m%d%H`" ]
            then
                    date +%Y%m%d%H>$PF_TAMPON
            fi
    fi
    
    exit $l_retour
}

moveset(){
    INSTANCE=$1
    SETID=$2
    MASTERNODE=$3
    SLAVENODE=$4
                
    ${SLON_BIN}/slonik <<_EOF_
	#--
        # Inclusion du fichier <preamble>
        #--
        INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

        try{
	    echo 'unlock $SETID : ';
            UNLOCK SET (
		ID = $SETID,
                ORIGIN = $MASTERNODE );
        }
        on success { echo 'OK' ;}
        on error { echo 'KO' ;}

        try{
	    echo 'move set $SETID : ';
            LOCK SET (
		ID = $SETID,
                ORIGIN = $MASTERNODE ) ;
            echo 'lock set : OK';
            echo 'move set : ';
            MOVE SET (
	        ID = $SETID,
                OLD ORIGIN = $MASTERNODE,
                NEW ORIGIN = $SLAVENODE );
        }
        on error { echo 'KO' ;}
        on success { echo 'OK' ;}
_EOF_
}

relbase_miss(){
    if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h ]; then
        if [[ x$LANG = xfr* ]]; then
            echo "Fichier ${SLON_ETC}/bases.h ou ${SLON_ETC}/relations.h introuvable." >&2
            echo "Merci de vrifier votre installation." >&2
        else
            echo "${SLON_ETC}/bases.h or ${SLON_ETC}/relations.h not found." >&2
            echo "Verify your settings." >&2
        fi
        return 1
    fi
    return 0
}

preamble_miss(){
    C_NAME=$1
    if [ ! -e ${SLON_ETC}/$C_NAME.preamble ]; then
        if [[ x$LANG = xfr* ]]; then
            echo "Fichier ${SLON_ETC}/$C_NAME.preamble introuvable." >&2
            echo "Merci de vrifier votre installation." >&2
        else
            echo "${SLON_ETC}/$C_NAME.preamble not found." >&2
            echo "Verify your settings." >&2
        fi
        return 1
    fi
    return 0
}

exit_on_error(){
    CONTEXT=$1
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue lors de l'opration \"$CONTEXT\""
    else
	echo "An error occured while \"$CONTEXT\""
    fi
    exit 1
}
