#!/bin/bash
# Auteur : Stéphane Schildknecht <sas@postgresql.fr>
# 01_create_init.sh
# Initialisation scripts creation
# 2006-11-17
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Crée les fichiers d'initialisation d'une réplication."
	echo "  Options :"
	echo "   --help                Affiche ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  This script will create files for initialising a replication"
	echo "  Options:"
	echo "   --help                Print this message"
	echo "   -c|--cluster          Replication instance name"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ;
                	slhelp ;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
		echo "Warning!" ;
                slhelp ;
               exit 1
               ;;
  esac
  shift
done

## FR : S'il y a un argument à la fonction, on considère
# qu'il s'agit du nom de l'instance et que seule celle-ci
# est à répliquer.
## EN: If an argument was given, we consider it to be 
# the name of the replication instance. This is the one
# to be initialised.

## FR : Creation des fichiers à inclure dans les scripts slonik
# Attention ! Ces scripts codent en dur les maitres et esclaves
## EN: Creation of preamble files
# Be careful, in these files, MASTER and SLAVES are hardcoded.
if [[ x$LANG = xfr* ]]; then
	echo "Création des fichiers de préambule"
else
	echo "Preamble files creation"
fi
${SLON_OUTILS}/create_preamble.sh ${INSTANCE:+-c $INSTANCE}

if [ x"$INSTANCE" != "x" ]; then
    GREP="echo $INSTANCE"
else
    GREP="grep -v \"^#\" $SLON_ETC/bases.h | awk '{print \$1}' |sort -u"
fi

## FR : Création des scripts .slon contenant les scripts
# slonik de mise en place de la réplication.
## EN: Creation of .slon scripts, which include slonik scripts. 
# These are used to settle up the replication.
for CLUSTER in `eval $GREP`
do

    if [[ x$LANG = xfr* ]]; then
          echo "Création du fichier d'initialisation de la réplication des bases de $CLUSTER"
    else
          echo "Creation of initialisation file for replication of $CLUSTER databases."
    fi
    ${SLON_OUTILS}/create_slon.sh -c $CLUSTER > ${SLON_TEMP}/$CLUSTER.slon
    if [ $? -ne 0 ]; then
	if [[ x$LANG = xfr* ]]; then
	    echo "Une erreur est survenue..."
	else
	    echo "An error has occured..."
	fi
	exit 1;
    fi
    chmod 700 ${SLON_TEMP}/$CLUSTER.slon
done

echo "OK"
exit 0
