#!/bin/bash
# Auteur: Stéphane Schildknecht <sas@postgresql.fr>
# Rev 20090424
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP
#  - 20090424 SAS
#    Bug in test case
#    per report from Bastian Voigt

# 02_exec_init.sh
# Launcher for initialisation script

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The name of the replication instance"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c:h: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
		echo "Warning!";
		slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" ]; then
       	slhelp;
  	exit 1
else
    grep $INSTANCE $SLON_ETC/relations.h > /dev/null
    if [ $? -ne 0 ]; then
	if [[ x$LANG = xfr* ]]; then
	    echo "La réplication $INSTANCE n'est pas définie."
	else
	    echo "$INSTANCE replication is not defined."
	fi
	exit 1
    fi
fi

if [[ x$LANG = xfr* ]]; then
	echo "Démarrage réplication ${INSTANCE}..."
else
	echo "Initialising ${INSTANCE} replication..."
fi

sh ${SLON_TEMP}/${INSTANCE}.slon > ${SLON_LOG}/${INSTANCE}.log 2>&1
if [ $? -ne 0 ]; then
	if [[ x$LANG = xfr* ]]; then
        	echo "Une erreur est survenue. Consultez ${SLON_LOG}/${INSTANCE}.log pour les détails."
	else
        	echo "An error occured. See ${SLON_LOG}/${INSTANCE}.log for details."
	fi
	exit 1
fi

echo "OK"
exit 0
