#!/bin/bash
# Auteur : Stéphane Schildknecht
# 102_exec_propagate.sh
# 2009/05/11

# Script de lancement d'exécution de script SQL
# en dehors de Slony, sur tous les noeuds de la réplication
## EN: Allows one to propagate an SQL script
## on every node of a replication, outside of slonik.
## May be used to propagate a table creation, or an index, for instance

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

. $SLON_ETC/fonctions.sh

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
if [[ x"$LANG" = xfr* ]]; then
    echo "$0"
    echo ""
    echo "Usage : $0 *options*"
    echo "  Propagation d'un script sur tous les nœuds d'une réplication"
    echo "  Options :"
    echo "   --help                Afficher ce message"
    echo "   -c|--cluster          Le nom de l'instance de réplication"
    echo "   -f|--file             Le script"
    echo ""
else
    echo "$0"
    echo ""
    echo "Usage: $0 *options*"
    echo "  Execution of an SQL script on every node, outside of slony"
    echo "  Options:"
    echo "   --help              Print this message"
    echo "   -c|--cluster        The replication instance name"
    echo "   -f|--file           The SQL script"
    echo ""
fi
}

TEMP=`getopt -n $0 -o c:f: -l help,cluster:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-f|--file) shift;
		FILE="$1"
		;;
        --) shift ;
                break
                ;;
        *) echo "Warning!" ;
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

if [[ x"$LANG" = xfr* ]]; then
    echo "Lancement du script $FILE sur les noeuds de $INSTANCE..."
else
    echo "Execution of $FILE on every node of $INSTANCE replication..."
fi

${SLON_OUTILS}/slony_propagate.sh -c $INSTANCE -f $FILE > $SLON_LOG/${INSTANCE}_prop.log

if [ $? -ne 0 ]; then
    exit_on_error "Propagation";
    exit 1
fi

exit 0
