#!/bin/bash
# SAS 2009/04/15

# 111_create_dropobj.sh
# Creation of the script to drop objects from a running
# replication

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo "   -f|--file             Le fichier contenant les noms des objets"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The name of the replication instance"
	echo "   -f|--file             The file containing the objects names"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o f:c: -l help,cluster:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp; 
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
  esac
  shift
done


if [ x"$INSTANCE" = "x" -o x"$FILE" = "x" ]; then
    slhelp ;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Création du fichier de suppression d'objets..."
else
    echo "Creating Slonik Drop Objects script..."
fi

if [ ! -e $FILE ]; then
    echo "$FILE not found."
    exit 1
fi
${SLON_OUTILS}/slony_dropobj.sh -c $INSTANCE -f $FILE >${SLON_TEMP}/${INSTANCE}_dropobj.slon
if [ $? -ne 0 ]; then
        if [[ x$LANG = xfr* ]]; then
                echo "Une erreur est survenue..."
        else
                echo "An error occured..."
        fi
        exit 1
fi

chmod 700 ${SLON_TEMP}/${INSTANCE}_dropobj.slon

echo "OK"
exit 0
