#!/bin/bash
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 112_exec_dropobj.sh
# Slonik scripts to drop objects to an existing set of replication

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

# Script de suppression d'objets d'une réplication

slhelp() {
    if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo ""
    else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The name of the replication instance"
  echo ""
    fi
}

TEMP=`getopt -n $0 -o h:s:c: -l help,set:,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help pour obtenir de l'aide" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
		echo "Warning!";
		slhelp;
                exit 1
                ;;
  esac
  shift
done


if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Suppression des objets..."
else
    echo "Dropping objects..."
fi

/bin/bash ${SLON_TEMP}/${INSTANCE}_dropobj.slon > ${SLON_LOG}/${INSTANCE}_dropobj.log 2>&1
if [ $? -ne 0 ]; then
	if [[ x$LANG = xfr* ]]; then
                echo "Une erreur est survenue. Consulter ${SLON_LOG}/${INSTANCE}_dropobj.log pour les détails."
        else
                echo "An error occured. See ${SLON_LOG}/${INSTANCE}_dropobj.log for details."
        fi
        exit 1
fi

echo "OK"
exit 0
