#!/bin/bash
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 11_create_addobj.sh
# Creation of the script to add objects to an already runnning
# replication

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo "   -s|--set              Le numéro du set"
	echo "   -f|--file             Le fichier contenant les noms des objets"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The name of the replication instance"
	echo "   -s|--set              The number of the set"
	echo "   -f|--file             The file containing the objects names"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o f:s:c: -l help,set:,cluster:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp; 
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
  esac
  shift
done


if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$FILE" = "x" ]; then
    slhelp ;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Création du fichier d'ajout d'objets..."
else
    echo "Creating Slonik Add Objects script..."
fi

if [ ! -e $FILE ]; then
    echo "$FILE not found."
    exit 1
fi
${SLON_OUTILS}/slony_addobj.sh -c $INSTANCE -s $SET -f $FILE >${SLON_TEMP}/${INSTANCE}_${SET}_addobj.slon
if [ $? -ne 0 ]; then
        if [[ x$LANG = xfr* ]]; then
                echo "Une erreur est survenue..."
        else
                echo "An error occured..."
        fi
        exit 1
fi

chmod 700 ${SLON_TEMP}/${INSTANCE}_${SET}_addobj.slon

echo "OK"
exit 0
