#!/bin/bash
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 21_create_addnode.sh
## EN: Adding a node to an already active replication
# Subscription is done regarding relations.h, there's no need 
# to precise the set.
## FR : Ajout d'un noeud à une réplication active
# La souscription est effectuée conformément au fichier 
# relations.h, il n'est donc pas nécessaire de préciser le 
# set de réplication.

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0 : Ajout d'un noeud à une réplication"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo "   -n|--node             Le numéro du noeud à ajouter"
	echo ""
    else
	echo "$0: Adding a node to an active replication"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The name of the replication instance"
	echo "   -n|--node             The number of the node"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c:n: -l help,cluster:,node: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
NUM=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ;
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -n|--node) shift ;
                NUM="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
		echo "Warning!";
                slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$NUM" = "x" ]; then
    slhelp
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Création du script d'ajout du noeud $NUM..."
else
    echo "Creating script to add the node $NUM..."
fi

/bin/bash ${SLON_OUTILS}/slony_addnode.sh -c $INSTANCE -n $NUM > $SLON_TEMP/${INSTANCE}_${NUM}_add.slon
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue..."
    else
	echo "An error occured..."
    fi
    exit 1
fi
chmod 700 $SLON_TEMP/${INSTANCE}_${NUM}_add.slon

echo "OK"
exit 0
