#!/bin/bash
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 22_exec_addnode.sh
## FR : Exécution du script d'ajout d'un noeud
## EN: Launcher for the script to add a node

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

## FR : Script d'ajout d'un noeud à une réplication active
# La souscription est fonction des informations contenues
# dans le fichier relations.h.
# Il n'est donc pas utile de préciser le set.
## EN: Subscription is done regarding relations.h
# Precising set is useless.


slhelp() {
    if [[ x$LANG = xfr* ]]; then
  echo "$0 : Exécution du script d'ajout de noeud"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -n|--node             Le numéro du noeud à ajouter"
  echo ""
    else
  echo "$0: Executing the addnode script"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The name of the replication instance"
  echo "   -n|--node             The number of the node to add"
  echo ""
    fi
}

TEMP=`getopt -n $0 -o c:n: -l help,cluster:,node: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
NUM=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -n|--node) shift ;
                NUM="$1"
                ;;
        --) shift ;
                break
                ;;
        *) 
		echo "Warning!";
                slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$NUM" = "x" ]; then
	slhelp
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Exécution de l'ajout du noeud ${NUM}..."
else
    echo "Executing addnode ${NUM}..."
fi
/bin/bash $SLON_TEMP/${INSTANCE}_${NUM}_add.slon > $SLON_LOG/${INSTANCE}_${NUM}_add.log 2>&1
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Une erreur est survenue. Consulter $SLON_LOG/${INSTANCE}_${NUM}_add.log pour les détails."
    else
        echo "An error occured. See $SLON_LOG/${INSTANCE}_${NUM}_add.log for details."
    fi
    exit 1
fi
 
chmod 700 $SLON_LOG/${INSTANCE}_${NUM}_add.log

echo "OK"
exit 0
