#!/bin/bash
# Auteur : Stéphane Schildknecht
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 31_create_set.sh
## FR : Création du script d'ajout d'un set à une réplication
## EN: Creation of the script for adding a set to a replication


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Création des fichiers d'ajout d'un set à une réplication"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set		 Le numéro du set à créer"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Creating scritp to add a set to an existing replication"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The name of the replication instance"
  echo "   -s|--set		 The number of the set to be created"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s:h -l help,cluster:,set: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-s|--set) shift;
		SET="$1"
		;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
		slhelp ;
               exit 1
                ;;
  esac
  shift
done

## FR : Creation des fichiers a inclure dans les scripts slonik
# Attention ! Ces scripts codent en dur les maitres et esclaves
## EN: Creation of preamble files. Be careful, they hard code
# master and slaves
if [[ x$LANG = xfr* ]]; then
    echo "Création des fichiers de préambule..."
else
    echo "Creation of preamble files..."
fi

${SLON_OUTILS}/create_preamble.sh ${INSTANCE:+-c $INSTANCE}
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
    else
	echo "An error occured."
    fi
    exit 1
fi

## FR : Création des scripts .slon contenant les scripts 
# slonik de mise en place de la réplication.
## EN: Creation of the slonik script for setting the new set
if [[ x$LANG = xfr* ]]; then
    echo "Création du fichier d'ajout du set $SET à $INSTANCE..."
else
    echo "Creation of script to add $SET to $INSTANCE..."
fi
${SLON_OUTILS}/create_slon.sh -c $INSTANCE -s $SET > ${SLON_TEMP}/${INSTANCE}_$SET.slon
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Une erreur est survenue."
    else
        echo "An error occured."
    fi
    exit 1
fi

chmod 700 ${SLON_TEMP}/${INSTANCE}_$SET.slon
echo "OK" 
exit 0
