#!/bin/bash
# Rev 20070423 : Possibilité de passer le nom de l'instance en argument
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 32_exec_set.sh
## FR : Exécution du script d'ajout d'un set
## EN: Execution of the addset script

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set              Le numéro du set"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The name of the replication instance"
  echo "   -s|--set              The number of the set"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s: -l help,cluster:,set: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning";
		slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" ]; then
	slhelp
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Ajout set $SET à ${INSTANCE}..."
else
    echo "Adding set $SET to $INSTANCE replication..."
fi

/bin/bash ${SLON_TEMP}/${INSTANCE}_$SET.slon > ${SLON_LOG}/${INSTANCE}_$SET.log 2>&1
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue. Consultez ${SLON_LOG}/${INSTANCE}_$SET.log pour les détails."
    else
	echo "An error occured. See ${SLON_LOG}/${INSTANCE}_$SET.log for details."
    fi
    exit 1
fi

echo "OK"
exit 0

