#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2008/04/23
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 41_create_exec.sh
## FR : Script de lancement d'exécution de script SQL
## EN: Execution of sql through slonik


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Exécution de requêtes SQL à travers slonik"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set		 Le numéro du set"
  echo "   -f|--file	         Le script"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Execution of an SQL script through slonik"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The name of the replication instance"
  echo "   -s|--set		 The number of the set"
  echo "   -f|--file	         The SQL script"
  echo ""
fi
}

TEMP=`getopt -n $0 -o h:c:s:f: -l help,cluster:,set:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-s|--set) shift;
		SET="$1"
		;;
	-f|--file) shift;
		FILE="$1"
		;;
        --) shift ;
                break
                ;;
        *)
                echo "Warning!";
		slhelp ;
               exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

if [ `dirname $FILE` = "." ]; then
    FILE=`pwd`/$FILE
fi

if [[ x$LANG = xfr* ]]; then
    echo "Lancement du script $FILE sur le set $SET de $INSTANCE..."
else 
    echo "Executing $FILE on set $SET (replication $INSTANCE)..."
fi
${SLON_OUTILS}/slony_execute.sh -c $INSTANCE -s $SET -f $FILE > $SLON_LOG/${INSTANCE}_${SET}_exec.log 2>&1

if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
	echo "Consulter le fichier $SLON_LOG/${INSTANCE}_${SET}_exec.log pour plus de détails."
    else
	echo "An error occured."
	echo "See $SLON_LOG/${INSTANCE}_${SET}_exec.log for details."
    fi
    exit 1;
fi

echo "OK"
exit 0
