#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-11-17
# Rev 2007-04-17
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP


# 51_create_upgrade.sh
## FR : Préparation du script de montée de version de Slony
## EN: Creating slony upgrade script

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

# Récupération des noms des bases dans le fichier bases.h
for INSTANCE in `grep -v "^#" $SLON_ETC/bases.h | awk '{print $1}' | sort -u`
    do
	echo -n "  $INSTANCE..." 
        echo "#!/bin/bash" > $SLON_TEMP/${INSTANCE}.slon.up
	${SLON_OUTILS}/upgrade_slon.sh -c $INSTANCE >> $SLON_TEMP/${INSTANCE}.slon.up
	if [ $? -ne 0 ]; then  
	    if [[ x$LANG = xfr* ]]; then
		echo "Une erreur est survenue."
	    else 
		echo "En error occured."
	    fi
	    exit 1;
	fi
	chmod 700 $SLON_TEMP/${INSTANCE}.slon.up
	echo "OK"
done

echo "All : OK"
exit 0
