#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-11-17
# Rev 2007-04-17
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 52_exec_upgrade.sh 
## FR : Execution du script de montée de version de Slony
## EN: Upgrading Slony1


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

## FR : Récupération des noms des bases dans le fichier bases.h
## EN: Database names are in bases.h file
for INSTANCE in `grep -v "^#" $SLON_ETC/bases.h | awk '{print $1}' | sort -u`
    do
	echo -n "  $INSTANCE..."
	/bin/bash $SLON_TEMP/${INSTANCE}.slon.up > $SLON_LOG/${INSTANCE}.up.log 2>&1
	if [ $? -ne 0 ]; then
	    if [[ x$LANG = xfr* ]]; then
		echo "Une erreur est survenue. Consulter $SLON_LOG/${INSTANCE}.up.log pour les détails."
	    else
		echo "An error occured. See $SLON_LOG/${INSTANCE}.up.log for details."
	    fi
	    exit 1;
	fi
	echo "OK"
done

echo "All : OK"
exit 0
