#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2008/04/23
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 62_exec_subscribe.sh
## FR : Re-souscription des réplications
## EN: Replication re-subscribtion

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Re-souscription des réplications en fonction du fichier relations.h"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Re-subscribing replication regardin relations.h file"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The replication instance name"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Resouscription de la réplication $INSTANCE..."
else
    echo "Re-subscribing replication $INSTANCE..."
fi

${SLON_OUTILS}/slony_subscribe.sh -c $INSTANCE > $SLON_LOG/${INSTANCE}_subscribe.log 2>&1
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
	echo "Consulter le fichier $SLON_LOG/${INSTANCE}_subscribe.log pour les détails."
    else
	echo "An error has occured."
	echo "See $SLON_LOG/${INSTANCE}_subscribe.log for details."
    fi
    exit 1;
fi

echo "OK"
exit 0
