#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-11-17
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 71_create_path.sh
## FR : Script de recréation des paths
## EN: Creating script for paths

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Création du fichier de définitions des chemins entre noeuds"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Création du fichier de définitions des chemins entre noeuds"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c: -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help pour obtenir de l'aide" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Création du script PATH..."
else
    echo "Creating PATH script..."
fi
${SLON_OUTILS}/slony_path.sh -c $INSTANCE > $SLON_TEMP/${INSTANCE}_path.sh 2>$SLON_LOG/${INSTANCE}_cree_path.log
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
	echo "Consulter $SLON_LOG/${INSTANCE}_cree_path.log pour les détails."
    else
	echo "An error occured."
	echo "See $SLON_LOG/${INSTANCE}_cree_path.log for details."
    fi
    exit 1
fi

chmod 700 $SLON_TEMP/${INSTANCE}_path.sh
echo "OK"
exit 0
