#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2008/04/23
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 82_exec_switch.sh 
## FR : Bascule contrôlée entre un noeud et l'un de ses esclaves
## EN: Switchover between a node and one of his slave


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
	echo ""
	echo "Usage : $0 *options*"
	echo "  Bascule contrôlée entre un noeud et l'un de ses esclaves"
	echo "  Options :"
	echo "   --help                Afficher ce message"
	echo "   -c|--cluster          Le nom de l'instance de réplication"
	echo "   -f|--failed           Le numéro de l'ancien maître"
	echo "   -b|--backup           Le numéro du nouveau maître"
	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo "  Switchover between a node and one of his slaves"
	echo "  Options:"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The replication instance name"
	echo "   -f|--failed           The failed node (ancient provider)"
	echo "   -b|--backup           The backup node (new provider)"
	echo ""
fi
}

TEMP=`getopt -n $0 -o c:f:b:h -l help,cluster:,failed:,backup -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
FAILED=""
BACKUP=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-f|--failed) shift ;
	        FAILED="$1"
	        ;;
	-b|--backup) shift ;
                BACKUP="$1"
		;;
	--) shift ;
                break
                ;;
        *)
		echo "Warning!";
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$FAILED" = "x" -o x"$BACKUP" = "x" ]; then
    slhelp;
    exit 1
fi

if [[ x$LANG = xfr* ]]; then
    echo "Bascule de $INSTANCE : $FAILED vers $BACKUP..."
else
    echo "$INSTANCE switchover : from $FAILED to $BACKUP..."
fi

${SLON_OUTILS}/slony_switch.sh -c $INSTANCE -f $FAILED -b $BACKUP > $SLON_LOG/${INSTANCE}_switch.log 2>&1
if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Une erreur est survenue. Consulter $SLON_LOG/${INSTANCE}_switch.log pour les détails."
    else
	echo "An error occured. See $SLON_LOG/${INSTANCE}_switch.log for details."
    fi
    exit 1
fi

echo "OK"
exit 0
