#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2008/04/23
# MAJ 2007-06-28
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20071216 Bernard Choppy
#    deplacement des fichiers "*.slon" dans $SLON_TEMP

# 92_exec_fail.sh
## FR : Script de bascule sur incident (suppression d'un noeud)
## EN: Failover script


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Bascule sur incident entre un noeud et l'un de ses esclaves"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -f|--failed           Le numéro de l'ancien maître"
  echo "   -b|--backup           Le numéro du nouveau maître"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Switchover"
  echo "  Options:"
  echo "   --help                Print this message"
  echo "   -c|--cluster          The replication instance name"
  echo "   -f|--failed           Failed node (ancient master)"
  echo "   -b|--backup           Backup node (not mandatory)"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:f:b:h -l help,cluster:,failed:,backup -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
FAILED=""
BACKUP=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-f|--failed) shift ;
	        FAILED="$1"
	        ;;
	-b|--backup) shift ;
                BACKUP="$1"
		;;
	--) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$FAILED" = "x" ]; then
    slhelp;
    exit 1
fi

if [ x"$BACKUP" = "x" ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Suppression du noeud $FAILED de la réplication $INSTANCE..."
    else
	echo "Dropping node $FAILED from $INSTANCE replication..."
    fi
    ${SLON_OUTILS}/slony_fail.sh -c $INSTANCE -f $FAILED > $SLON_LOG/${INSTANCE}_drop_$FAILED.log 2>&1
    if [ $? -ne 0 ]; then
	if [[ x$LANG = xfr* ]]; then
	    echo "Une erreur est survenue."
	    echo "Consulter $SLON_LOG/${INSTANCE}_drop_$FAILED.log pour les détails."
	else
	    echo "An error occured."
	    echo "See $SLON_LOG/${INSTANCE}_drop_$FAILED.log for details."
	fi
	exit 1
    fi
else
    if [[ x$LANG = xfr* ]]; then
	echo "Bascule de $INSTANCE : $FAILED vers $BACKUP..."
    else
	echo "Failover $INSTANCE: $FAILED - $BACKUP..."
    fi
    ${SLON_OUTILS}/slony_fail.sh -c $INSTANCE -f $FAILED -b $BACKUP > $SLON_LOG/${INSTANCE}_fail_$FAILED.log 2>&1
    if [ $? -ne 0 ]; then
        if [[ x$LANG = xfr* ]]; then
            echo "Une erreur est survenue."
	    echo "Consulter $SLON_LOG/${INSTANCE}_fail_$FAILED.log pour les détails."
        else
            echo "An error occured."
	    echo "See $SLON_LOG/${INSTANCE}_fail_$FAILED.log for details."
        fi
        exit 1
    fi
fi

echo "OK"
exit 0
