#!/bin/bash
# Auteur : Stéphane Schildknecht
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# aff_tree.sh 
## FR : affichage de l'arbre de relations
## EN: Print relations tree

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set              Le numéro du set"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   --help                Print this message"
  echo "   -c|--cluster          Replication instance name"
  echo "   -s|--set              The number of the set"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s:h -l help,set:,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" ]; then
	slhelp;
    exit 1
fi

relation $SET

trouve=0
for (( j=1 ; j <= taille_rel ; j+=2 )); do
    if [ ${REL[$j]} -eq ${REL[1]} ]; then
	if [ $trouve -gt 0 ]; then
	    echo -n "\--"
	else
	    echo -n ${REL[1]}--
	fi
	let trouve=$trouve+1
	${SLON_OUTILS}/tree.sh -c $INSTANCE -s $SET -p ${REL[$j]} -f ${REL[$j+1]}
    fi
done

exit 0
