#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-12-19
# 2007-03-14 : Prise en compte des réplications en cascade
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# create_preamble.sh
## FR : Script de création des fichiers de préambule
# Les fichiers de préambule sont créés pour toutes les bases décrites dans
# le fichier bases.h, en fonction des informations présentes dans le fichier
# relations.h
## EN: Creation of preamble files.
# These are defined regarding information in bases.h and relations.h

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib

## FR : S'il y a un argument, on ne traite que cette instance,
# dans le cas contraire, toutes les instances
## EN: If a cluster is specified, we only treat it. Otherwise, 
# all clusters preable files are created.

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:h -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ;
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Fichier ${SLON_ETC}/bases.h ou ${SLON_ETC}/relations.h introuvable."
        echo "Merci de vérifier votre installation."
    else
        echo "Can't find ${SLON_ETC}/bases.h or ${SLON_ETC}/relations.h."
        echo "Please verify your settings."
    fi
    exit 1
fi


if [ x"$INSTANCE" = "x" ]; then
    GREP="grep -v \"^#\" $SLON_ETC/bases.h | awk '{print \$1}' | sort -u"
else
    GREP="echo $INSTANCE"
fi

## FR : Pour toutes les instances
## EN: For every instance
for CLUSTER in `eval $GREP`
do
    cat <<_EOF  > ${SLON_ETC}/$CLUSTER.preamble
CLUSTER NAME = $CLUSTER ;
_EOF

    while read line
    do
	echo $line | grep -v "^#" | grep "^$CLUSTER\b" > /dev/null
	if [ $? -eq 0 ] ; then

    	    base=( $line )
    	    cat <<__EOF  >> ${SLON_ETC}/$CLUSTER.preamble
NODE ${base[1]} ADMIN CONNINFO = 'dbname=${base[2]} host=${base[3]} port=${base[4]} user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}';
__EOF
    	fi
    done<$SLON_ETC/bases.h
    chmod 600 ${SLON_ETC}/$CLUSTER.preamble
done

exit 0
