#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2006-11-17
# 2007/03/20 : Prise en compte des réplications en cascade
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# create_slon.sh
## FR : Script de mise en place de la réplication des bases
## EN: Setting up a replication

#############
# Exécution #
#############
cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo " Script de création des fichiers d'initialisation de la réplication"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help		    Afficher ce message"
  echo "   -c|--cluster <instance>  Le nom de l'instance de réplication"
  echo "   -s|--set <set>	    Numéro du set à créer. En l'absence de précision, la réplication est initialisée."
  echo ""
else
  echo "$0"
  echo " Creation of scripts to initialize a replication"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   --help		    Print this help"
  echo "   -c|--cluster <instance>  The replication instance name"
  echo "   -s|--set <set>	    The number of the set to create. When not specified, the whole replication is initialised."
  echo ""
fi
}


TEMP=`getopt -n $0 -o c:s: -l help,cluster:,set: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=0
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ;
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
	-s|--set) shift ;
		SET="$1";
		;;
        --) shift ;
                break
                ;;
        *)
                echo "Warning!";
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" ]; then
	slhelp;
    exit 1
fi

CLUSTERNAME=$INSTANCE

###############
## FR : On fonctionne en deux temps :
# 1. Les requêtes systèmes permettant d'ajouter les langages procéduraux, de
# supprimer les schémas éventuellement existant et d'arrêter les daemons
# slon s'il en existe
# 2. le script slonik d'initialisation de la réplication
###############
# On lit toutes les lignes du fichier.
# Pour toutes celles qui correspondent à l'instance,
# S'il s'agit de la première (maître),
# Alors, on initie la réplication (init cluster)
# Sinon, on ajoute le noeud (store node)
########################################
## EN: We act in two times
# 1. We add procedural language, drop any existing _CLUSTER schema, 
# stop any existing slon daemon dealing with concerned replication
# 2. We initiate the replication with a slonik script
##########
# The master of the replication is arbitrarily defined.
# We take the first node of bases.h file.
# For that node, we issue INIT CLUSTER.
# For every other node, we do STORE NODE.
##########


## FR : Création du tableau d'informations sur les noeuds
## EN: Node information array
node $CLUSTERNAME ;

## FR : De manière arbitraire, on décide que le maître est le premier noeud
# du fichier bases.h, soit NODE[1]
## EN: First node in bases.h is our master, NODE[1]
MASTERNODE=${NODE[1]} # On ne peut pas faire plus arbitraire :-(
MASTERHOST=${NODE[${INDEX[$MASTERNODE]}+2]}
MASTERPORT=${NODE[${INDEX[$MASTERNODE]}+3]}

cat <<EOF
#!/bin/bash
EOF
if [[ x$LANG = xfr* ]]; then
    cat <<EOF
# Script de création des fichiers de mise en place de la réplication

EOF
else 
    cat <<EOF
# Initialising replication

EOF
fi

## FR : Si SET n'est pas initialisé, c'est qu'on crée la réplication
## EN: If not SET specified, replication is initialized
if [ $SET -eq 0 ]; then
    ## FR : Création du fichier de script
    ## EN: Creation of script
    if [[ x$LANG = xfr* ]]; then
        cat <<EOF
# Arret de slon
echo "Arrêt des démons slon..."
EOF
    else
	cat <<EOF
# Stopping all running daemons
echo "Stopping slon..."
EOF
    fi
    cat <<EOF
for processus in \`ps auxw | grep slon | grep "\b$CLUSTERNAME\b" | grep -v sh | awk '{print \$2}'\` ; do
    kill -15 \${processus}
done
EOF
    if [[ x$LANG = xfr* ]]; then
        cat <<EOF
echo "Processus slon supprimes"
EOF
    else
	cat <<EOF
echo "Slon daemons stopped."
EOF
    fi

# FIXME which sur les binaires et $TRUC
# FIXME utiliser des fichiers templates et faire un sed /@@CLUSTERNAME@@/$CLUSTERNAME/

    ## FR : Suppression des éventuels schémas sur l'ensemble des noeuds
    # Ajout du plpgsql
    ## EN: Dropping slony schema, if any
    # Adding pl/pgsql
    for (( i=1 ; i <= taille_nod ; i+=4 )); do
      cat <<EOF

###
#${NODE[$i+1]} - ${NODE[$i+2]}
EOF
    if [[ x$LANG = xfr* ]]; then
	cat <<EOF
# Ajout du langage PL/PgSQL
EOF
    else
	cat <<EOF
# We add PL/pgSQL
EOF
    fi
    cat <<EOF
$PG/bin/createlang plpgsql -U ${SLONY_USER} ${NODE[$i+1]} -h ${NODE[$i+2]} -p ${NODE[$i+3]} && echo plpgsql ajouté sur ${NODE[$i+1]} - ${NODE[$i+2]}

EOF
    if [[ x$LANG = xfr* ]]; then
	cat <<EOF
# Suppression du schéma
# Avant de supprimer le schéma, s'assurer qu'il n'y a plus d'informations de réplication
echo "Uninstall Node et drop schema sur ${NODE[$i+1]} - ${NODE[$i+2]}..."
EOF
    else
	cat <<EOF
# We drop slon specific schema, after having put objects in their original state
echo "Uninstalling node and dropping schema on ${NODE[$i+1]} - ${NODE[$i+2]}..."
EOF
    fi
    cat <<EOF
${psql_exec} ${NODE[$i+1]} -U ${SLONY_USER} -h ${NODE[$i+2]} -p ${NODE[$i+3]} -c 'select "_$CLUSTERNAME".uninstallnode( );'
$psql_exec ${NODE[$i+1]} -U ${SLONY_USER} -h ${NODE[$i+2]} -p ${NODE[$i+3]} -c 'drop schema "_$CLUSTERNAME" cascade;' && echo "OK"
###

EOF
    done
fi
# FIXME which sur les binaires et $TRUC
# FIXME utiliser des fichiers templates et faire un sed /@@CLUSTERNAME@@/$CLUSTERNAME/

# Création du script de construction de la réplication
## EN: The script
cat <<EOF

# Script slonik d'initialisation des schémas
## EN: Slonik script for initialising replication
${SLON_BIN}/slonik <<_EOF_
    # Fichier contenant les informations de connexions et
    # l'identification des noeuds de la replication
    ## EN: Preamble file contains all useful connexions information
    INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

EOF
# FIXME which sur les binaires et $TRUC
# FIXME utiliser des fichiers templates et faire un sed /@@CLUSTERNAME@@/$CLUSTERNAME/

# Store node ne peut intervenir qu'une seule fois
## EN: Only one init by replication, only one store node by node
# i.e., if $SET specified, this part is not done.
if [ $SET -eq 0 ]; then
    cat <<EOF

    #--
    # Init the first node.  This creates the schema _$INSTANCE 
    # containing all replication system specific database objects.
    # Premier noeud. On crée le schéma _$INSTANCE. Il contient toutes les
    # informations nécessaires à la réplication.
    #--
    try{
    	init cluster ( id=$MASTERNODE, comment = '$INSTANCE : ${NODE[1]} - ${NODE[2]} - ${NODE[3]}');
    }
    on error {
	echo 'Cluster $MASTERNODE : ko' ;
	exit 1;
	}
    on success { echo 'Cluster $MASTERNODE : OK' ; }

    # Les autres noeuds de la réplication
    # The other nodes.
EOF
	for (( i=5 ; i <= taille_nod ; i+=4 )); do
		SLAVENODE=${NODE[$i]}
		SLAVEBASE=${NODE[$i+1]}
		SLAVEHOST=${NODE[$i+2]}
		SLAVEPORT=${NODE[$i+3]}

		cat <<EOF

   #--
   # Create the node $SLAVENODE (slave) and tell the 2 nodes how to connect to
   # each other and how they should listen for events.
   # On indique à chaque noeud le chemin pour atteindre les autres.
   #--

   try{
       store node (id = $SLAVENODE,
        EVENT NODE = $MASTERNODE,
        comment = 'DB $SLAVEBASE - Host $SLAVEHOST - Cluster $CLUSTERNAME');
    }
    on error {
	echo 'Store node $SLAVENODE ko';
	exit 1;
	}
    on success {
	echo 'Store node $SLAVENODE OK';
	}

EOF
	done
    for (( i=1 ; i <= taille_nod ; i+=4 )); do
	SLAVENODE=${NODE[$i]}
        SLAVEBASE=${NODE[$i+1]}
        SLAVEHOST=${NODE[$i+2]}
        SLAVEPORT=${NODE[$i+3]}

	#Liens entre un noeud et les autres (numéros inférieurs)
	# How each node is linked to the others
        for (( j=1 ; j <= taille_nod ; j+=4 )); do
		if [ $i -ne $j ]; then
			NODE2=${NODE[$j]}
			BASE2=${NODE[$j+1]}
			HOST2=${NODE[$j+2]}
			PORT2=${NODE[$j+3]}

			cat <<EOF
    store path (server = $SLAVENODE, client = $NODE2, conninfo='dbname=$SLAVEBASE host=$SLAVEHOST port=$SLAVEPORT user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}');
EOF
		    fi
		done
        cat <<EOF

EOF
    done

    GREP_SET="grep \"\b$INSTANCE\b\" $SLON_ETC/relations.h | grep -v \"^#\" | awk '{print \$2}' | sort -u"
else
    GREP_SET="echo $SET"
fi


#Pour tous les sets de réplication
# For every set in the replication
for SETID in `eval $GREP_SET` ; do
#	echo "relation $SETID"
	relation $SETID
	cat <<EOF

    #--
    # Slony-I organizes tables into sets.  The smallest unit a node can
    # subscribe is a set. The master or origin of the set is node $MASTER.
    # Les tables sont organisées au sein de set, plus petite unité de réplication.
    # L'origine du set est $MASTER.
    #--
    try{
        create set (id=$SETID, origin=$MASTER, comment='Tables in ${NODE[2]}');

	# Tables
EOF

       if [ $SET -eq 0 ]; then
            TABLEID=1
        else
            # Récupération du dernier numéro utilisé dans la numérotation des tables
	    # We get the last used tab_id.
            TABLEID=`psql ${NODE[2]} -U ${SLONY_USER} -p${NODE[4]} -h${NODE[3]} -t -c "select max(tab_id) +1 from \"_${INSTANCE}\".sl_table ;"| awk '{print $1}'`
        fi

	for table in `$PG/bin/psql -t -h $MASTERHOST -p$MASTERPORT ${NODE[2]} -U ${SLONY_USER} -c "select schemaname||'.'||tablename from pg_tables where schemaname= 'public' order by tablename asc;"`
		do
		cat <<EOF
	set add table (set id=$SETID, origin=$MASTER, id=$TABLEID, fully qualified name = '$table', comment='table $table');
EOF
		TABLEID=$(($TABLEID +1))
		done

		cat <<EOF

	# Sequences
EOF

        if [ $SET -eq 0 ]; then
            SEQID=1
        else
            # Récupération du dernier numéro utilisé dans la numérotation des séquences
	    # We get the last used seq_id
            SEQID=`psql ${NODE[2]} -U ${SLONY_USER} -p${NODE[4]} -h${NODE[3]} -t -c "select max(seq_id) +1 from \"_${INSTANCE}\".sl_sequence;"| awk '{print $1}'`
        fi

	for SEQ in `$PG/bin/psql -t -h $MASTERHOST -p$MASTERPORT ${NODE[2]} -U ${SLONY_USER} -c "select ns.nspname||'.'||cl.relname from pg_class cl inner join pg_namespace ns on ns.oid=cl.relnamespace where nspname='public' and relkind='S' order by cl.relname asc;"`
		do
			cat <<EOF
        set add sequence (set id=$SETID, origin=$MASTER, id=$SEQID, fully qualified name = '$SEQ', comment='sequence $SEQ');
EOF
			SEQID=$(($SEQID +1))
		done

	cat <<EOF
    }
    on error {
	echo 'Creation Set : ko';
	exit 1;
	}
    on success {
	echo 'Creation Set : OK';
	}
EOF
done


    cat <<EOF
    exit 0;
_EOF_

if [ \$? -ne 0 ]; then
    if [[ x\$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
    else
	echo "An error occured."
    fi
    exit 1
fi

# Demarrage de la replication
# Tous les processus sont démarrés sur la machine sur laquelle est lancé
# le script
## EN: We start daamons. All on the same machine, which is
# the one on which that script is executed.
EOF
    for (( i=1 ; i <= taille_nod ; i+=4 )); do
        cat <<EOF
${SLON_BIN}/slon -f $SLON_ETC/slon.cfg ${INSTANCE} "dbname=${NODE[$i+1]} host=${NODE[$i+2]} port=${NODE[$i+3]} user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}" >${SLON_LOG}/${CLUSTERNAME}_${NODE[$i+1]}_${NODE[$i]}.log 2>&1 &
EOF
if [[ x$LANG = xfr* ]]; then
    cat <<EOF
echo "Démon slon pour ${NODE[$i+1]} - ${NODE[$i+2]} demarré sur `hostname`"
EOF
else
    cat <<EOF
echo "Slon daemon for ${NODE[$i+1]} - ${NODE[$i+2]} started on `hostname`"
EOF
fi

    done

cat <<EOF

# Il faut maintenant informer les bases de la réplication
## EN: And now, subscription
EOF

#Pour tous les sets de réplication
# For every set
    for SETID in `eval $GREP_SET` ; do
	relation $SETID
	for (( i=1 ; i <= taille_rel ; i+=2 )); do
	    MASTERNODE=${REL[$i]}
	    SLAVENODE=${REL[$i+1]}
	    mtr=${INDEX[${REL[$i]}]}
	    slv=${INDEX[${REL[$i+1]}]}
	    if [[ x$LANG = xfr* ]]; then
		cat <<EOF

echo "Souscription Set $SETID par $SLAVENODE"
EOF
	    else
		cat <<EOF

echo "$SLAVENODE subscribes to Set $SETID"
EOF
	    fi
	    if [ $MASTERNODE -ne $MASTER ]; then
		cat <<EOF
while [ 1 ] ; do
	if [ x\`$PG/bin/psql -t ${NODE[$mtr+1]} -U ${SLONY_USER} -h ${NODE[$mtr+2]} -p ${NODE[$mtr+3]} -c "select sub_active from _$INSTANCE.sl_subscribe where sub_set=$SETID and sub_receiver=${NODE[$mtr]}" |awk '{print \$1}' |head -n 1\` = "xt" ]; then
		echo "OK"
		break;
	else
		echo -n "."
		sleep 5
	fi
done

EOF
			fi

			cat <<EOF
$SLON_BIN/slonik <<_EOF_
    # ----
    # <preamble> file 
    # ----
    INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

    # ----
    # Node $SLAVENODE subscribes set $SETID
    # ----
    try{
    	subscribe set ( id = $SETID, provider = $MASTERNODE, receiver = $SLAVENODE, forward = yes);
    }
    on error {
	echo 'Souscription ko';
	exit 1;
	}
    on success {
	echo 'Souscription OK';
	}
_EOF_

EOF
		done
	done

cat <<EOF

if [ \$? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Une erreur est survenue."
    else
	echo "An error occured."
    fi
    exit 1
fi
exit 0

EOF

exit 0
