#!/bin/bash
# Auteur : Stéphane Schildknecht
# 2007-03-22
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# create_struct.sh
# Script de copie des structures du maîtres vers les autres
# noeuds de la réplication
## EN: Propagation of database schema to slaves
# Be careful it will drop any existing database.

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/
#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo -e "        Script de copie des structures en vue d'une réplication"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo -e "        Copy database schema in order to settle a replication"
  echo "  Options :"
  echo "   -h|--help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:h -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ;
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
	*)
                echo "Warning!";
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x"  ]; then
    slhelp;
    exit 1
fi

CLUSTERNAME=$INSTANCE

# Constitution d'un tableau à deux dimensions.
# Node array
node $INSTANCE

MASTERNODE=${NODE[1]} # On ne peut pas faire plus arbitraire :-(
MASTERBASE=${NODE[2]}
MASTERHOST=${NODE[3]}
MASTERPORT=${NODE[4]}
#MASTERNODE=${NODE[${INDEX[$MASTER]}]}   #Numéro du noeud
#MASTERBASE=${NODE[${INDEX[$MASTER]}+1]} #Base
#MASTERHOST=${NODE[${INDEX[$MASTER]}+2]} #Host
#MASTERPORT=${NODE[${INDEX[$MASTER]}+3]} #Port

# FIXME OWNER
OWNER=$SLONY_USER

# Suppression des bases de données sur les esclaves
# We drop slave's DB
for (( i=4 ; i < taille_nod ; i+=4 )); do
	echo ###
	echo "Base ${NODE[$i+2]} sur ${NODE[$i+3]}"
	$PG/bin/dropdb -U ${SLONY_USER} ${NODE[$i+2]} -h ${NODE[$i+3]} -p ${NODE[$i+4]} && echo "Supprimée"

	# Copie et création des utilisateurs
	# Users ?
#	$PG/bin/pg_dumpall -g -U ${SLONY_USER} -h $MASTERHOST -p $MASTERPORT | grep -v 'ROLE postgres' | $PG/bin/psql -U ${SLONY_USER} postgres -h ${NODE[$i+3]} -p ${NODE[$i+4]}
#	echo "Rôles ajoutés"

	# Création de la base
	# We recreate the DB
	$PG/bin/createdb -U ${SLONY_USER} ${NODE[$i+2]} -O $OWNER -h ${NODE[$i+3]} -p ${NODE[$i+4]} && echo "créée"

	# Création de la structure
	# Dump of schema
#	echo "$PG/bin/pg_dump -s -c -N _$INSTANCE -U ${SLONY_USER} $MASTERBASE -h $MASTERHOST -p $MASTERPORT | $PG/bin/psql -U ${SLONY_USER} ${NODE[$i+2]} -h ${NODE[$i+3]} -p ${NODE[$i+4]}"
	$PG/bin/pg_dump -s -c -N _$INSTANCE -U ${SLONY_USER} $MASTERBASE -h $MASTERHOST -p $MASTERPORT | $PG/bin/psql -U ${SLONY_USER} ${NODE[$i+2]} -h ${NODE[$i+3]} -p ${NODE[$i+4]}
#	PGUSER=${SLONY_USER} PGHOST=$MASTERHOST PGPORT=$MASTERPORT $SLON_OUTILS/slony1_extract_schema.sh $MASTERBASE $INSTANCE temp$INSTANCE | $PG/bin/psql -U ${SLONY_USER} ${NODE[$i+2]} -h ${NODE[$i+3]} -p ${NODE[$i+4]}
	echo "Base créée"
	echo ###
done

exit 0
