#!/bin/bash
# Auteur : Stephane Schildknecht
# 2007-01-12
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# slony_addnode.sh
# Script d'ajout d'un noeud à une réplication
## EN: Adding a node to a replication network


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Script d'ajout d'un noeud à une réplication"
  echo -e "        Les fichiers de préambule, bases.h et relations.h, doivent être à jour"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -n|--node             Le numéro du noeud"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Adding a node to a replication network"
  echo -e "        bases.h, relations.h and preamble files have to be up-to-date"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -n|--node             The node number"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:n: -l help,cluster:,node: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
NODE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -n|--node) shift ;
                NODE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
                echo "Warning!";
		slhelp ;
                exit 1
                ;;
  esac
  shift
done

if [ x"$INSTANCE" = "x" -o x"$NODE" = "x" ]; then
    slhelp;
    exit 1
fi

if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h ] ; then
    if [[ x$LANG = xfr* ]]; then
        echo "Fichier ${SLON_ETC}/bases.h ou ${SLON_ETC}/relations.h introuvable."
        echo "Merci de vérifier votre installation."
    else
        echo "Can't find ${SLON_ETC}/bases.h or ${SLON_ETC}/relations.h."
        echo "Please verify your settings."
    fi
    exit 1;
fi

NODENUM=$NODE

# Reconstruction des informations concernant les noeuds
## EN: node array
node $INSTANCE

SLAVENODE=$NODENUM
SLAVEBASE=${NODE[${INDEX[$NODENUM]}+1]}
SLAVEHOST=${NODE[${INDEX[$NODENUM]}+2]}
SLAVEPORT=${NODE[${INDEX[$NODENUM]}+3]}

## FR :
# 1. Ajout du PL/PgSQL
# 2. Suppression de toute information Slony éventuellement présente
# 3. Recréation du fichier de préambule.
## EN:
# 1. We add PL/pgSQL 
# 2. We drop any existing slony information
# 3. We recreate the preamble file

cat <<EOF
#!/bin/bash

# plpgsql
$PG/bin/createlang plpgsql -U ${SLONY_USER} $SLAVEBASE -h $SLAVEHOST -p $SLAVEPORT

# S'il reste des traces d'une réplication précédente, on les supprime
# Uninstall Node, so that there is any left information
${psql_exec} -U ${SLONY_USER} $SLAVEBASE -h $SLAVEHOST -p $SLAVEPORT -c 'select _$INSTANCE.uninstallnode( );'

# Purge du schéma de réplication
# Drop slony schema, if any
${psql_exec} -U ${SLONY_USER} $SLAVEBASE -h $SLAVEHOST -p $SLAVEPORT -c 'drop schema "_$INSTANCE" cascade;' && echo "Schema supprime sur $SLAVEBASE - $SLAVEHOST"

# Le fichier de préambule était-il à jour ?
# Recreating preamble file
${SLON_OUTILS}/create_preamble.sh -c $INSTANCE

if [ \$? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "N'a pas pu créer le fichier de préambule."
    else
        echo "Can't create preamble file."
    fi
    exit 1
fi

EOF

# Arbitrairement, on effectue le store node par rapport au premier set de la réplication
# si le noeud à ajouter en fait partie
## EN: We store the node node regarding the first set of replication, if
# the node is part of that set.
cat <<EOF
# Ajout de l'esclave à la réplication
## EN: Adding the slave
${SLON_BIN}/slonik <<_EOF_
    	#--
    	# <preamble> file
    	#--
    	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

EOF
  
STORE=0
GREP_SET="grep \"\b$INSTANCE\b\" $SLON_ETC/relations.h | grep -v \"^#\" | awk '{print \$2}' | sort -u"
for SETID in `eval $GREP_SET` ; do
    relation $SETID

    for (( j=1 ; j <= taille_rel ; j+=2 )); do
	if [ ${REL[$j+1]} -eq $SLAVENODE ]; then
	    if [ $STORE -eq 0 ]; then

		cat <<EOF
	echo 'Drop node $SLAVENODE' ;
	try {
	    drop node ( id = $SLAVENODE, EVENT NODE = $MASTER );
	}
	on success{ echo 'OK';}
	on error{ echo 'no $SLAVENODE';}
	echo 'Store node $SLAVENODE';
        try{
           store node (id = $SLAVENODE,
                       EVENT NODE = $MASTER,
                       comment = 'Node $SLAVENODE - Base $SLAVEBASE - Host $SLAVEHOST - Cluster $INSTANCE');
        }
        on error {
	    echo 'ko';
	    exit 1;
	    }
        on success {echo 'OK';}

EOF

		#Liens entre un noeud et les autres
		## EN: Creating links between nodes
		for (( k=1 ; k <= taille_nod ; k+=4 )); do
		    NODE2=${NODE[$k]}
		    BASE2=${NODE[$k+1]}
		    HOST2=${NODE[$k+2]}
		    PORT2=${NODE[$k+3]}
		
		    if [ $NODE2 -ne $SLAVENODE ]; then
			cat <<EOF
        store path (server = $NODE2, client = $SLAVENODE, conninfo='dbname=$BASE2 host=$HOST2 port=$PORT2 user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}');
        store path (server = $SLAVENODE, client = $NODE2, conninfo='dbname=$SLAVEBASE host=$SLAVEHOST port=$SLAVEPORT user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}');
EOF
		    fi
		done

cat <<EOF
_EOF_

# Demarrage de la replication pour le nouvel esclave
## EN: Starting slon daemons for new node
${SLON_BIN}/slon -f $SLON_ETC/slon.cfg ${INSTANCE} "dbname=$SLAVEBASE host=$SLAVEHOST port=$SLAVEPORT user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}" >${SLON_LOG}/${INSTANCE}_${SLAVEBASE}_${SLAVENODE}.log 2>&1 &
echo "Slony esclave demarre sur `hostname` : $SLAVENODE"

EOF

# C'est fait, le noeud est créé.
## EN: Node is up and running
		STORE=1
	    fi

# Souscriptions...
## EN: Let's subscribe
#for (( j=1 ; j <= taille_rel ; j+=2 )); do
#    if [ ${REL[$j+1]} -eq $SLAVENODE ]; then
        let mtr=${INDEX[${REL[$j]}]}     #MAITRE
        let slv=${INDEX[${REL[$j+1]}]}  #ESCLAVE

        if [ ${REL[$j]} -ne ${MASTER} ]; then
            cat <<EOF

while [ 1 ] ; do
    if [ x\`$PG/bin/psql -t ${NODE[$mtr+1]} -U ${SLONY_USER} -h ${NODE[$mtr+2]} -p ${NODE[$mtr+3]} -c "select sub_active from _$INSTANCE.sl_subscribe where sub_receiver=${NODE[$mtr]} and sub_set=$SETID" |awk '{print \$1}' |head -n 1\` = "xt" ]; then
        echo "Set souscrit."
        break;
    else
	echo -n "."
        sleep 5
    fi
done

EOF

	fi

cat <<EOF
# Il faut maintenant informer les bases de la réplication
## EN: Let's subscribe
echo "Souscription Set $SETID :"
$SLON_BIN/slonik <<_EOF_
         # ----
         # Preamble file 
         # ----
         INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

         # ----
         # Node $SLAVENODE subscribes set $SETID
         # ----
	 echo 'Node $SLAVENODE subscribes set $SETID on ${REL[$j]}:';
         try{
            subscribe set ( id = $SETID, provider = ${REL[$j]}, receiver = $SLAVENODE, forward = yes);
         }
         on error {
	    echo 'ko';
	    exit 1;
	   }
         on success {echo 'OK';}
         #sleep (seconds = 300);
_EOF_
EOF
	    fi
	done
    done

exit 0

