#!/bin/bash
# Auteur : Stephane Schildknecht
# Rev 20070419
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20080716 Stephane Schildknecht
#    Correction pour prendre en compte les numéros réels
#    des noeuds
#

# slony_addobj.sh
# Script d'ajout de tables/séquences à une réplication
## EN: Adding objects to a replication


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Script d'ajout d'objets à une réplication en cours"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set              Le numéro du set"
  echo "   -f|--file             Le fichier contenant les noms des objets"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Adding objects to a running replication"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -s|--set              The set number"
  echo "   -f|--file             The file containing objects' name"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s:f:h -l help,cluster:,set:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h -o ! -e ${SLON_ETC}/$INSTANCE.preamble ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Fichier ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h ou ${SLON_ETC}/$INSTANCE.preamble introuvable."
        echo "Merci de vérifier votre installation."
    else
        echo "Can't find ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h or ${SLON_ETC}/$INSTANCE.preamble."
        echo "Please verify your settings."
    fi
    exit 1
fi

# Création du tableau d'informations sur les noeuds
## EN: nodes array
node $INSTANCE ;

# Création du tableau de relations
## EN: relations array
relation $SET ;

# Le fichier contient les noms des tables et séquences à ajouter.
## EN: FILE contains names of the objects to add
. $FILE

CLUSTERID=${MASTER}

# Récupération du dernier numéro utilisé dans la numérotation des tables
## EN: What is the max tab_id in replication?
# FIXME : We may have a different max(tab_id) in another node, in case of
# crossing sets of replication
TABLEID=`psql ${NODE[2]} -U ${SLONY_USER} -p${NODE[4]} -h${NODE[3]} -t -c "select max(tab_id) from \"_${INSTANCE}\".sl_table;"| awk '{print $1}'`

# Récupération du dernier numéro utilisé dans la numérotation des séquences
## EN: What is the max seq_id in replication?
# FIXME : We may have a different max(seq_id) in another node, in case of
# crossing sets of replication
SEQID=`psql ${NODE[2]} -U ${SLONY_USER} -p${NODE[4]} -h${NODE[3]} -t -c "select max(seq_id) from \"_${INSTANCE}\".sl_sequence;"| awk '{print $1}'`

# Construction de la liste des tables
## EN: Let's build the set add table script.
ADDTABLES=""
let "tnum=$TABLEID+1"
for table in `echo $TAB`; do
	ADDTABLES="$ADDTABLES
       	set add table (set id = 99, origin = $CLUSTERID,
       	               id = $tnum, fully qualified name = '$table',
       	               comment = 'Table $table');
	"
      	let "tnum=tnum+1"
done

ADDSEQ=""
let "snum=$SEQID+1"
for seq in `echo $SEQ`; do
        ADDSEQ="$ADDSEQ
        set add sequence (set id = 99, origin = $CLUSTERID,
                          id = $snum, fully qualified name = '$seq',
                          comment = 'Sequence $seq');
        "
        let "snum=snum+1"
done

cat <<EOF
#!/bin/bash

. $SLON_ETC/fonctions.sh

${SLON_BIN}/slonik <<_EOF_
    	#--
    	# <preamble> file
    	#--
    	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
    
	echo 'Set creation: ';
        try{
           create set (id=99, origin=$CLUSTERID, comment='Temp set');

           # Tables
	   ${ADDTABLES:-echo 'No table specified';}

           # Sequences
	   ${ADDSEQ:-echo 'No sequence specified';}
        }
        on error {
	    echo 'ko';
	    exit 1;
	}
        on success { echo 'OK'; exit 0; }

_EOF_

if [ \$? -ne 0 ]; then
    exit_on_error "Create set"
fi
EOF

# Pour tous les noeuds ayant souscrits au premier set
# le noeud souscrit le nouveau set. Lorsque tous les noeuds ont souscrits, 
# il est alors possible de fusionner les deux sets.
## EN: We have to subscribe every node that has subscribed to 
# destination set.
for (( i=1 ; i <= taille_rel ; i+=2 )); do
        MASTERNODE=${REL[$i]}
        SLAVENODE=${REL[$i+1]}
        mtr=${INDEX[${REL[$i]}]}
        slv=${INDEX[${REL[$i+1]}]}
        cat <<EOF

echo "$SLAVENODE subscribes set 99:"
EOF
    if [ $MASTERNODE -ne $MASTER ]; then
	cat <<EOF

while [ 1 ] ; do
    if [ x\`$PG/bin/psql -t ${NODE[$mtr+1]} -U ${SLONY_USER} -h ${NODE[$mtr+2]} -p ${NODE[$mtr+3]} -c "select sub_active from _$INSTANCE.sl_subscribe where sub_set=99 and sub_receiver=${NODE[$mtr]}" |awk '{print \$1}' |head -n 1\` = "xt" ]; then
	echo "OK";
	break;
    else
	echo -n "."
	sleep 10s
    fi
done

EOF
    fi
    cat <<EOF

$SLON_BIN/slonik <<_EOF_
         # ----
         # Preamble file
         # ----
         INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

         # ----
         # Node $SLAVENODE subscribes set 99
         # ----
	 echo 'Node $SLAVENODE subscribes set 99:';
         try{
            subscribe set ( id = 99, provider = ${REL[$i]}, receiver = $SLAVENODE, forward = yes);
         }
         on error {
	    echo 'ko';
	    exit 1;
	    }
         on success {echo 'OK';}
         SYNC (ID = ${REL[$i]});
         WAIT FOR EVENT (ORIGIN = ${REL[$i]}, CONFIRMED = $SLAVENODE, WAIT ON = ${REL[$i]});
	 exit 0;
_EOF_

if [ \$? -ne 0 ]; then
    exit_on_error "Subscribe set";
fi
EOF
done


cat <<EOF
## EN: Arbitrary timing
sleep 120

# Il faut maintenant fusionner les deux sets
## Let's merge sets
echo "Merge sets:"
$SLON_BIN/slonik <<_EOF_
         # ----
         # Preamble file
         # ----
         INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

    	#--
    	# Merge sets 
    	#--
	echo 'merge: ';
	try{
    	    MERGE SET ( 
	      ID = $SET, 
	      ADD ID = 99,
              ORIGIN = $CLUSTERID );
	}
	on error {
	    echo 'ko' ;
	    exit 1;
	}
        on success { echo 'OK' ; exit 0; }
     
_EOF_

if [ \$? -ne 0 ]; then
    exit_on_error "Merge set";
fi

exit 0
EOF
exit 0
