#!/bin/bash
# REV dalibo 20070417
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# slony_ctl.sh
## FR : Contrôle de la réplication
## EN: Managing replication

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
    echo "$0"
    echo ""
    echo "Usage : $0 *options*"
    echo "  Options :"
    echo "   --help			    Afficher ce message"
    echo "   -c|--cluster		    Le nom de l'instance de réplication"
    echo "   start|stop|restart|status|clean  L'action à effectuer"
    echo ""
else
    echo "$0"
    echo ""
    echo "Usage: $0 *options*"
    echo "  Options:"
    echo "   --help			    Print this help"
    echo "   -c|--cluster		    The replication instance name"
    echo "   start|stop|restart|status|clean  The action"
    echo ""
fi
}

stop_slon() {
    if [[ x$LANG = xfr* ]]; then
	echo "Arrêt réplication $CLUSTERNAME..."
    else
	echo "Stopping $CLUSTERNAME replication..."
    fi
  
    for processus in `ps auxw | grep "\bslon\b" | grep "\b$CLUSTERNAME\b" | grep -v sh | awk '{print $2}'`
    do
	kill -15 ${processus}
    done
    if [[ x$LANG = xfr* ]]; then
        echo "Processus slon supprimes sur `hostname`"
    else
	echo "Slon daemons stopped on `hostname`"
    fi
}

start_slon() {
    if [[ x$LANG = xfr* ]]; then
	echo "Démarrage réplication $CLUSTERNAME..."
    else
	echo "Starting $CLUSTERNAME replication..."
    fi

    for (( i=1 ; i <= taille_nod ; i+=4 )); do
	${SLON_BIN}/slon -f $SLON_ETC/slon.cfg ${CLUSTERNAME} "dbname=${NODE[$i+1]} host=${NODE[$i+2]} port=${NODE[$i+3]} user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}" >>${SLON_LOG}/${CLUSTERNAME}_${NODE[$i+1]}_${NODE[$i]}.log 2>&1 &
	if [ $? -eq 0 ] ; then
	    if [[ x$LANG = xfr* ]]; then
	    	echo "Slony demarré sur `hostname` : ${NODE[$i]}"
	    else
		echo "Slon daemons started on `hostname` : ${NODE[$i]}"
	    fi
	else
	    if [[ x$LANG = xfr* ]]; then
		echo "Une erreur est survenue."
		echo "Consulter ${SLON_LOG}/${CLUSTERNAME}_${NODE[$i+1]}_${NODE[$i]}.log pour les détails."
	    else
		echo "An error occured."
		echo "See ${SLON_LOG}/${CLUSTERNAME}_${NODE[$i+1]}_${NODE[$i]}.log for details."
	    fi
	    exit 1
	fi
  done
}

clean_sl(){
    if [[ x$LANG = xfr* ]]; then
        echo "Nettoyage des tables sl_nodelock..."
    else
	echo "Cleaning sl_nodelock..."
    fi
    for (( i=1 ; i <= taille_nod ; i+=4 )); do
	psql -U $SLONY_USER ${NODE[$i+1]} -h ${NODE[$i+2]} -p ${NODE[$i+3]} -c "delete from _$CLUSTERNAME.sl_nodelock;"
        if [[ x$LANG = xfr* ]]; then
	    echo " Table nettoyée sur : ${NODE[$i]}, ${NODE[$i+2]}"
	else
	    echo " Cleaned on ${NODE[$i]}, ${NODE[$i+2]}"
	fi
    done

}

TEMP=`getopt -n $0 -o c:h -l help,cluster:,start,stop,restart,clean,status -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
		ACTION="$1"
                break
                ;;
        *)
		echo "Warning!";
		slhelp ;
               exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp ;
    exit 1
fi

# Récupération des informations sur les noeuds
## EN: nodes array
relbase_miss
if [ $? -eq 1 ]; then
    exit 1
fi
node $INSTANCE

CLUSTERNAME=$INSTANCE

case $ACTION in
  start)
        start_slon
	exit 0
        ;;
  stop)
	stop_slon
	exit 0
	;;
  restart)
	if [[ x$LANG = xfr* ]]; then
            echo -n "Redémarrage réplication $CLUSTERNAME : "
	else
	    echo -n "Restarting $CLUSTERNAME:"
	fi
	stop_slon
	clean_sl
	start_slon
	exit 0
        ;;
  status)
	if [[ x$LANG = xfr* ]]; then
	    echo "Etat de la réplication $CLUSTERNAME : "
	else
	    echo "$CLUSTERNAME replication status: "
	fi
	${SLON_OUTILS}/slony_repstat.sh -c $CLUSTERNAME
	exit 0
	;;
  clean)
	if [[ x$LANG = xfr* ]]; then
	    echo "Nettoyage des tables sl_nodelock :"
	else
	    echo "Cleaning sl_nodelock: "
	fi
	clean_sl
	exit 0
	;;
  *)
        # Print help
	slhelp
        exit 1
        ;;
esac

exit 0
