#!/bin/bash
# Auteur : Stephane Schildknecht
# 2009/04/19

# slony_dropobj.sh
# Script de suppression de tables/séquences d'une réplication
## EN: Dropping objects from a replication


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Script de suppression d'objets à une réplication"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -f|--file             Le fichier contenant les noms des objets"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Dropping objects from a running replication"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -f|--file             The file containing objects' name"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:f:h -l help,cluster:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
               exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h -o ! -e ${SLON_ETC}/$INSTANCE.preamble ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Fichier ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h ou ${SLON_ETC}/$INSTANCE.preamble introuvable."
        echo "Merci de vérifier votre installation."
    else
        echo "Can't find ${SLON_ETC}/bases.h, ${SLON_ETC}/relations.h or ${SLON_ETC}/$INSTANCE.preamble."
        echo "Please verify your settings."
    fi
    exit 1
fi

# Création du tableau d'informations sur les noeuds
## EN: nodes array
node $INSTANCE ;

# Le fichier contient les noms des tables et séquences à supprimer.
## EN: FILE contains names of the objects to drop
. $FILE

## EN: We have to know the number of the originating node
## Is there a better way than scanning all sets to get master node?
## Or to query every node to until we find the object?
DROPTABLES=""
MASTERNODE=0
for table in `echo $TAB`; do
## First, we get the id of the table and the master node for the set the table
## belongs to
    for (( k=1 ; k <= taille_nod ; k+=4 )); do
	NODE2=${NODE[$k]}
        BASE2=${NODE[$k+1]}
        HOST2=${NODE[$k+2]}
        PORT2=${NODE[$k+3]}

	TABLEID=`psql $BASE2 -U ${SLONY_USER} -p$PORT2 -h$HOST2 -t -c "select tab_id from \"_${INSTANCE}\".sl_table where tab_relname='${table##*.}' and tab_nspname='${table%%.*}';"| awk '{print $1}'`

	if [ ! -z $TABLEID ]; then
	    MASTERNODE=`psql $BASE2 -U ${SLONY_USER} -p$PORT2 -h$HOST2 -t -c "select set_origin from \"_${INSTANCE}\".sl_set where set_id = (select tab_set from \"_${INSTANCE}\".sl_table where tab_id=$TABLEID);"| awk '{print $1}'`
	    DROPTABLES="$DROPTABLES
	    set drop table ( origin = $MASTERNODE, id = $TABLEID);"
	    break;
	fi
    done # for (( k=1 ; k <= taille_nod ; k+=4 )); do
done # for table in `echo $TAB`; do

# La même chose pour les séquences
## We do the same for sequences
DROPSEQ=""
MASTERNODE=0
for seq in `echo $SEQ`; do
## Same here... I wish I don't have to parse all nodes...
    for (( k=1 ; k <= taille_nod ; k+=4 )); do
        NODE2=${NODE[$k]}
        BASE2=${NODE[$k+1]}
        HOST2=${NODE[$k+2]}
        PORT2=${NODE[$k+3]}

	SEQID=`psql $BASE2 -U ${SLONY_USER} -p$PORT2 -h$HOST2 -t -c "select seq_id from \"_${INSTANCE}\".sl_sequence where seq_relname='${seq##*.}' and seq_nspname='${seq%%.*}';"| awk '{print $1}'`

	if [ ! -z $SEQID ]; then
	    MASTERNODE=`psql $BASE2 -U ${SLONY_USER} -p$PORT2 -h$HOST2 -t -c "select set_origin from \"_${INSTANCE}\".sl_set where set_id = (select seq_set from \"_${INSTANCE}\".sl_sequence where seq_id=$SEQID);"| awk '{print $1}'`
            DROPSEQ="$DROPSEQ
	    set drop sequence ( origin = $MASTERNODE, id = $SEQID);"
	    break;
	fi
    done # for (( k=1 ; k <= taille_nod ; k+=4 )); do
done # for seq in `echo $SEQ`; do

cat <<EOF
#!/bin/bash

${SLON_BIN}/slonik <<_EOF_
    	#--
    	# <preamble> file
    	#--
    	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
    
	echo 'Table suppression: ';
        try{
           # Tables
	   ${DROPTABLES:-echo 'No table specified';}
	}
	on error {
	            echo 'ko';
		    exit 1;
	}
	on success { echo 'OK'; }

	echo 'Sequence suppression: ';
	try{
           # Sequences
	   ${DROPSEQ:-echo 'No sequence specified';}
        }
        on error {
	    echo 'ko';
	    exit 1;
	}
        on success { echo 'OK'; }

_EOF_
EOF

exit 0
