#!/bin/bash
# Auteur : Stephane Schildknecht
# Rev 20090424
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#  - 20090429 
#    Bug in testing existence of preamble file
#    per report of Bastian Voigt

# slony_execute.sh
# Script de propagation de scripts DDL
## EN: Propagating DDL scripts

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Options :"
  echo "   -h|--help             Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set              Le numéro du set"
  echo "   -f|--file             Le fichier contenant le script à exécuter"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Options:"
  echo "   -h|--help             Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -s|--set              The set number"
  echo "   -f|--file             The DDL script"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s:f:h -l help,cluster:,set:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        -f|--file) shift ;
                FILE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
               exit 1
                ;;
  esac
  shift
done

# FIXME We could avoid set number when replication involves a single one
if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$FILE" = "x" ]; then
    slhelp;
    exit 1
fi

if [ ! -e $FILE ]; then
    if [[ x$LANG = xfr* ]]; then
	echo "Fichier $FILE introuvable."
    else
	echo "Could not find $FILE."
    fi
    exit 1
fi

# On utilise le tableau des relations entre noeuds
## relations array
# Les fichiers existent-ils ?
## EN: Can we find inclusion files?

relbase_miss
if [ $? -ne 0 ]; then
    exit 1
fi

preamble_miss $INSTANCE
if [ $? -ne 0 ]; then
    exit 1
fi

relation $SET

${SLON_BIN}/slonik <<_EOF_
    	#--
    	# <preamble> file
    	#--
    	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
    
    	#--
    	# Mise à jours des schémas
	# Schema modification
    	#--
	echo 'Propagation script : ' ;
	try{
    	    EXECUTE SCRIPT ( 
	      SET ID = $SET, 
	      FILENAME = '$FILE', EVENT NODE = $MASTER );
	}
	on error {
	    echo 'ko' ;
	    exit 1;
	    }
        on success { echo 'OK' ; }
     
_EOF_

if [ $? -ne 0 ]; then
    if [[ x$LANG = xfr* ]]; then
        echo "Une erreur est survenue."
    else
        echo "An error occured."
    fi
    exit 1
fi
exit 0
 
