#!/bin/bash
# Auteur : Stephane Schildknecht
# 2007-01-12
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
# - 200800401 SAS
#    Lors de la suppression d'un noeud vérification qu'il n'a plus d'esclave
#    Ses esclaves souscrivent à son maître

# slony_fail.sh
## FR :  Script de bascule lorsqu'un maître tombe de manière
# incontrôlée.
# Le maître est supprimé de la réplication, l'esclave prend
# la relève
# Si le noeud n'a pas d'esclave, il est supprimé
# Il s'agit de supprimer le noeud donné en paramètre et d'utiliser son premier esclave
# ou BACKUP s'il est fourni

## EN: Failover script. Failed node is dropped. 
# Backup node takes his place. When no backup node, then 
# failed node is simply droppped.

cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "	Basculer sur un nouveau maître en cas de disparition de l'actuel"
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -f|--failed           Le numéro du noeud à supprimer"
  echo "   -b|--backup           Le numéro du noeud de secours"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "	Switchover a node and one of his slave, or drop that node"
  echo "  Options :"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -f|--failed           The failed node (to be dropped)"
  echo "   -b|--backup           The backup node (not mandatory)"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:f:b:h -l help,cluster:,failed:,backup: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
FILE=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		    slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -f|--failed) shift ;
                FAILED="$1"
                ;;
        -b|--backup) shift ;
                BACKUP="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$FAILED" = "x" ]; then
    slhelp;
    exit 1
fi

MASTERNODE=$FAILED


## FR : On commence par construire les tableaux de relations 
## EN: Relations and nodes arrays 

relbase_miss
if [ $? -eq 1 ]; then
    exit 1
fi

#if [ ! -e ${SLON_ETC}/bases.h -o ! -e ${SLON_ETC}/relations.h ]; then
#    if [[ x$LANG = xfr* ]]; then
#   	echo "Fichier ${SLON_ETC}/bases.h ou ${SLON_ETC}/relations.h introuvable."
#   	echo "Merci de vérifier votre installation."
#    else
#	echo "${SLON_ETC}/bases.h or ${SLON_ETC}/relations.h not found."
#	echo "Verify your setup."
#    fi
#    exit 1
#fi

node $INSTANCE
MASTERDB=${NODE[${INDEX[$MASTERNODE]}+1]}
MASTERHOST=${NODE[${INDEX[$MASTERNODE]}+2]}
MASTERPORT=${NODE[${INDEX[$MASTERNODE]}+3]}

SUPER=0
GREP_SET="grep \"\b$INSTANCE\b\" $SLON_ETC/relations.h | grep -v \"^#\" | awk '{print \$2}' | sort -u"
for SETID in `eval $GREP_SET` ; do
    relation $SETID
    echo "set : $SETID"

## FR : MASTER est le maître du set, MASTERNODE, le noeud à supprimer
# Si on supprime le noeud principal, pas de resouscription à effectuer
## EN: MASTER is set master, MASTERNODE is the node to drop.
# If MASTER is to be dropped, no resubscription occurs.
    if [ $MASTER -eq $MASTERNODE ]; then
	SUPER=1
	break;
    else
## FR : Récupération du maître
## EN: Get MASTER
	for (( j=1 ; j <= taille_rel ; j+=2 )); do
	    if [ ${REL[$j+1]} -eq $MASTERNODE ]; then
        	OLDMASTER=${REL[$j]}

## FR : Si le noeud à supprimer a un maître et des esclaves, on le shinte en
# souscrivant ses esclaves à son maître
# Avant de supprimer le noeud, il faut basculer ses souscripteurs sur le 
# noeud auquel il souscrivait lui-même
## EN: Before dropping a node, resubscribe is slaves to his master.

		for (( k=1 ; k <= taille_rel ; k+=2 )); do
		    if [ ${REL[$k]} -eq $MASTERNODE ]; then
        		SLAVENODE=${REL[$k+1]}

echo "$SLAVENODE subscribes $OLDMASTER"
			${SLON_BIN}/slonik <<_EOF_
		        #--
		        # <preamble> file inclusion
		        #--
		        INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
			
			try{
				echo '$SLAVENODE subscribes $OLDMASTER';
				subscribe set ( ID = $SETID, 
				  	PROVIDER = $OLDMASTER,
					RECEIVER = $SLAVENODE,
					FORWARD = YES );
			}
			on success { echo 'Soucription $SLAVENODE à $MASTER OK' ;}
			on error { echo 'Soucription $SLAVENODE à $MASTER KO' ;}
_EOF_
		    fi
	        done
	    fi
	done
    fi
done

SLAVENODE=${BACKUP:-$MASTER}
echo slavenode : $SLAVENODE
MASTERNODE=$FAILED

if [ $SUPER -eq 1 ]; then
    ${SLON_BIN}/slonik <<_EOF_
       	#--
       	# <preamble> file inclusion
       	#--
       	INCLUDE <${SLON_ETC}/$INSTANCE.preamble>
       
   	try{
   	    echo 'Failover $MASTERNODE - $SLAVENODE: ';
   	    FAILOVER (
   		ID = $MASTERNODE,
   		BACKUP NODE = $SLAVENODE
   	    );
   	}
   	on success{
	    echo 'OK' ;
	    exit 0 ;
	}
   	on error{
	    echo 'ko' ;
	    exit 1;
	}
_EOF_
fi


## FR :Suppression physique de MASTERNODE du réseau de réplication
## EN: MASTERNODE is dropped
${SLON_BIN}/slonik <<_EOF_
    #--
    # <preamble> file inclusion
    #--
    INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

    try{
        echo 'Drop node $MASTERNODE :';
        drop node ( ID = $MASTERNODE, EVENT NODE = $SLAVENODE );
    }
    on success { echo 'OK' ; exit 0;}
    on error { echo 'ko' ; exit 1;}
	
_EOF_

## FR : Les scripts slonik n'arrêtent pas slon pour l'ancien maître, on les
# arrête.
## EN: Slonik does not stop slon daemons. We do.

for processus in `ps auxw | grep slon | grep \b$INSTANCE\b | grep -v sh | grep \b$MASTERDB\b | awk '{print \$2}'`
do
    kill -15 ${processus}
done
if [[ x$LANG = xfr* ]]; then
    echo "Processus slon supprimes"
else
    echo "slon daemons stopped."
fi

if [[ x$LANG = xfr* ]]; then
    echo <<EOF
Le noeud $MASTERNODE a été supprimé de la réplication. N'oubliez pas de mettre à jour les 
fichiers de définition des bases de données et des relations entre elles.
EOF
else
    echo <<EOF
Node $MASTERNODE has been dropped. Don't forget to update bases.h and relations.h.
EOF
fi

exit 0
