#!/bin/bash
# Auteur : Stéphane Schildknecht

# slony_merge.sh
# Script de fusion de 2 sets
# Avant de procéder à la fusion, il faut s'assurer que les souscriptions
# des 2 sets sont identiques
# 1. Move set si nécessaire
# 2. re-souscription du set à fusionner
## EN:
# Merging two sets
# Before proceding, we have to take care the two sets have
# same providers and subscribers.
# FIXME Move set and subscription to handle if that is not the case


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

export LD_LIBRARY_PATH=$PG/lib/

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
if [[ x$LANG = xfr* ]]; then
  echo "$0"
  echo ""
  echo "Usage : $0 *options*"
  echo "  Fusion de deux sets de réplication."
  echo "  Options :"
  echo "   --help                Afficher ce message"
  echo "   -c|--cluster          Le nom de l'instance de réplication"
  echo "   -s|--set              Le numéro du set à fusionnner"
  echo "   -m|--merge            Le numéro du set de fusion"
  echo ""
else
  echo "$0"
  echo ""
  echo "Usage: $0 *options*"
  echo "  Merging two replication sets"
  echo "  Options:"
  echo "   --help                Print this help"
  echo "   -c|--cluster          The replication instance name"
  echo "   -s|--set              The set to merge"
  echo "   -m|--merge            The destination set for merge"
  echo ""
fi
}

TEMP=`getopt -n $0 -o c:s:f: -l help,cluster:,set:,file: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
SET=""
MSET=""
while [ $# -ge 1 ]; do
    case "$1" in
        --help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        -s|--set) shift ;
                SET="$1"
                ;;
        -m|--merge) shift ;
                MSET="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
                slhelp ;
                exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" -o x"$SET" = "x" -o x"$MSET" = "x" ]; then
    slhelp;
    exit 1
fi

# Do definition files exist?
relbase_miss
if [ $? -ne 0 ]; then
    exit 1
else
    preamble_miss $INSTANCE
    if [ $? -ne 0 ]; then
	exit 1
    fi
fi

# Nodes array
node $INSTANCE

# Relations array
relation $MSET

CLUSTERID=${MASTER}

# Pour tous les noeuds ayant souscrits au premier set
# le noeud souscrit le nouveau set. Lorsque tous les noeuds ont souscrit, 
# il est alors possible de fusionner les deux sets.
## EN: For any subscriber to first set, we subscribe to the
# "to-be-merged" set. When subscription is all done, we
# can merge the two sets.
for (( i=1 ; i <= taille_rel ; i+=2 )); do
        MASTERNODE=${REL[$i]}
        SLAVENODE=${REL[$i+1]}
        mtr=${INDEX[${REL[$i]}]}
        slv=${INDEX[${REL[$i+1]}]}
        if [[ x$LANG = xfr* ]]; then
	    cat <<EOF

echo "Souscription Set $MSET par $SLAVENODE :"
EOF
	else
	    cat <<EOF

echo "$SLAVENODE subscribes to set $MSET:"
EOF
    if [ $MASTERNODE -ne $MASTER ]; then
	cat <<EOF

while [ 1 ] ; do
    if [ x\`$PG/bin/psql -t ${NODE[$mtr+1]} -U ${SLONY_USER} -h ${NODE[$mtr+2]} -p ${NODE[$mtr+3]} -c "select sub_active from _$INSTANCE.sl_subscribe where sub_set=$MSET and sub_receiver=${NODE[$mtr]}" |awk '{print \$1}' |head -n 1\` = "xt" ]; then
	echo "OK"
	break;
    else
	echo -n "."
	sleep 10s
    fi
done

EOF
    fi
    cat <<EOF

$SLON_BIN/slonik <<_EOF_
         # ----
         # Preamble file
         # ----
         INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

         # ----
         # Node $SLAVENODE subscribes set $MSET
         # ----
	 echo 'Node $SLAVENODE subscribes set $MSET';
         try{
            subscribe set ( id = $MSET, provider = ${REL[$i]}, receiver = $SLAVENODE, forward = yes);
         }
         on error {
	    echo 'ko';
	    exit 1;
	    }
         on success {echo 'OK';}
         SYNC (ID = ${REL[$i]});
         WAIT FOR EVENT (ORIGIN = ${REL[$i]}, CONFIRMED = $SLAVENODE, WAIT ON = ${REL[$i]});
         #sleep (seconds = 300);
_EOF_
EOF
done


cat <<EOF
sleep 120s

# La fusion peut avoir lieu
## EN: Let's marge the sets
$SLON_BIN/slonik <<_EOF_
         # ----
         # Preamble file
         # ----
         INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

    	#--
    	# Fusion des deux sets 
	# Merging the sets
    	#--
	echo 'Merge Set $SET - $MSET -> $MSET: ';
	try{
    	    MERGE SET ( 
	      ID = $SET, 
	      ADD ID = $MSET,
              ORIGIN = $CLUSTERID );
	}
	on error {
	    echo 'ko' ;
	    exit 1 ;
	}
        on success { echo 'OK' ; }
     
_EOF_

if [ \$? -ne 0 ]; then
    exit 1;
fi
exit 0
EOF

exit 0
