#!/bin/bash
# Auteur : Stéphane Schildknecht

# SAS 20071219
# Modifications :
#  - 20071214 Bernard Choppy
#    possibilite de lancer depuis n'importe ou
#    systematisation de l'utilisation des variables
#

# slony_path.sh
## FR : Script de recréation des chemins de connexion entre
# les noeuds d'une réplication.
## EN: Script to recreate connection pathes between nodes

# Synopsis :
# slony_path.sh -c <instance>


cd `dirname $0`
cd ..
SLON=`pwd`
. $SLON/etc/slony_include.h

#################
# Les fonctions #
#################
. $SLON_ETC/fonctions.sh

slhelp() {
    if [[ x$LANG = xfr* ]]; then
	echo "$0"
    	echo ""
    	echo "Usage: $0 *options*"
    	echo -e "        recrée les informations de connexion entre les noeuds"
    	echo -e "        Attention, toutes les combinaisons sont créées"
    	echo "  Options :"
    	echo "   --help                Afficher ce message"
    	echo "   -c|--cluster          Le nom de l'instance de réplication"
    	echo ""
    else
	echo "$0"
	echo ""
	echo "Usage: $0 *options*"
	echo -e "        recreating connection information between nodes"
	echo -e "        Be careful that all combinations are created"
	echo "  Options :"
	echo "   --help                Print this help"
	echo "   -c|--cluster          The replication instance name"
	echo ""
    fi
}

TEMP=`getopt -n $0 -o c:h -l help,cluster: -- "$@"`
if [ $? != 0 ] ; then
        echo "$0 error..." >&2 ;
        echo "$0 --help to get help" ; exit 1 ;
fi
eval set -- "$TEMP"

INSTANCE=""
while [ $# -ge 1 ]; do
    case "$1" in
        -h|--help)
                HELP=1 ; 
		slhelp;
		exit 0 ;;
        -c|--cluster) shift ;
                INSTANCE="$1"
                ;;
        --) shift ;
                break
                ;;
        *)
		echo "Warning!";
		slhelp ;
               exit 1
                ;;
    esac
    shift
done

if [ x"$INSTANCE" = "x" ]; then
    slhelp;
    exit 1
fi

## FR : Récupération des informations sur les noeuds
## EN: Get nodes information
relbase_miss
if [ $? -ne 0 ]; then
    exit 1
else
    preamble_miss $INSTANCE
    if [ $? -ne 0 ]; then
	exit 1
    fi
fi

node $INSTANCE

cat <<EOF
#!/bin/bash

EOF
if [[ x$LANG = xfr* ]]; then
    cat <<EOF
# Script slonik de recréation des informations
EOF
else
    cat <<EOF
# Slonik script to recreate path information
EOF
fi

cat << EOF
${SLON_BIN}/slonik <<_EOF_
EOF

if [[ x$LANG = xfr* ]]; then
    cat <<EOF

        # Fichier contenant les informations de connexions et
        # l'identification des noeuds de la replication
EOF
else
    cat <<EOF

	# Preamble file: contains all useful information
	# about nodes
EOF
fi
cat <<EOF
        INCLUDE <${SLON_ETC}/$INSTANCE.preamble>

EOF

## FR : Les autres noeuds de la réplication
## EN: Other nodes
for (( i=1 ; i <= taille_nod ; i+=4 )); do
    NODE1=${NODE[$i]}
    BASE1=${NODE[$i+1]}
    HOST1=${NODE[$i+2]}
    PORT1=${NODE[$i+3]}

## FR : Liens entre un noeud et les autres (numéros supérieurs)
## EN: Links between one node and others (higher numbers)
    for (( j=i ; j <= taille_nod ; j+=4 )); do
	if [ $i -ne $j ]; then
	    NODE2=${NODE[$j]}
            BASE2=${NODE[$j+1]}
            HOST2=${NODE[$j+2]}
            PORT2=${NODE[$j+3]}
	#>>$SLON_TEMP/${INSTANCE}_path.sh
            cat <<EOF 
	echo 'Drop path $NODE1 <-> $NODE2:';
	try{
	    drop path (server = $NODE1, client = $NODE2, event node = $NODE1 );
	    drop path (server = $NODE2, client = $NODE1, event node = $NODE2 );
	}
        on error {echo 'ko';}
        on success {echo 'OK';}
	
	echo 'Store path $NODE1 <-> $NODE2:';
	try {
	    store path (server = $NODE1, client = $NODE2, conninfo='dbname=$BASE1 host=$HOST1 port=$PORT1 user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}');
	    store path (server = $NODE2, client = $NODE1, conninfo='dbname=$BASE2 host=$HOST2 port=$PORT2 user=${SLONY_USER}${SLONY_PWD:+ password=$SLONY_PWD}');
	}
        on error {
	    echo 'ko';
	    exit 1;}
        on success {echo 'OK';}

EOF
 	fi
    done
done
cat <<EOF 
_EOF_
EOF

exit 0
